/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.catalog.EndpointValidationResult;
import org.apache.camel.catalog.SimpleValidationResult;
import org.apache.camel.catalog.SuggestionStrategy;
import org.apache.camel.catalog.VersionManager;
import org.apache.camel.catalog.lucene.LuceneSuggestionStrategy;
import org.apache.camel.catalog.maven.MavenVersionManager;
import org.apache.camel.maven.helper.EndpointHelper;
import org.apache.camel.parser.RouteBuilderParser;
import org.apache.camel.parser.XmlRouteParser;
import org.apache.camel.parser.model.CamelEndpointDetails;
import org.apache.camel.parser.model.CamelRouteDetails;
import org.apache.camel.parser.model.CamelSimpleExpressionDetails;
import org.apache.camel.util.StringHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.exec.AbstractExecMojo;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.JavaClassSource;

@Mojo(name="validate", threadSafe=true)
public class ValidateMojo
extends AbstractExecMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="camel.failOnError", defaultValue="false")
    private boolean failOnError;
    @Parameter(property="camel.logUnparseable", defaultValue="false")
    private boolean logUnparseable;
    @Parameter(property="camel.includeJava", defaultValue="true")
    private boolean includeJava;
    @Parameter(property="camel.includeXml", defaultValue="true")
    private boolean includeXml;
    @Parameter(property="camel.includeTest", defaultValue="false")
    private boolean includeTest;
    @Parameter(property="camel.includes")
    private String includes;
    @Parameter(property="camel.excludes")
    private String excludes;
    @Parameter(property="camel.ignoreUnknownComponent", defaultValue="true")
    private boolean ignoreUnknownComponent;
    @Parameter(property="camel.ignoreIncapable", defaultValue="true")
    private boolean ignoreIncapable;
    @Parameter(property="camel.ignoreDeprecated", defaultValue="true")
    private boolean ignoreDeprecated;
    @Parameter(property="camel.ignoreLenientProperties", defaultValue="true")
    private boolean ignoreLenientProperties;
    @Parameter(property="camel.showAll", defaultValue="false")
    private boolean showAll;
    @Parameter(property="camel.downloadVersion", defaultValue="true")
    private boolean downloadVersion;
    @Parameter(property="camel.duplicateRouteId", defaultValue="true")
    private boolean duplicateRouteId;
    @Parameter(property="camel.directOrSedaPairCheck", defaultValue="true")
    private boolean directOrSedaPairCheck;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String simpleSummary;
        int ok;
        String endpointSummary;
        int ok2;
        ArrayList fileEndpoints;
        String dir;
        Object obj;
        Iterator iterator;
        Object list;
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        catalog.addComponent("activemq", "org.apache.activemq.camel.component.ActiveMQComponent");
        catalog.setSuggestionStrategy((SuggestionStrategy)new LuceneSuggestionStrategy());
        catalog.setVersionManager((VersionManager)new MavenVersionManager());
        catalog.enableCache();
        String detectedVersion = ValidateMojo.findCamelVersion(this.project);
        if (detectedVersion != null) {
            this.getLog().info((CharSequence)("Detected Camel version used in project: " + detectedVersion));
        }
        if (this.downloadVersion) {
            String catalogVersion = catalog.getCatalogVersion();
            String version = ValidateMojo.findCamelVersion(this.project);
            if (version != null && !version.equals(catalogVersion)) {
                this.getLog().info((CharSequence)("Downloading Camel version: " + version));
                boolean loaded = catalog.loadVersion(version);
                if (!loaded) {
                    this.getLog().warn((CharSequence)("Error downloading Camel version: " + version));
                }
            }
        }
        if (catalog.getLoadedVersion() != null) {
            this.getLog().info((CharSequence)("Validating using downloaded Camel version: " + catalog.getLoadedVersion()));
        } else {
            this.getLog().info((CharSequence)("Validating using Camel version: " + catalog.getCatalogVersion()));
        }
        ArrayList<CamelEndpointDetails> endpoints = new ArrayList<CamelEndpointDetails>();
        ArrayList<CamelSimpleExpressionDetails> simpleExpressions = new ArrayList<CamelSimpleExpressionDetails>();
        ArrayList<CamelRouteDetails> routeIds = new ArrayList<CamelRouteDetails>();
        LinkedHashSet<File> javaFiles = new LinkedHashSet<File>();
        LinkedHashSet<File> xmlFiles = new LinkedHashSet<File>();
        if (this.includeJava) {
            list = this.project.getCompileSourceRoots();
            iterator = list.iterator();
            while (iterator.hasNext()) {
                obj = iterator.next();
                dir = (String)obj;
                this.findJavaFiles(new File(dir), javaFiles);
            }
            if (this.includeTest) {
                list = this.project.getTestCompileSourceRoots();
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    obj = iterator.next();
                    dir = (String)obj;
                    this.findJavaFiles(new File(dir), javaFiles);
                }
            }
        }
        if (this.includeXml) {
            list = this.project.getResources();
            iterator = list.iterator();
            while (iterator.hasNext()) {
                obj = iterator.next();
                dir = (Resource)obj;
                this.findXmlFiles(new File(dir.getDirectory()), xmlFiles);
            }
            if (this.includeTest) {
                list = this.project.getTestResources();
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    obj = iterator.next();
                    dir = (Resource)obj;
                    this.findXmlFiles(new File(dir.getDirectory()), xmlFiles);
                }
            }
        }
        for (File file : javaFiles) {
            if (!this.matchFile(file)) continue;
            try {
                fileEndpoints = new ArrayList();
                ArrayList fileRouteIds = new ArrayList();
                ArrayList fileSimpleExpressions = new ArrayList();
                ArrayList unparsable = new ArrayList();
                String fqn = file.getPath();
                String baseDir = ".";
                JavaType out = Roaster.parse((File)file);
                if (!(out instanceof JavaClassSource)) continue;
                JavaClassSource clazz = (JavaClassSource)out;
                RouteBuilderParser.parseRouteBuilderEndpoints((JavaClassSource)clazz, (String)baseDir, (String)fqn, fileEndpoints, unparsable, (boolean)this.includeTest);
                RouteBuilderParser.parseRouteBuilderSimpleExpressions((JavaClassSource)clazz, (String)baseDir, (String)fqn, fileSimpleExpressions);
                if (this.duplicateRouteId) {
                    RouteBuilderParser.parseRouteBuilderRouteIds((JavaClassSource)clazz, (String)baseDir, (String)fqn, fileRouteIds);
                }
                endpoints.addAll(fileEndpoints);
                simpleExpressions.addAll(fileSimpleExpressions);
                routeIds.addAll(fileRouteIds);
                if (!this.logUnparseable || unparsable.isEmpty()) continue;
                for (String uri : unparsable) {
                    this.getLog().warn((CharSequence)("Cannot parse endpoint uri " + uri + " in java file " + file));
                }
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Error parsing java file " + file + " code due " + e.getMessage()), (Throwable)e);
            }
        }
        for (File file : xmlFiles) {
            if (!this.matchFile(file)) continue;
            try {
                fileEndpoints = new ArrayList();
                ArrayList fileSimpleExpressions = new ArrayList();
                ArrayList fileRouteIds = new ArrayList();
                String fqn = file.getPath();
                String baseDir = ".";
                FileInputStream is = new FileInputStream(file);
                XmlRouteParser.parseXmlRouteEndpoints((InputStream)is, (String)baseDir, (String)fqn, fileEndpoints);
                ((InputStream)is).close();
                is = new FileInputStream(file);
                XmlRouteParser.parseXmlRouteSimpleExpressions((InputStream)is, (String)baseDir, (String)fqn, fileSimpleExpressions);
                ((InputStream)is).close();
                if (this.duplicateRouteId) {
                    is = new FileInputStream(file);
                    XmlRouteParser.parseXmlRouteRouteIds((InputStream)is, (String)baseDir, (String)fqn, (List)fileRouteIds);
                    ((InputStream)is).close();
                }
                endpoints.addAll(fileEndpoints);
                simpleExpressions.addAll(fileSimpleExpressions);
                routeIds.addAll(fileRouteIds);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Error parsing xml file " + file + " code due " + e.getMessage()), (Throwable)e);
            }
        }
        int endpointErrors = 0;
        int unknownComponents = 0;
        int incapableErrors = 0;
        int deprecatedOptions = 0;
        for (CamelEndpointDetails detail : endpoints) {
            String fqn;
            StringBuilder sb;
            this.getLog().debug((CharSequence)("Validating endpoint: " + detail.getEndpointUri()));
            EndpointValidationResult result = catalog.validateEndpointProperties(detail.getEndpointUri(), this.ignoreLenientProperties);
            int deprecated = result.getDeprecated() != null ? result.getDeprecated().size() : 0;
            deprecatedOptions += deprecated;
            boolean ok3 = result.isSuccess();
            if (!ok3 && this.ignoreUnknownComponent && result.getUnknownComponent() != null) {
                ++unknownComponents;
                ok3 = true;
            }
            if (!ok3 && this.ignoreIncapable && result.getIncapable() != null) {
                ++incapableErrors;
                ok3 = true;
            }
            if (ok3 && !this.ignoreDeprecated && deprecated > 0) {
                ok3 = false;
            }
            if (!ok3) {
                if (result.getUnknownComponent() != null) {
                    ++unknownComponents;
                } else if (result.getIncapable() != null) {
                    ++incapableErrors;
                } else {
                    ++endpointErrors;
                }
                sb = new StringBuilder();
                sb.append("Endpoint validation error at: ");
                if (detail.getClassName() != null && detail.getLineNumber() != null) {
                    sb.append(detail.getClassName());
                    if (detail.getMethodName() != null) {
                        sb.append(".").append(detail.getMethodName());
                    }
                    sb.append("(").append(ValidateMojo.asSimpleClassName(detail.getClassName())).append(".java:");
                    sb.append(detail.getLineNumber()).append(")");
                } else if (detail.getLineNumber() != null) {
                    fqn = this.stripRootPath(this.asRelativeFile(detail.getFileName()));
                    if (fqn.endsWith(".xml")) {
                        fqn = fqn.substring(0, fqn.length() - 4);
                        fqn = ValidateMojo.asPackageName(fqn);
                    }
                    sb.append(fqn);
                    sb.append("(").append(ValidateMojo.asSimpleClassName(fqn)).append(".xml:");
                    sb.append(detail.getLineNumber()).append(")");
                } else {
                    sb.append(detail.getFileName());
                }
                sb.append("\n\n");
                String out = result.summaryErrorMessage(false, this.ignoreDeprecated);
                sb.append(out);
                sb.append("\n\n");
                this.getLog().warn((CharSequence)sb.toString());
                continue;
            }
            if (!this.showAll) continue;
            sb = new StringBuilder();
            sb.append("Endpoint validation passsed at: ");
            if (detail.getClassName() != null && detail.getLineNumber() != null) {
                sb.append(detail.getClassName());
                if (detail.getMethodName() != null) {
                    sb.append(".").append(detail.getMethodName());
                }
                sb.append("(").append(ValidateMojo.asSimpleClassName(detail.getClassName())).append(".java:");
                sb.append(detail.getLineNumber()).append(")");
            } else if (detail.getLineNumber() != null) {
                fqn = this.stripRootPath(this.asRelativeFile(detail.getFileName()));
                if (fqn.endsWith(".xml")) {
                    fqn = fqn.substring(0, fqn.length() - 4);
                    fqn = ValidateMojo.asPackageName(fqn);
                }
                sb.append(fqn);
                sb.append("(").append(ValidateMojo.asSimpleClassName(fqn)).append(".xml:");
                sb.append(detail.getLineNumber()).append(")");
            } else {
                sb.append(detail.getFileName());
            }
            sb.append("\n");
            sb.append("\n\t").append(result.getUri());
            sb.append("\n\n");
            this.getLog().info((CharSequence)sb.toString());
        }
        if (endpointErrors == 0) {
            ok2 = endpoints.size() - endpointErrors - incapableErrors - unknownComponents;
            endpointSummary = String.format("Endpoint validation success: (%s = passed, %s = invalid, %s = incapable, %s = unknown components, %s = deprecated options)", ok2, endpointErrors, incapableErrors, unknownComponents, deprecatedOptions);
        } else {
            ok2 = endpoints.size() - endpointErrors - incapableErrors - unknownComponents;
            endpointSummary = String.format("Endpoint validation error: (%s = passed, %s = invalid, %s = incapable, %s = unknown components, %s = deprecated options)", ok2, endpointErrors, incapableErrors, unknownComponents, deprecatedOptions);
        }
        if (endpointErrors > 0) {
            this.getLog().warn((CharSequence)endpointSummary);
        } else {
            this.getLog().info((CharSequence)endpointSummary);
        }
        int simpleErrors = this.validateSimple((CamelCatalog)catalog, simpleExpressions);
        if (simpleErrors == 0) {
            ok = simpleExpressions.size() - simpleErrors;
            simpleSummary = String.format("Simple validation success: (%s = passed, %s = invalid)", ok, simpleErrors);
        } else {
            ok = simpleExpressions.size() - simpleErrors;
            simpleSummary = String.format("Simple validation error: (%s = passed, %s = invalid)", ok, simpleErrors);
        }
        if (simpleErrors > 0) {
            this.getLog().warn((CharSequence)simpleSummary);
        } else {
            this.getLog().info((CharSequence)simpleSummary);
        }
        int sedaDirectErrors = 0;
        String sedaDirectSummary = "";
        if (this.directOrSedaPairCheck) {
            long sedaDirectEndpoints = this.countEndpointPairs(endpoints, "direct") + this.countEndpointPairs(endpoints, "seda");
            sedaDirectSummary = (sedaDirectErrors += this.validateEndpointPairs(endpoints, "direct") + this.validateEndpointPairs(endpoints, "seda")) == 0 ? String.format("Endpoint pair (seda/direct) validation success (%s = pairs)", sedaDirectEndpoints) : String.format("Endpoint pair (seda/direct) validation error: (%s = pairs, %s = non-pairs)", sedaDirectEndpoints, sedaDirectErrors);
            if (sedaDirectErrors > 0) {
                this.getLog().warn((CharSequence)sedaDirectSummary);
            } else {
                this.getLog().info((CharSequence)sedaDirectSummary);
            }
        }
        int duplicateRouteIdErrors = this.validateDuplicateRouteId(routeIds);
        String routeIdSummary = "";
        if (this.duplicateRouteId) {
            routeIdSummary = duplicateRouteIdErrors == 0 ? String.format("Duplicate route id validation success (%s = ids)", routeIds.size()) : String.format("Duplicate route id validation error: (%s = ids, %s = duplicates)", routeIds.size(), duplicateRouteIdErrors);
            if (duplicateRouteIdErrors > 0) {
                this.getLog().warn((CharSequence)routeIdSummary);
            } else {
                this.getLog().info((CharSequence)routeIdSummary);
            }
        }
        if (this.failOnError && (endpointErrors > 0 || simpleErrors > 0 || duplicateRouteIdErrors > 0) || sedaDirectErrors > 0) {
            throw new MojoExecutionException(endpointSummary + "\n" + simpleSummary + "\n" + routeIdSummary + "\n" + sedaDirectSummary);
        }
    }

    private int countEndpointPairs(List<CamelEndpointDetails> endpoints, String scheme) {
        int pairs = 0;
        Set consumers = endpoints.stream().filter(e -> e.isConsumerOnly() && e.getEndpointUri().startsWith(scheme + ":")).collect(Collectors.toSet());
        Set producers = endpoints.stream().filter(e -> e.isProducerOnly() && e.getEndpointUri().startsWith(scheme + ":")).collect(Collectors.toSet());
        for (CamelEndpointDetails p : producers) {
            boolean any = consumers.stream().anyMatch(c -> ValidateMojo.matchEndpointPath(p.getEndpointUri(), c.getEndpointUri()));
            if (!any) continue;
            ++pairs;
        }
        return pairs;
    }

    private int validateEndpointPairs(List<CamelEndpointDetails> endpoints, String scheme) {
        int errors = 0;
        Set consumers = endpoints.stream().filter(e -> e.isConsumerOnly() && e.getEndpointUri().startsWith(scheme + ":")).collect(Collectors.toSet());
        Set producers = endpoints.stream().filter(e -> e.isProducerOnly() && e.getEndpointUri().startsWith(scheme + ":")).collect(Collectors.toSet());
        for (CamelEndpointDetails detail : producers) {
            String fqn;
            StringBuilder sb;
            boolean none = consumers.stream().noneMatch(c -> ValidateMojo.matchEndpointPath(detail.getEndpointUri(), c.getEndpointUri()));
            if (none) {
                ++errors;
                sb = new StringBuilder();
                sb.append("Endpoint pair (seda/direct) validation error at: ");
                if (detail.getClassName() != null && detail.getLineNumber() != null) {
                    sb.append(detail.getClassName());
                    if (detail.getMethodName() != null) {
                        sb.append(".").append(detail.getMethodName());
                    }
                    sb.append("(").append(ValidateMojo.asSimpleClassName(detail.getClassName())).append(".java:");
                    sb.append(detail.getLineNumber()).append(")");
                } else if (detail.getLineNumber() != null) {
                    fqn = this.stripRootPath(this.asRelativeFile(detail.getFileName()));
                    if (fqn.endsWith(".xml")) {
                        fqn = fqn.substring(0, fqn.length() - 4);
                        fqn = ValidateMojo.asPackageName(fqn);
                    }
                    sb.append(fqn);
                    sb.append("(").append(ValidateMojo.asSimpleClassName(fqn)).append(".xml:");
                    sb.append(detail.getLineNumber()).append(")");
                } else {
                    sb.append(detail.getFileName());
                }
                sb.append("\n");
                sb.append("\n\t").append(detail.getEndpointUri());
                sb.append("\n\n\t\t\t\t").append(ValidateMojo.endpointPathSummaryError(detail));
                sb.append("\n\n");
                this.getLog().warn((CharSequence)sb.toString());
                continue;
            }
            if (!this.showAll) continue;
            sb = new StringBuilder();
            sb.append("Endpoint pair (seda/direct) validation passed at: ");
            if (detail.getClassName() != null && detail.getLineNumber() != null) {
                sb.append(detail.getClassName());
                if (detail.getMethodName() != null) {
                    sb.append(".").append(detail.getMethodName());
                }
                sb.append("(").append(ValidateMojo.asSimpleClassName(detail.getClassName())).append(".java:");
                sb.append(detail.getLineNumber()).append(")");
            } else if (detail.getLineNumber() != null) {
                fqn = this.stripRootPath(this.asRelativeFile(detail.getFileName()));
                if (fqn.endsWith(".xml")) {
                    fqn = fqn.substring(0, fqn.length() - 4);
                    fqn = ValidateMojo.asPackageName(fqn);
                }
                sb.append(fqn);
                sb.append("(").append(ValidateMojo.asSimpleClassName(fqn)).append(".xml:");
                sb.append(detail.getLineNumber()).append(")");
            } else {
                sb.append(detail.getFileName());
            }
            sb.append("\n");
            sb.append("\n\t").append(detail.getEndpointUri());
            sb.append("\n\n");
            this.getLog().info((CharSequence)sb.toString());
        }
        return errors;
    }

    private static String endpointPathSummaryError(CamelEndpointDetails detail) {
        String uri = detail.getEndpointUri();
        String p = uri.contains("?") ? StringHelper.before((String)uri, (String)"?") : uri;
        String path = StringHelper.after((String)p, (String)":");
        return path + "\tSending to non existing " + detail.getEndpointComponentName() + " queue name";
    }

    private static boolean matchEndpointPath(String uri, String uri2) {
        String p = uri.contains("?") ? StringHelper.before((String)uri, (String)"?") : uri;
        String p2 = uri2.contains("?") ? StringHelper.before((String)uri2, (String)"?") : uri2;
        p = p.trim();
        p2 = p2.trim();
        return p.equals(p2);
    }

    private int validateSimple(CamelCatalog catalog, List<CamelSimpleExpressionDetails> simpleExpressions) {
        int simpleErrors = 0;
        for (CamelSimpleExpressionDetails detail : simpleExpressions) {
            String fqn;
            StringBuilder sb;
            SimpleValidationResult result;
            boolean predicate = detail.isPredicate();
            if (predicate) {
                this.getLog().debug((CharSequence)("Validating simple predicate: " + detail.getSimple()));
                result = catalog.validateSimplePredicate(null, detail.getSimple());
            } else {
                this.getLog().debug((CharSequence)("Validating simple expression: " + detail.getSimple()));
                result = catalog.validateSimpleExpression(null, detail.getSimple());
            }
            if (!result.isSuccess()) {
                String[] lines;
                ++simpleErrors;
                sb = new StringBuilder();
                sb.append("Simple validation error at: ");
                if (detail.getClassName() != null && detail.getLineNumber() != null) {
                    sb.append(detail.getClassName());
                    if (detail.getMethodName() != null) {
                        sb.append(".").append(detail.getMethodName());
                    }
                    sb.append("(").append(ValidateMojo.asSimpleClassName(detail.getClassName())).append(".java:");
                    sb.append(detail.getLineNumber()).append(")");
                } else if (detail.getLineNumber() != null) {
                    fqn = this.stripRootPath(this.asRelativeFile(detail.getFileName()));
                    if (fqn.endsWith(".xml")) {
                        fqn = fqn.substring(0, fqn.length() - 4);
                        fqn = ValidateMojo.asPackageName(fqn);
                    }
                    sb.append(fqn);
                    sb.append("(").append(ValidateMojo.asSimpleClassName(fqn)).append(".xml:");
                    sb.append(detail.getLineNumber()).append(")");
                } else {
                    sb.append(detail.getFileName());
                }
                sb.append("\n");
                for (String line : lines = result.getError().split("\n")) {
                    sb.append("\n\t").append(line);
                }
                sb.append("\n");
                this.getLog().warn((CharSequence)sb.toString());
                continue;
            }
            if (!this.showAll) continue;
            sb = new StringBuilder();
            sb.append("Simple validation passed at: ");
            if (detail.getClassName() != null && detail.getLineNumber() != null) {
                sb.append(detail.getClassName());
                if (detail.getMethodName() != null) {
                    sb.append(".").append(detail.getMethodName());
                }
                sb.append("(").append(ValidateMojo.asSimpleClassName(detail.getClassName())).append(".java:");
                sb.append(detail.getLineNumber()).append(")");
            } else if (detail.getLineNumber() != null) {
                fqn = this.stripRootPath(this.asRelativeFile(detail.getFileName()));
                if (fqn.endsWith(".xml")) {
                    fqn = fqn.substring(0, fqn.length() - 4);
                    fqn = ValidateMojo.asPackageName(fqn);
                }
                sb.append(fqn);
                sb.append("(").append(ValidateMojo.asSimpleClassName(fqn)).append(".xml:");
                sb.append(detail.getLineNumber()).append(")");
            } else {
                sb.append(detail.getFileName());
            }
            sb.append("\n");
            sb.append("\n\t").append(result.getText());
            sb.append("\n\n");
            this.getLog().info((CharSequence)sb.toString());
        }
        return simpleErrors;
    }

    private int validateDuplicateRouteId(List<CamelRouteDetails> routeIds) {
        int duplicateRouteIdErrors = 0;
        if (this.duplicateRouteId) {
            for (CamelRouteDetails detail : routeIds) {
                String fqn;
                StringBuilder sb;
                if (detail.getRouteId() == null || "".equals(detail.getRouteId())) continue;
                int count = ValidateMojo.countRouteId(routeIds, detail.getRouteId());
                if (count > 1) {
                    ++duplicateRouteIdErrors;
                    sb = new StringBuilder();
                    sb.append("Duplicate route id validation error at: ");
                    if (detail.getClassName() != null && detail.getLineNumber() != null) {
                        sb.append(detail.getClassName());
                        if (detail.getMethodName() != null) {
                            sb.append(".").append(detail.getMethodName());
                        }
                        sb.append("(").append(ValidateMojo.asSimpleClassName(detail.getClassName())).append(".java:");
                        sb.append(detail.getLineNumber()).append(")");
                    } else if (detail.getLineNumber() != null) {
                        fqn = this.stripRootPath(this.asRelativeFile(detail.getFileName()));
                        if (fqn.endsWith(".xml")) {
                            fqn = fqn.substring(0, fqn.length() - 4);
                            fqn = ValidateMojo.asPackageName(fqn);
                        }
                        sb.append(fqn);
                        sb.append("(").append(ValidateMojo.asSimpleClassName(fqn)).append(".xml:");
                        sb.append(detail.getLineNumber()).append(")");
                    } else {
                        sb.append(detail.getFileName());
                    }
                    sb.append("\n");
                    sb.append("\n\t").append(detail.getRouteId());
                    sb.append("\n\n");
                    this.getLog().warn((CharSequence)sb.toString());
                    continue;
                }
                if (!this.showAll) continue;
                sb = new StringBuilder();
                sb.append("Duplicate route id validation passed at: ");
                if (detail.getClassName() != null && detail.getLineNumber() != null) {
                    sb.append(detail.getClassName());
                    if (detail.getMethodName() != null) {
                        sb.append(".").append(detail.getMethodName());
                    }
                    sb.append("(").append(ValidateMojo.asSimpleClassName(detail.getClassName())).append(".java:");
                    sb.append(detail.getLineNumber()).append(")");
                } else if (detail.getLineNumber() != null) {
                    fqn = this.stripRootPath(this.asRelativeFile(detail.getFileName()));
                    if (fqn.endsWith(".xml")) {
                        fqn = fqn.substring(0, fqn.length() - 4);
                        fqn = ValidateMojo.asPackageName(fqn);
                    }
                    sb.append(fqn);
                    sb.append("(").append(ValidateMojo.asSimpleClassName(fqn)).append(".xml:");
                    sb.append(detail.getLineNumber()).append(")");
                } else {
                    sb.append(detail.getFileName());
                }
                sb.append("\n");
                sb.append("\n\t").append(detail.getRouteId());
                sb.append("\n\n");
                this.getLog().info((CharSequence)sb.toString());
            }
        }
        return duplicateRouteIdErrors;
    }

    private static int countRouteId(List<CamelRouteDetails> details, String routeId) {
        int answer = 0;
        for (CamelRouteDetails detail : details) {
            if (!routeId.equals(detail.getRouteId())) continue;
            ++answer;
        }
        return answer;
    }

    private static String findCamelVersion(MavenProject project) {
        Dependency candidate = null;
        List list = project.getDependencies();
        for (Object obj : list) {
            Dependency dep = (Dependency)obj;
            if (!"org.apache.camel".equals(dep.getGroupId())) continue;
            if ("camel-core".equals(dep.getArtifactId())) {
                candidate = dep;
                break;
            }
            candidate = dep;
        }
        if (candidate != null) {
            return candidate.getVersion();
        }
        return null;
    }

    private void findJavaFiles(File dir, Set<File> javaFiles) {
        File[] files;
        File[] fileArray = files = dir.isDirectory() ? dir.listFiles() : null;
        if (files != null) {
            for (File file : files) {
                if (file.getName().endsWith(".java")) {
                    javaFiles.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.findJavaFiles(file, javaFiles);
            }
        }
    }

    private void findXmlFiles(File dir, Set<File> xmlFiles) {
        File[] files;
        File[] fileArray = files = dir.isDirectory() ? dir.listFiles() : null;
        if (files != null) {
            for (File file : files) {
                if (file.getName().endsWith(".xml")) {
                    xmlFiles.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.findXmlFiles(file, xmlFiles);
            }
        }
    }

    private boolean matchFile(File file) {
        boolean match;
        String fqn;
        if (this.excludes == null && this.includes == null) {
            return true;
        }
        if (this.excludes != null) {
            for (String exclude : this.excludes.split(",")) {
                exclude = exclude.trim();
                fqn = this.stripRootPath(this.asRelativeFile(file.getAbsolutePath()));
                boolean bl = match = EndpointHelper.matchPattern(fqn, exclude) || EndpointHelper.matchPattern(file.getName(), exclude);
                if (!match) continue;
                return false;
            }
        }
        if (this.includes != null) {
            for (String include : this.includes.split(",")) {
                include = include.trim();
                fqn = this.stripRootPath(this.asRelativeFile(file.getAbsolutePath()));
                boolean bl = match = EndpointHelper.matchPattern(fqn, include) || EndpointHelper.matchPattern(file.getName(), include);
                if (!match) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private String asRelativeFile(String name) {
        String answer = name;
        String base = this.project.getBasedir().getAbsolutePath();
        if (name.startsWith(base) && (answer = name.substring(base.length())).startsWith(File.separator)) {
            answer = answer.substring(1);
        }
        return answer;
    }

    private String stripRootPath(String name) {
        String dir;
        Resource resource;
        String dir2;
        List list = this.project.getCompileSourceRoots();
        for (Object obj : list) {
            dir2 = (String)obj;
            if (!name.startsWith(dir2 = this.asRelativeFile(dir2))) continue;
            return name.substring(dir2.length() + 1);
        }
        list = this.project.getTestCompileSourceRoots();
        for (Object obj : list) {
            dir2 = (String)obj;
            if (!name.startsWith(dir2 = this.asRelativeFile(dir2))) continue;
            return name.substring(dir2.length() + 1);
        }
        List resources = this.project.getResources();
        for (Object obj : resources) {
            resource = (Resource)obj;
            dir = this.asRelativeFile(resource.getDirectory());
            if (!name.startsWith(dir)) continue;
            return name.substring(dir.length() + 1);
        }
        resources = this.project.getTestResources();
        for (Object obj : resources) {
            resource = (Resource)obj;
            dir = this.asRelativeFile(resource.getDirectory());
            if (!name.startsWith(dir)) continue;
            return name.substring(dir.length() + 1);
        }
        return name;
    }

    private static String asPackageName(String name) {
        return name.replace(File.separator, ".");
    }

    private static String asSimpleClassName(String className) {
        int dot = className.lastIndexOf(46);
        if (dot > 0) {
            return className.substring(dot + 1);
        }
        return className;
    }
}

