/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.prometheus;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.prometheusmetrics.PrometheusConfig;
import io.micrometer.prometheusmetrics.PrometheusMeterRegistry;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.BlockingHandlerDecorator;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.camel.CamelContext;
import org.apache.camel.StaticService;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.micrometer.MicrometerUtils;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerExchangeEventNotifier;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerExchangeEventNotifierNamingStrategy;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerRouteEventNotifier;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerRouteEventNotifierNamingStrategy;
import org.apache.camel.component.micrometer.messagehistory.MicrometerMessageHistoryFactory;
import org.apache.camel.component.micrometer.messagehistory.MicrometerMessageHistoryNamingStrategy;
import org.apache.camel.component.micrometer.prometheus.BindersHelper;
import org.apache.camel.component.micrometer.routepolicy.MicrometerRoutePolicyFactory;
import org.apache.camel.component.micrometer.routepolicy.MicrometerRoutePolicyNamingStrategy;
import org.apache.camel.component.platform.http.PlatformHttpComponent;
import org.apache.camel.component.platform.http.main.MainHttpServer;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpRouter;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.CamelMetricsService;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.SimpleEventNotifierSupport;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdkService(value="micrometer-prometheus")
@Configurer
@ManagedResource(description="Micrometer Metrics Prometheus")
public class MicrometerPrometheus
extends ServiceSupport
implements CamelMetricsService,
StaticService {
    private static final Logger LOG = LoggerFactory.getLogger(MicrometerPrometheus.class);
    private static final String CONTENT_TYPE_004 = "text/plain; version=0.0.4; charset=utf-8";
    private static final String CONTENT_TYPE_100 = "application/openmetrics-text; version=1.0.0; charset=utf-8";
    private MainHttpServer server;
    private VertxPlatformHttpRouter router;
    private PlatformHttpComponent platformHttpComponent;
    private CamelContext camelContext;
    private PrometheusMeterRegistry meterRegistry;
    private final Set<MeterBinder> createdBinders = new HashSet<MeterBinder>();
    @Metadata(defaultValue="default", enums="default,legacy")
    private String namingStrategy;
    @Metadata(defaultValue="true")
    private boolean enableRoutePolicy = true;
    @Metadata(defaultValue="all", enums="all,route,context")
    private String routePolicyLevel = "all";
    @Metadata(defaultValue="false")
    private boolean enableMessageHistory;
    @Metadata(defaultValue="true")
    private boolean enableExchangeEventNotifier = true;
    @Metadata(defaultValue="true")
    private boolean enableRouteEventNotifier = true;
    @Metadata(defaultValue="true")
    private boolean clearOnReload = true;
    @Metadata(defaultValue="0.0.4", enums="0.0.4,1.0.0")
    private String textFormatVersion = "0.0.4";
    @Metadata
    private String binders;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(String namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public boolean isEnableRoutePolicy() {
        return this.enableRoutePolicy;
    }

    public void setEnableRoutePolicy(boolean enableRoutePolicy) {
        this.enableRoutePolicy = enableRoutePolicy;
    }

    public String getRoutePolicyLevel() {
        return this.routePolicyLevel;
    }

    public void setRoutePolicyLevel(String routePolicyLevel) {
        this.routePolicyLevel = routePolicyLevel;
    }

    public boolean isEnableMessageHistory() {
        return this.enableMessageHistory;
    }

    public void setEnableMessageHistory(boolean enableMessageHistory) {
        this.enableMessageHistory = enableMessageHistory;
    }

    public boolean isEnableExchangeEventNotifier() {
        return this.enableExchangeEventNotifier;
    }

    public void setEnableExchangeEventNotifier(boolean enableExchangeEventNotifier) {
        this.enableExchangeEventNotifier = enableExchangeEventNotifier;
    }

    public boolean isEnableRouteEventNotifier() {
        return this.enableRouteEventNotifier;
    }

    public void setEnableRouteEventNotifier(boolean enableRouteEventNotifier) {
        this.enableRouteEventNotifier = enableRouteEventNotifier;
    }

    public boolean isClearOnReload() {
        return this.clearOnReload;
    }

    public void setClearOnReload(boolean clearOnReload) {
        this.clearOnReload = clearOnReload;
    }

    public String getTextFormatVersion() {
        return this.textFormatVersion;
    }

    public void setTextFormatVersion(String textFormatVersion) {
        this.textFormatVersion = textFormatVersion;
    }

    public String getBinders() {
        return this.binders;
    }

    public void setBinders(String binders) {
        this.binders = binders;
    }

    protected void doInit() throws Exception {
        MicrometerExchangeEventNotifier notifier;
        super.doInit();
        if (this.meterRegistry == null) {
            Registry camelRegistry = this.getCamelContext().getRegistry();
            MeterRegistry found = MicrometerUtils.getMeterRegistryFromCamelRegistry((Registry)camelRegistry, (String)"metricsRegistry");
            if (found == null) {
                found = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
                camelRegistry.bind("metricsRegistry", (Object)found);
            }
            if (!(found instanceof PrometheusMeterRegistry)) {
                throw new IllegalArgumentException("Existing MeterRegistry: " + found.getClass().getName() + " is not a PrometheusMeterRegistry type.");
            }
            this.meterRegistry = (PrometheusMeterRegistry)found;
        }
        if (ObjectHelper.isNotEmpty((String)this.binders)) {
            this.initBinders();
        }
        if (this.isEnableRoutePolicy()) {
            MicrometerRoutePolicyFactory factory = new MicrometerRoutePolicyFactory();
            if ("legacy".equalsIgnoreCase(this.namingStrategy)) {
                factory.setNamingStrategy(MicrometerRoutePolicyNamingStrategy.LEGACY);
            }
            if ("all".equalsIgnoreCase(this.routePolicyLevel)) {
                factory.getPolicyConfiguration().setContextEnabled(true);
                factory.getPolicyConfiguration().setRouteEnabled(true);
            } else if ("context".equalsIgnoreCase(this.routePolicyLevel)) {
                factory.getPolicyConfiguration().setContextEnabled(true);
                factory.getPolicyConfiguration().setRouteEnabled(false);
            } else {
                factory.getPolicyConfiguration().setContextEnabled(false);
                factory.getPolicyConfiguration().setRouteEnabled(true);
            }
            factory.setMeterRegistry((MeterRegistry)this.meterRegistry);
            this.camelContext.addService((Object)factory);
            this.camelContext.addRoutePolicyFactory((RoutePolicyFactory)factory);
        }
        ManagementStrategy managementStrategy = this.camelContext.getManagementStrategy();
        if (this.isEnableExchangeEventNotifier()) {
            notifier = new MicrometerExchangeEventNotifier();
            if ("legacy".equalsIgnoreCase(this.namingStrategy)) {
                notifier.setNamingStrategy(MicrometerExchangeEventNotifierNamingStrategy.LEGACY);
            }
            notifier.setMeterRegistry((MeterRegistry)this.meterRegistry);
            managementStrategy.addEventNotifier((EventNotifier)notifier);
        }
        if (this.isEnableRouteEventNotifier()) {
            notifier = new MicrometerRouteEventNotifier();
            if ("legacy".equalsIgnoreCase(this.namingStrategy)) {
                notifier.setNamingStrategy(MicrometerRouteEventNotifierNamingStrategy.LEGACY);
            }
            notifier.setMeterRegistry((MeterRegistry)this.meterRegistry);
            managementStrategy.addEventNotifier((EventNotifier)notifier);
        }
        if (this.isEnableMessageHistory()) {
            if (!this.camelContext.isMessageHistory().booleanValue()) {
                this.camelContext.setMessageHistory(Boolean.valueOf(true));
            }
            MicrometerMessageHistoryFactory factory = new MicrometerMessageHistoryFactory();
            if ("legacy".equalsIgnoreCase(this.namingStrategy)) {
                factory.setNamingStrategy(MicrometerMessageHistoryNamingStrategy.LEGACY);
            }
            factory.setMeterRegistry((MeterRegistry)this.meterRegistry);
            this.camelContext.setMessageHistoryFactory((MessageHistoryFactory)factory);
        }
        if (this.clearOnReload) {
            this.camelContext.getManagementStrategy().addEventNotifier((EventNotifier)new SimpleEventNotifierSupport(){

                public boolean isEnabled(CamelEvent event) {
                    return event instanceof CamelEvent.RouteReloadedEvent;
                }

                public void notify(CamelEvent event) throws Exception {
                    CamelEvent.RouteReloadedEvent re;
                    if (event instanceof CamelEvent.RouteReloadedEvent && (re = (CamelEvent.RouteReloadedEvent)event).getIndex() >= re.getTotal()) {
                        LOG.info("Resetting Micrometer Registry after reloading routes");
                        ArrayList<Meter> toRemove = new ArrayList<Meter>();
                        for (Meter m : MicrometerPrometheus.this.meterRegistry.getMeters()) {
                            String t;
                            String n = m.getId().getName();
                            boolean camel = n.startsWith("camel_") || n.startsWith("camel.");
                            boolean keep = n.startsWith("camel.exchanges.") || n.startsWith("camel_exchanges_");
                            boolean remove = camel && !keep;
                            if (!remove || (t = m.getId().getTag("routeId")) == null) continue;
                            toRemove.add(m);
                        }
                        toRemove.forEach(arg_0 -> ((PrometheusMeterRegistry)MicrometerPrometheus.this.meterRegistry).remove(arg_0));
                    }
                }
            });
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.server = (MainHttpServer)this.camelContext.hasService(MainHttpServer.class);
        this.router = (VertxPlatformHttpRouter)CamelContextHelper.lookup((CamelContext)this.camelContext, (String)"platform-http-router", VertxPlatformHttpRouter.class);
        this.platformHttpComponent = (PlatformHttpComponent)this.camelContext.getComponent("platform-http", PlatformHttpComponent.class);
        if (this.server != null && this.server.isMetricsEnabled() && this.router != null && this.platformHttpComponent != null) {
            this.setupHttpScraper();
            LOG.info("MicrometerPrometheus enabled with HTTP scraping on /q/metrics");
        } else {
            LOG.info("MicrometerPrometheus enabled");
        }
    }

    private void initBinders() throws IOException {
        List<String> names = BindersHelper.discoverBinders(this.camelContext.getClassResolver(), this.binders);
        List<MeterBinder> binders = BindersHelper.loadBinders(this.camelContext, names);
        StringJoiner sj = new StringJoiner(", ");
        for (MeterBinder mb : binders) {
            mb.bindTo((MeterRegistry)this.meterRegistry);
            this.createdBinders.add(mb);
            sj.add(mb.getClass().getSimpleName());
        }
        if (!this.createdBinders.isEmpty()) {
            LOG.info("Registered {} MeterBinders: {}", (Object)this.createdBinders.size(), (Object)sj);
        }
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        for (MeterBinder mb : this.createdBinders) {
            if (!(mb instanceof Closeable)) continue;
            Closeable ac = (Closeable)mb;
            IOHelper.close((Closeable)ac);
        }
        this.createdBinders.clear();
    }

    protected void setupHttpScraper() {
        Route metrics = this.router.route("/q/metrics");
        metrics.method(HttpMethod.GET);
        final String format = "0.0.4".equals(this.textFormatVersion) ? CONTENT_TYPE_004 : CONTENT_TYPE_100;
        metrics.produces(format);
        Handler<RoutingContext> handler = new Handler<RoutingContext>(){

            public void handle(RoutingContext ctx) {
                String ct = format;
                String ah = ctx.request().getHeader("Accept");
                if (ah != null && ah.contains("application/openmetrics-text")) {
                    ct = MicrometerPrometheus.CONTENT_TYPE_100;
                }
                ctx.response().putHeader("Content-Type", ct);
                String data = MicrometerPrometheus.this.meterRegistry.scrape(ct);
                ctx.end(data);
            }
        };
        metrics.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        this.platformHttpComponent.addHttpEndpoint("/q/metrics", "GET", null, format, null);
    }
}

