/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.eventnotifier;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.EventObject;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.camel.Exchange;
import org.apache.camel.component.micrometer.eventnotifier.AbstractMicrometerEventNotifier;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerExchangeEventNotifierNamingStrategy;
import org.apache.camel.management.event.AbstractExchangeEvent;
import org.apache.camel.management.event.ExchangeCompletedEvent;
import org.apache.camel.management.event.ExchangeCreatedEvent;
import org.apache.camel.management.event.ExchangeFailedEvent;
import org.apache.camel.management.event.ExchangeSentEvent;

public class MicrometerExchangeEventNotifier
extends AbstractMicrometerEventNotifier<AbstractExchangeEvent> {
    private Predicate<Exchange> ignoreExchanges = exchange -> false;
    private MicrometerExchangeEventNotifierNamingStrategy namingStrategy = MicrometerExchangeEventNotifierNamingStrategy.DEFAULT;

    public MicrometerExchangeEventNotifier() {
        super(AbstractExchangeEvent.class);
    }

    public void setIgnoreExchanges(Predicate<Exchange> ignoreExchanges) {
        this.ignoreExchanges = ignoreExchanges;
    }

    public Predicate<Exchange> getIgnoreExchanges() {
        return this.ignoreExchanges;
    }

    public MicrometerExchangeEventNotifierNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(MicrometerExchangeEventNotifierNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public void notify(EventObject eventObject) {
        if (!this.getIgnoreExchanges().test(((AbstractExchangeEvent)eventObject).getExchange())) {
            if (eventObject instanceof ExchangeSentEvent) {
                this.handleSentEvent((ExchangeSentEvent)eventObject);
            } else if (eventObject instanceof ExchangeCreatedEvent) {
                this.handleCreatedEvent((ExchangeCreatedEvent)eventObject);
            } else if (eventObject instanceof ExchangeCompletedEvent || eventObject instanceof ExchangeFailedEvent) {
                this.handleDoneEvent((AbstractExchangeEvent)eventObject);
            }
        }
    }

    protected void handleSentEvent(ExchangeSentEvent sentEvent) {
        String name = this.namingStrategy.getName(sentEvent.getExchange(), sentEvent.getEndpoint());
        Tags tags = this.namingStrategy.getTags((AbstractExchangeEvent)sentEvent, sentEvent.getEndpoint());
        this.getMeterRegistry().timer(name, (Iterable)tags).record(sentEvent.getTimeTaken(), TimeUnit.MILLISECONDS);
    }

    protected void handleCreatedEvent(ExchangeCreatedEvent createdEvent) {
        String name = this.namingStrategy.getName(createdEvent.getExchange(), createdEvent.getExchange().getFromEndpoint());
        createdEvent.getExchange().setProperty("eventTimer:" + name, (Object)Timer.start((MeterRegistry)this.getMeterRegistry()));
    }

    protected void handleDoneEvent(AbstractExchangeEvent doneEvent) {
        String name = this.namingStrategy.getName(doneEvent.getExchange(), doneEvent.getExchange().getFromEndpoint());
        Tags tags = this.namingStrategy.getTags(doneEvent, doneEvent.getExchange().getFromEndpoint());
        Timer.Sample sample = (Timer.Sample)doneEvent.getExchange().removeProperty("eventTimer:" + name);
        if (sample != null) {
            sample.stop(this.getMeterRegistry().timer(name, (Iterable)tags));
        }
    }
}

