/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.eventnotifier;

import io.micrometer.core.instrument.Gauge;
import java.util.EventObject;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.component.micrometer.eventnotifier.AbstractMicrometerEventNotifier;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerRouteEventNotifierNamingStrategy;
import org.apache.camel.management.event.AbstractRouteEvent;
import org.apache.camel.management.event.RouteAddedEvent;
import org.apache.camel.management.event.RouteRemovedEvent;
import org.apache.camel.management.event.RouteStartedEvent;
import org.apache.camel.management.event.RouteStoppedEvent;

public class MicrometerRouteEventNotifier
extends AbstractMicrometerEventNotifier<AbstractRouteEvent> {
    private final AtomicLong routesAdded = new AtomicLong();
    private final AtomicLong routesRunning = new AtomicLong();
    private MicrometerRouteEventNotifierNamingStrategy namingStrategy = MicrometerRouteEventNotifierNamingStrategy.DEFAULT;

    public MicrometerRouteEventNotifier() {
        super(AbstractRouteEvent.class);
    }

    public MicrometerRouteEventNotifierNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(MicrometerRouteEventNotifierNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        Gauge.builder((String)this.namingStrategy.getRouteAddedName(), (Object)this.routesAdded, value -> Long.valueOf(value.get()).doubleValue()).baseUnit("routes").tags((Iterable)this.namingStrategy.getTags(this.getCamelContext())).register(this.getMeterRegistry());
        Gauge.builder((String)this.namingStrategy.getRouteRunningName(), (Object)this.routesRunning, value -> Long.valueOf(value.get()).doubleValue()).baseUnit("routes").tags((Iterable)this.namingStrategy.getTags(this.getCamelContext())).register(this.getMeterRegistry());
    }

    public void notify(EventObject eventObject) {
        if (eventObject instanceof RouteAddedEvent) {
            this.routesAdded.incrementAndGet();
        } else if (eventObject instanceof RouteRemovedEvent) {
            this.routesAdded.decrementAndGet();
        } else if (eventObject instanceof RouteStartedEvent) {
            this.routesRunning.incrementAndGet();
        } else if (eventObject instanceof RouteStoppedEvent) {
            this.routesRunning.decrementAndGet();
        }
    }
}

