/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.micrometer.CounterProducer;
import org.apache.camel.component.micrometer.DistributionSummaryProducer;
import org.apache.camel.component.micrometer.MicrometerConstants;
import org.apache.camel.component.micrometer.TimerProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.22.0", scheme="micrometer", title="Micrometer", syntax="micrometer:metricsType:metricsName", producerOnly=true, category={Category.MONITORING}, headersClass=MicrometerConstants.class)
public class MicrometerEndpoint
extends DefaultEndpoint {
    protected MeterRegistry registry;
    @UriPath(description="Type of metrics", enums="counter,distribution_summary,timer")
    @Metadata(required=true)
    protected final Meter.Type metricsType;
    @UriPath(description="Name of metrics")
    @Metadata(required=true)
    protected final String metricsName;
    @UriParam(description="Description of metrics")
    protected String metricsDescription;
    @UriPath(description="Tags of metrics")
    protected final Iterable<Tag> tags;
    @UriParam(description="Action expression when using timer type", enums="start,stop")
    private String action;
    @UriParam(description="Value expression when using histogram type")
    private String value;
    @UriParam(description="Increment value expression when using counter type")
    private String increment;
    @UriParam(description="Decrement value expression when using counter type")
    private String decrement;

    public MicrometerEndpoint(String uri, Component component, MeterRegistry registry, Meter.Type metricsType, String metricsName, Iterable<Tag> tags) {
        super(uri, component);
        this.registry = registry;
        this.metricsType = metricsType;
        this.metricsName = metricsName;
        this.tags = tags;
    }

    public Consumer createConsumer(Processor processor) {
        throw new UnsupportedOperationException("Consumer not supported");
    }

    public Producer createProducer() {
        if (this.metricsType == Meter.Type.COUNTER) {
            return new CounterProducer(this);
        }
        if (this.metricsType == Meter.Type.DISTRIBUTION_SUMMARY) {
            return new DistributionSummaryProducer(this);
        }
        if (this.metricsType == Meter.Type.TIMER) {
            return new TimerProducer(this);
        }
        throw new IllegalArgumentException("Metrics type " + this.metricsType + " is not supported");
    }

    public MeterRegistry getRegistry() {
        return this.registry;
    }

    public String getMetricsName() {
        return this.metricsName;
    }

    public Iterable<Tag> getTags() {
        return this.tags;
    }

    public Meter.Type getMetricsType() {
        return this.metricsType;
    }

    public String getMetricsDescription() {
        return this.metricsDescription;
    }

    public void setMetricsDescription(String metricsDescription) {
        this.metricsDescription = metricsDescription;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getIncrement() {
        return this.increment;
    }

    public void setIncrement(String increment) {
        this.increment = increment;
    }

    public String getDecrement() {
        return this.decrement;
    }

    public void setDecrement(String decrement) {
        this.decrement = decrement;
    }

    void setRegistry(MeterRegistry registry) {
        this.registry = registry;
    }
}

