/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.eventnotifier;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import java.util.function.Predicate;
import org.apache.camel.CamelContext;
import org.apache.camel.component.micrometer.MicrometerUtils;
import org.apache.camel.component.micrometer.eventnotifier.MicrometerEventNotifierService;
import org.apache.camel.spi.CamelEvent;

public interface MicrometerRouteEventNotifierNamingStrategy {
    public static final Predicate<Meter.Id> EVENT_NOTIFIERS = id -> MicrometerEventNotifierService.class.getSimpleName().equals(id.getTag("serviceName"));
    public static final MicrometerRouteEventNotifierNamingStrategy DEFAULT = new MicrometerRouteEventNotifierNamingStrategy(){

        @Override
        public String getRouteAddedName() {
            return "camel.routes.added";
        }

        @Override
        public String getRouteRunningName() {
            return "camel.routes.running";
        }

        @Override
        public String getRouteReloadedName() {
            return "camel.routes.reloaded";
        }
    };
    public static final MicrometerRouteEventNotifierNamingStrategy LEGACY = new MicrometerRouteEventNotifierNamingStrategy(){

        @Override
        public String getRouteAddedName() {
            return this.formatName("camel.routes.added");
        }

        @Override
        public String getRouteRunningName() {
            return this.formatName("camel.routes.running");
        }

        @Override
        public String getRouteReloadedName() {
            return this.formatName("camel.routes.reloaded");
        }

        @Override
        public String formatName(String name) {
            return MicrometerUtils.legacyName(name);
        }
    };

    default public String formatName(String name) {
        return name;
    }

    public String getRouteAddedName();

    public String getRouteRunningName();

    public String getRouteReloadedName();

    default public Tags getTags(CamelContext camelContext) {
        return Tags.of((String[])new String[]{"serviceName", MicrometerEventNotifierService.class.getSimpleName(), "camelContext", camelContext.getName(), "eventType", CamelEvent.RouteEvent.class.getSimpleName()});
    }
}

