/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.faulttolerance;

import io.smallrye.faulttolerance.ExecutorHolder;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreaker;
import io.smallrye.faulttolerance.core.timer.Timer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.component.microprofile.faulttolerance.FaultToleranceConfiguration;
import org.apache.camel.component.microprofile.faulttolerance.FaultToleranceProcessor;
import org.apache.camel.component.microprofile.faulttolerance.FaultToleranceTimerService;
import org.apache.camel.model.CircuitBreakerDefinition;
import org.apache.camel.model.FaultToleranceConfigurationCommon;
import org.apache.camel.model.FaultToleranceConfigurationDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.ExtendedPropertyConfigurerGetter;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.function.Suppliers;
import org.apache.camel.util.function.ThrowingSupplier;

public class FaultToleranceReifier
extends ProcessorReifier<CircuitBreakerDefinition> {
    public FaultToleranceReifier(Route route, CircuitBreakerDefinition definition) {
        super(route, (ProcessorDefinition)definition);
    }

    public Processor createProcessor() throws Exception {
        boolean fallbackViaNetwork;
        Processor processor = this.createChildProcessor(true);
        Processor fallback = null;
        if (((CircuitBreakerDefinition)this.definition).getOnFallback() != null) {
            fallback = this.createProcessor((ProcessorDefinition)((CircuitBreakerDefinition)this.definition).getOnFallback());
        }
        boolean bl = fallbackViaNetwork = ((CircuitBreakerDefinition)this.definition).getOnFallback() != null && this.parseBoolean(((CircuitBreakerDefinition)this.definition).getOnFallback().getFallbackViaNetwork(), false);
        if (fallbackViaNetwork) {
            throw new UnsupportedOperationException("camel-microprofile-fault-tolerance does not support onFallbackViaNetwork");
        }
        FaultToleranceConfigurationDefinition config = this.buildFaultToleranceConfiguration();
        FaultToleranceConfiguration configuration = new FaultToleranceConfiguration();
        this.configureCircuitBreaker((FaultToleranceConfigurationCommon)config, configuration);
        this.configureTimeLimiter((FaultToleranceConfigurationCommon)config, configuration);
        this.configureBulkhead((FaultToleranceConfigurationCommon)config, configuration);
        FaultToleranceProcessor answer = new FaultToleranceProcessor(configuration, processor, fallback);
        if (config.getCircuitBreaker() != null) {
            CircuitBreaker cb = (CircuitBreaker)this.mandatoryLookup(this.parseString(config.getCircuitBreaker()), CircuitBreaker.class);
            answer.setCircuitBreaker(cb);
        }
        this.configureBulkheadExecutorService(answer, (FaultToleranceConfigurationCommon)config);
        this.configureTimer(answer);
        return answer;
    }

    private void configureCircuitBreaker(FaultToleranceConfigurationCommon config, FaultToleranceConfiguration target) {
        target.setDelay(this.parseDuration(config.getDelay(), 5000L));
        target.setSuccessThreshold(this.parseInt(config.getSuccessThreshold(), 1));
        target.setRequestVolumeThreshold(this.parseInt(config.getRequestVolumeThreshold(), 20));
        if (config.getFailureRatio() != null) {
            float num = this.parseFloat(config.getFailureRatio(), 50.0f);
            if (num < 1.0f || num > 100.0f) {
                throw new IllegalArgumentException("FailureRatio must be between 1 and 100, was: " + num);
            }
            float percent = num / 100.0f;
            target.setFailureRatio(percent);
        } else {
            target.setFailureRatio(0.5f);
        }
    }

    private void configureTimeLimiter(FaultToleranceConfigurationCommon config, FaultToleranceConfiguration target) {
        if (!this.parseBoolean(config.getTimeoutEnabled(), false)) {
            target.setTimeoutEnabled(false);
        } else {
            target.setTimeoutEnabled(true);
        }
        target.setTimeoutDuration(this.parseDuration(config.getTimeoutDuration(), 1000L));
        target.setTimeoutPoolSize(this.parseInt(config.getTimeoutPoolSize(), 10));
    }

    private void configureBulkhead(FaultToleranceConfigurationCommon config, FaultToleranceConfiguration target) {
        if (!this.parseBoolean(config.getBulkheadEnabled(), false)) {
            return;
        }
        target.setBulkheadMaxConcurrentCalls(this.parseInt(config.getBulkheadMaxConcurrentCalls(), 10));
        target.setBulkheadWaitingTaskQueue(this.parseInt(config.getBulkheadWaitingTaskQueue(), 10));
    }

    private void configureBulkheadExecutorService(FaultToleranceProcessor processor, FaultToleranceConfigurationCommon config) {
        if (!this.parseBoolean(config.getBulkheadEnabled(), false)) {
            return;
        }
        if (config.getBulkheadExecutorService() != null) {
            String ref = config.getBulkheadExecutorService();
            boolean shutdownThreadPool = false;
            ExecutorService executorService = (ExecutorService)this.lookupByNameAndType(ref, ExecutorService.class);
            if (executorService == null) {
                executorService = this.lookupExecutorServiceRef("CircuitBreaker", this.definition, ref);
                shutdownThreadPool = true;
            }
            processor.setExecutorService(executorService);
            processor.setShutdownExecutorService(shutdownThreadPool);
        }
    }

    private void configureTimer(FaultToleranceProcessor answer) throws Exception {
        Timer timer;
        ExecutorHolder executorHolder = (ExecutorHolder)this.findSingleByType(ExecutorHolder.class);
        if (executorHolder != null) {
            timer = executorHolder.getTimer();
        } else {
            FaultToleranceTimerService threadTimerService = (FaultToleranceTimerService)((Object)this.camelContext.hasService(FaultToleranceTimerService.class));
            if (threadTimerService == null) {
                threadTimerService = new FaultToleranceTimerService();
                this.camelContext.addService((Object)threadTimerService);
            }
            timer = threadTimerService.getTimer();
        }
        answer.setTimer(timer);
    }

    FaultToleranceConfigurationDefinition buildFaultToleranceConfiguration() throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        PropertyConfigurer configurer = PluginHelper.getConfigurerResolver((CamelContext)this.camelContext).resolvePropertyConfigurer(FaultToleranceConfigurationDefinition.class.getName(), this.camelContext);
        this.loadProperties(properties, Suppliers.firstNotNull((ThrowingSupplier[])new ThrowingSupplier[]{() -> ((Model)this.camelContext.getCamelContextExtension().getContextPlugin(Model.class)).getFaultToleranceConfiguration(null), () -> (FaultToleranceConfigurationDefinition)this.lookupByNameAndType("fault-tolerance-configuration", FaultToleranceConfigurationDefinition.class)}), configurer);
        if (((CircuitBreakerDefinition)this.definition).getConfiguration() != null) {
            String ref = this.parseString(((CircuitBreakerDefinition)this.definition).getConfiguration());
            this.loadProperties(properties, Suppliers.firstNotNull((ThrowingSupplier[])new ThrowingSupplier[]{() -> ((Model)this.camelContext.getCamelContextExtension().getContextPlugin(Model.class)).getFaultToleranceConfiguration(ref), () -> (FaultToleranceConfigurationDefinition)this.mandatoryLookup(ref, FaultToleranceConfigurationDefinition.class)}), configurer);
        }
        this.loadProperties(properties, Optional.ofNullable(((CircuitBreakerDefinition)this.definition).getFaultToleranceConfiguration()), configurer);
        FaultToleranceConfigurationDefinition config = new FaultToleranceConfigurationDefinition();
        PropertyBindingSupport.build().withCamelContext(this.camelContext).withIgnoreCase(true).withConfigurer(configurer).withProperties(properties).withTarget((Object)config).bind();
        return config;
    }

    private void loadProperties(Map<String, Object> properties, Optional<?> optional, PropertyConfigurer configurer) {
        BeanIntrospection beanIntrospection = PluginHelper.getBeanIntrospection((CamelContext)this.camelContext);
        optional.ifPresent(bean -> {
            if (configurer instanceof ExtendedPropertyConfigurerGetter) {
                ExtendedPropertyConfigurerGetter getter = (ExtendedPropertyConfigurerGetter)configurer;
                Map types = getter.getAllOptions(bean);
                types.forEach((k, t) -> {
                    Object value = getter.getOptionValue(bean, k, true);
                    if (value != null) {
                        properties.put((String)k, value);
                    }
                });
            } else {
                beanIntrospection.getProperties(bean, properties, null, false);
            }
        });
    }
}

