/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.microprofile.metrics;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.microprofile.metrics.MicroProfileMetricsConcurrentGaugeProducer;
import org.apache.camel.component.microprofile.metrics.MicroProfileMetricsConstants;
import org.apache.camel.component.microprofile.metrics.MicroProfileMetricsCounterProducer;
import org.apache.camel.component.microprofile.metrics.MicroProfileMetricsGaugeProducer;
import org.apache.camel.component.microprofile.metrics.MicroProfileMetricsHistogramProducer;
import org.apache.camel.component.microprofile.metrics.MicroProfileMetricsMeteredProducer;
import org.apache.camel.component.microprofile.metrics.MicroProfileMetricsTimerProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;

@UriEndpoint(firstVersion="3.0.0", scheme="microprofile-metrics", title="MicroProfile Metrics", syntax="microprofile-metrics:metricType:metricName", producerOnly=true, category={Category.MONITORING}, headersClass=MicroProfileMetricsConstants.class)
public class MicroProfileMetricsEndpoint
extends DefaultEndpoint {
    protected final MetricRegistry metricRegistry;
    @UriPath(description="Metric type")
    @Metadata(required=true, enums="concurrent gauge,counter,histogram,meter,timer")
    private final MetricType metricType;
    @UriPath(description="Metric name")
    @Metadata(required=true)
    private final String metricName;
    @UriParam(description="Comma delimited list of tags associated with the metric in the format tagName=tagValue")
    private String tags;
    @UriParam(description="Action to use when using the timer type")
    private String action;
    @UriParam(description="Mark value to set when using the meter type")
    private Long mark;
    @UriParam(description="Value to set when using the histogram type")
    private Long value;
    @UriParam(description="Increment value when using the counter type")
    private Long counterIncrement;
    @UriParam(description="Increment metric value when using the concurrent gauge type")
    private Boolean gaugeIncrement = false;
    @UriParam(description="Decrement metric value when using concurrent gauge type")
    private Boolean gaugeDecrement = false;
    @UriParam(description="Decrement metric value when using concurrent gauge type")
    private Number gaugeValue;
    @UriParam(description="Metric description")
    private String description;
    @UriParam(description="Metric display name")
    private String displayName;
    @UriParam(description="Metric unit. See org.eclipse.microprofile.metrics.MetricUnits")
    private String metricUnit;

    public MicroProfileMetricsEndpoint(String uri, Component component, MetricRegistry metricRegistry, MetricType metricType, String metricsName) {
        super(uri, component);
        this.metricRegistry = metricRegistry;
        this.metricType = metricType;
        this.metricName = metricsName;
    }

    public Producer createProducer() throws Exception {
        if (this.metricType.equals((Object)MetricType.COUNTER)) {
            return new MicroProfileMetricsCounterProducer(this);
        }
        if (this.metricType.equals((Object)MetricType.CONCURRENT_GAUGE)) {
            return new MicroProfileMetricsConcurrentGaugeProducer(this);
        }
        if (this.metricType.equals((Object)MetricType.GAUGE)) {
            return new MicroProfileMetricsGaugeProducer(this);
        }
        if (this.metricType.equals((Object)MetricType.HISTOGRAM)) {
            return new MicroProfileMetricsHistogramProducer(this);
        }
        if (this.metricType.equals((Object)MetricType.METERED)) {
            return new MicroProfileMetricsMeteredProducer(this);
        }
        if (this.metricType.equals((Object)MetricType.TIMER)) {
            return new MicroProfileMetricsTimerProducer(this);
        }
        throw new IllegalStateException("Unknown metric type " + this.metricType);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("The microprofile-metrics endpoint does not support consumers");
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Long getMark() {
        return this.mark;
    }

    public void setMark(Long mark) {
        this.mark = mark;
    }

    public Long getValue() {
        return this.value;
    }

    public void setValue(Long value) {
        this.value = value;
    }

    public Long getCounterIncrement() {
        return this.counterIncrement;
    }

    public void setCounterIncrement(Long counterIncrement) {
        this.counterIncrement = counterIncrement;
    }

    public Boolean getGaugeIncrement() {
        return this.gaugeIncrement;
    }

    public void setGaugeIncrement(Boolean gaugeIncrement) {
        this.gaugeIncrement = gaugeIncrement;
    }

    public Boolean getGaugeDecrement() {
        return this.gaugeDecrement;
    }

    public void setGaugeDecrement(Boolean gaugeDecrement) {
        this.gaugeDecrement = gaugeDecrement;
    }

    public Number getGaugeValue() {
        return this.gaugeValue;
    }

    public void setGaugeValue(Number gaugeValue) {
        this.gaugeValue = gaugeValue;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getMetricUnit() {
        return this.metricUnit;
    }

    public void setMetricUnit(String metricUnit) {
        this.metricUnit = metricUnit;
    }
}

