/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.component.milo.client.MiloClientConfiguration;
import org.apache.camel.component.milo.client.MiloClientConnection;
import org.apache.camel.component.milo.client.MiloClientConnectionManager;
import org.apache.camel.component.milo.client.MonitorFilterConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiloClientCachingConnectionManager
implements MiloClientConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(MiloClientCachingConnectionManager.class);
    private final Map<String, ManagedConnection> cache = new HashMap<String, ManagedConnection>();

    @Override
    public synchronized MiloClientConnection createConnection(MiloClientConfiguration configuration, MonitorFilterConfiguration monitorFilterConfiguration) {
        String identifier = configuration.toCacheId();
        ManagedConnection managedConnection = this.cache.computeIfAbsent(identifier, k -> this.managedConnection(configuration, monitorFilterConfiguration));
        managedConnection.increment();
        return managedConnection.connection;
    }

    @Override
    public synchronized void releaseConnection(MiloClientConnection connection) {
        Optional<Map.Entry> existingConnection = this.cache.entrySet().stream().filter(entry -> ((ManagedConnection)entry.getValue()).connection.equals(connection)).findFirst();
        existingConnection.ifPresent(entry -> {
            ((ManagedConnection)entry.getValue()).decrement();
            if (((ManagedConnection)entry.getValue()).consumers <= 0) {
                try {
                    LOG.debug("Closing connection {}", entry.getKey());
                    ((ManagedConnection)entry.getValue()).connection.close();
                }
                catch (Exception e) {
                    LOG.debug("Error while closing connection with id {}. This exception is ignored.", entry.getKey());
                }
                finally {
                    this.cache.remove(entry.getKey());
                }
            }
        });
    }

    private ManagedConnection managedConnection(MiloClientConfiguration configuration, MonitorFilterConfiguration monitorFilterConfiguration) {
        return new ManagedConnection(this.miloClientConnection(configuration, monitorFilterConfiguration));
    }

    private MiloClientConnection miloClientConnection(MiloClientConfiguration configuration, MonitorFilterConfiguration monitorFilterConfiguration) {
        return new MiloClientConnection(configuration, monitorFilterConfiguration);
    }

    private static class ManagedConnection {
        private final MiloClientConnection connection;
        private int consumers;

        ManagedConnection(MiloClientConnection connection) {
            this.connection = connection;
        }

        void increment() {
            ++this.consumers;
        }

        void decrement() {
            --this.consumers;
        }
    }
}

