/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.net.SocketAddress;
import org.apache.camel.CamelException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.mina.MinaEndpoint;
import org.apache.camel.component.mina.MinaHelper;
import org.apache.camel.component.mina.MinaPayloadHelper;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoHandlerAdapter;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinaConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(MinaConsumer.class);
    private final SocketAddress address;
    private final IoAcceptor acceptor;
    private final IoConnector connector;
    private final boolean sync;
    private final String protocol;
    private final boolean clientMode;
    private IoSession session;
    private CamelLogger noReplyLogger;

    public MinaConsumer(MinaEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.address = endpoint.getAddress();
        this.acceptor = endpoint.getAcceptor();
        this.connector = endpoint.getConnector();
        this.protocol = endpoint.getConfiguration().getProtocol();
        this.clientMode = endpoint.getConfiguration().isClientMode();
        this.sync = endpoint.getConfiguration().isSync();
        this.noReplyLogger = new CamelLogger(LOG, endpoint.getConfiguration().getNoReplyLogLevel());
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.info("Binding to server address: {} using acceptor: {}", (Object)this.address, (Object)this.acceptor);
        ReceiveHandler handler = new ReceiveHandler();
        if (this.protocol.equals("tcp") && this.clientMode) {
            ConnectFuture future = this.connector.connect(this.address, (IoHandler)handler, (IoServiceConfig)this.getEndpoint().getConnectorConfig());
            future.join();
            this.session = future.getSession();
        } else {
            this.acceptor.bind(this.address, (IoHandler)handler, (IoServiceConfig)this.getEndpoint().getAcceptorConfig());
        }
    }

    protected void doStop() throws Exception {
        LOG.info("Unbinding from server address: {} using acceptor: {}", (Object)this.address, (Object)this.acceptor);
        if (this.protocol.equals("tcp") && this.clientMode) {
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
        } else {
            this.acceptor.unbind(this.address);
        }
        super.doStop();
    }

    public MinaEndpoint getEndpoint() {
        return (MinaEndpoint)super.getEndpoint();
    }

    private final class ReceiveHandler
    extends IoHandlerAdapter {
        private ReceiveHandler() {
        }

        public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
            if (session != null) {
                LOG.debug("Closing session as an exception was thrown from MINA");
                session.close();
            }
            throw new CamelException(cause);
        }

        public void messageReceived(IoSession session, Object object) throws Exception {
            if (LOG.isDebugEnabled()) {
                Object in = object;
                if (in instanceof byte[]) {
                    in = MinaConsumer.this.getEndpoint().getCamelContext().getTypeConverter().convertTo(String.class, in);
                }
                LOG.debug("Received body: {}", in);
            }
            Exchange exchange = MinaConsumer.this.getEndpoint().createExchange(session, object);
            if (MinaConsumer.this.getEndpoint().getConfiguration().getCharsetName() != null) {
                exchange.setProperty("CamelCharsetName", (Object)IOHelper.normalizeCharset((String)MinaConsumer.this.getEndpoint().getConfiguration().getCharsetName()));
            }
            try {
                MinaConsumer.this.getProcessor().process(exchange);
            }
            catch (Throwable e) {
                MinaConsumer.this.getExceptionHandler().handleException(e);
            }
            if (MinaConsumer.this.sync) {
                Object body = exchange.hasOut() ? MinaPayloadHelper.getOut(MinaConsumer.this.getEndpoint(), exchange) : MinaPayloadHelper.getIn(MinaConsumer.this.getEndpoint(), exchange);
                boolean failed = exchange.isFailed();
                if (failed && !MinaConsumer.this.getEndpoint().getConfiguration().isTransferExchange()) {
                    body = exchange.getException() != null ? exchange.getException() : exchange.getOut().getBody();
                }
                if (body == null) {
                    MinaConsumer.this.noReplyLogger.log("No payload to send as reply for exchange: " + exchange);
                    if (MinaConsumer.this.getEndpoint().getConfiguration().isDisconnectOnNoReply()) {
                        LOG.debug("Closing session as no payload to send as reply at address: {}", (Object)MinaConsumer.this.address);
                        session.close();
                    }
                } else {
                    LOG.debug("Writing body: {}", body);
                    MinaHelper.writeBody(session, body, exchange);
                }
            }
            Boolean close = ExchangeHelper.isOutCapable((Exchange)exchange) ? (Boolean)exchange.getOut().getHeader("CamelMinaCloseSessionWhenComplete", Boolean.class) : (Boolean)exchange.getIn().getHeader("CamelMinaCloseSessionWhenComplete", Boolean.class);
            boolean disconnect = MinaConsumer.this.getEndpoint().getConfiguration().isDisconnect();
            if (close != null) {
                disconnect = close;
            }
            if (disconnect) {
                LOG.debug("Closing session when complete at address: {}", (Object)MinaConsumer.this.address);
                session.close();
            }
        }
    }
}

