/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.mina.MinaConfiguration;
import org.apache.camel.component.mina.MinaEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.apache.mina.core.filterchain.IoFilter;

@org.apache.camel.spi.annotations.Component(value="mina")
public class MinaComponent
extends DefaultComponent
implements SSLContextParametersAware {
    @Metadata(label="advanced")
    private MinaConfiguration configuration;
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    public MinaComponent() {
    }

    public MinaComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MinaConfiguration config = this.configuration != null ? this.configuration.copy() : new MinaConfiguration();
        URI u = new URI(remaining);
        config.setHost(u.getHost());
        config.setPort(u.getPort());
        config.setProtocol(u.getScheme());
        config.setFilters(this.resolveAndRemoveReferenceListParameter(parameters, "filters", IoFilter.class));
        Endpoint endpoint = this.createEndpoint(uri, config);
        this.setProperties(endpoint, parameters);
        if (config.getSslContextParameters() == null) {
            config.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        return endpoint;
    }

    public Endpoint createEndpoint(MinaConfiguration config) throws Exception {
        return this.createEndpoint(config.getUriString(), config);
    }

    private Endpoint createEndpoint(String uri, MinaConfiguration config) throws Exception {
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"camelContext");
        String protocol = config.getProtocol();
        MinaEndpoint endpoint = null;
        if (protocol != null && (protocol.equals("tcp") || config.isDatagramProtocol() || protocol.equals("vm"))) {
            endpoint = new MinaEndpoint(uri, (Component)this, config);
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("Unrecognised MINA protocol: " + protocol + " for uri: " + uri);
        }
        if (config.isSync()) {
            endpoint.setExchangePattern(ExchangePattern.InOut);
        } else {
            endpoint.setExchangePattern(ExchangePattern.InOnly);
        }
        return endpoint;
    }

    public MinaConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MinaConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }
}

