/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.Consumer;
import org.apache.camel.Route;
import org.apache.camel.component.mina.MinaConfiguration;
import org.apache.camel.component.mina.MinaConsumer;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="mina", description="Embedded Mina Server")
public class MinaConsole
extends AbstractDevConsole {
    public MinaConsole() {
        super("camel", "mina", "Mina", "Embedded Mina Server");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        List list = this.getCamelContext().getRoutes().stream().map(Route::getConsumer).filter(c -> MinaConsumer.class.getName().equals(c.getClass().getName())).collect(Collectors.toList());
        for (Consumer c2 : list) {
            MinaConsumer nc = (MinaConsumer)c2;
            MinaConfiguration conf = nc.getEndpoint().getConfiguration();
            if (conf.isClientMode()) continue;
            sb.append(String.format("    %s:%s:%d\n", conf.getProtocol(), conf.getHost(), conf.getPort()));
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        List list = this.getCamelContext().getRoutes().stream().map(Route::getConsumer).filter(c -> MinaConsumer.class.getName().equals(c.getClass().getName())).collect(Collectors.toList());
        ArrayList<JsonObject> arr = new ArrayList<JsonObject>();
        for (Consumer c2 : list) {
            MinaConsumer nc = (MinaConsumer)c2;
            MinaConfiguration conf = nc.getEndpoint().getConfiguration();
            if (conf.isClientMode()) continue;
            JsonObject jo = new JsonObject();
            jo.put((Object)"protocol", (Object)conf.getProtocol());
            jo.put((Object)"host", (Object)conf.getHost());
            jo.put((Object)"port", (Object)conf.getPort());
            arr.add(jo);
        }
        if (!arr.isEmpty()) {
            root.put((Object)"consumers", arr);
        }
        return root;
    }
}

