/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina2;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mina2.Mina2Configuration;
import org.apache.camel.component.mina2.Mina2Consumer;
import org.apache.camel.component.mina2.Mina2PayloadHelper;
import org.apache.camel.component.mina2.Mina2Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;
import org.apache.mina.core.session.IoSession;

@UriEndpoint(firstVersion="2.10.0", scheme="mina2", title="Mina2", syntax="mina2:protocol:host:port", consumerClass=Mina2Consumer.class, label="networking,tcp,udp")
public class Mina2Endpoint
extends DefaultEndpoint
implements MultipleConsumersSupport {
    @UriParam
    private Mina2Configuration configuration;

    public Mina2Endpoint() {
    }

    public Mina2Endpoint(String endpointUri, Component component, Mina2Configuration configuration) {
        super(endpointUri, component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        ObjectHelper.notNull((Object)this.configuration, (String)"configuration");
        return new Mina2Producer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ObjectHelper.notNull((Object)this.configuration, (String)"configuration");
        Mina2Consumer answer = new Mina2Consumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public Exchange createExchange(IoSession session, Object payload) {
        Exchange exchange = this.createExchange();
        exchange.getIn().setHeader("CamelMina2IoSession", (Object)session);
        exchange.getIn().setHeader("CamelMina2LocalAddress", (Object)session.getLocalAddress());
        exchange.getIn().setHeader("CamelMina2RemoteAddress", (Object)session.getRemoteAddress());
        Mina2PayloadHelper.setIn(exchange, payload);
        return exchange;
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isMultipleConsumersSupported() {
        return this.configuration.isDatagramProtocol();
    }

    public Mina2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Mina2Configuration configuration) {
        this.configuration = configuration;
    }
}

