/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.minio;

import org.apache.camel.spi.Metadata;

public interface MinioConstants {
    public static final int BYTE_ARRAY_LENGTH = 1024;
    @Metadata(description="*Producer:* The bucket Name which this object will be stored or which will be used for the current operation. *Consumer:* The name of the bucket in which this object is contained.", javaType="String")
    public static final String BUCKET_NAME = "CamelMinioBucketName";
    @Metadata(label="producer", description="The bucket Destination Name which will be used for the current operation.", javaType="String")
    public static final String DESTINATION_BUCKET_NAME = "CamelMinioDestinationBucketName";
    @Metadata(description="*Producer:* The content control of this object. *Consumer:* The *optional* Cache-Control HTTP header which allows the user to\nspecify caching behavior along the HTTP request/reply chain.", javaType="String")
    public static final String CACHE_CONTROL = "CamelMinioContentControl";
    @Metadata(description="*Producer:* The content disposition of this object. *Consumer:* The *optional* Content-Disposition HTTP header, which specifies\npresentational information such as the recommended filename for the\nobject to be saved as.", javaType="String")
    public static final String CONTENT_DISPOSITION = "CamelMinioContentDisposition";
    @Metadata(description="*Producer:* The content encoding of this object. *Consumer:* The *optional* Content-Encoding HTTP header specifying what content\nencodings have been applied to the object and what decoding mechanisms\nmust be applied in order to obtain the media-type referenced by the\nContent-Type field.", javaType="String")
    public static final String CONTENT_ENCODING = "CamelMinioContentEncoding";
    @Metadata(description="*Producer:* The content length of this object. *Consumer:* The Content-Length HTTP header indicating the size of the associated\nobject in bytes.", javaType="Long")
    public static final String CONTENT_LENGTH = "CamelMinioContentLength";
    @Metadata(description="*Producer:* The md5 checksum of this object. *Consumer:* The base64 encoded 128-bit MD5 digest of the associated object (content\n- not including headers) according to RFC 1864. This data is used as a\nmessage integrity check to verify that the data received by Minio is\nthe same data that the caller sent.", javaType="String")
    public static final String CONTENT_MD5 = "CamelMinioContentMD5";
    @Metadata(description="*Producer:* The content type of this object. *Consumer:* The Content-Type HTTP header, which indicates the type of content stored\nin the associated object. The value of this header is a standard MIME\ntype.", javaType="String")
    public static final String CONTENT_TYPE = "CamelMinioContentType";
    @Metadata(description="*Producer:* The ETag value for the newly uploaded object. *Consumer:* The hex encoded 128-bit MD5 digest of the associated object according to\nRFC 1864. This data is used as an integrity check to verify that the\ndata received by the caller is the same data that was sent by Minio", javaType="String")
    public static final String E_TAG = "CamelMinioETag";
    @Metadata(description="*Producer:* The key under which this object will be stored or which will be used for the current operation. *Consumer:* The key under which this object is stored.", javaType="String")
    public static final String OBJECT_NAME = "CamelMinioObjectName";
    @Metadata(label="producer", description="The Destination key which will be used for the current operation.", javaType="String")
    public static final String DESTINATION_OBJECT_NAME = "CamelMinioDestinationObjectName";
    @Metadata(description="*Producer:* The last modified timestamp of this object. *Consumer:* The value of the Last-Modified header, indicating the date and time at\nwhich Minio last recorded a modification to the associated object.", javaType="java.util.Date")
    public static final String LAST_MODIFIED = "CamelMinioLastModified";
    @Metadata(label="producer", description="The storage class of this object.", javaType="String")
    public static final String STORAGE_CLASS = "CamelMinioStorageClass";
    @Metadata(description="*Producer:* The version Id of the object to be stored or returned from the current operation. *Consumer:* The version ID of the associated Minio object if available. Version\nIDs are only assigned to objects when an object is uploaded to an Minio bucket that has object versioning enabled.", javaType="String")
    public static final String VERSION_ID = "CamelMinioVersionId";
    @Metadata(label="producer", description="The canned acl that will be applied to the object. see\n`com.amazonaws.services.s3.model.CannedAccessControlList` for allowed\nvalues.", javaType="String")
    public static final String CANNED_ACL = "CamelMinioCannedAcl";
    @Metadata(label="producer", description="The operation to perform.", javaType="org.apache.camel.component.minio.MinioOperations")
    public static final String MINIO_OPERATION = "CamelMinioOperation";
    @Metadata(description="*Producer:* Sets the server-side encryption algorithm when encrypting\nthe object using Minio-managed keys. For example use AES256. *Consumer:* The server-side encryption algorithm when encrypting the\nobject using Minio-managed keys.", javaType="String")
    public static final String SERVER_SIDE_ENCRYPTION = "CamelMinioServerSideEncryption";
    @Metadata(description="The expiration time", javaType="String")
    public static final String EXPIRATION_TIME = "CamelMinioExpirationTime";
    @Metadata(description="The replication status", javaType="String")
    public static final String REPLICATION_STATUS = "CamelMinioReplicationStatus";
    @Metadata(label="producer", description="The offset", javaType="String")
    public static final String OFFSET = "CamelMinioOffset";
    @Metadata(label="producer", description="The length", javaType="String")
    public static final String LENGTH = "CamelMinioLength";
}

