/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.minio;

import io.minio.BucketExistsArgs;
import io.minio.CopyObjectArgs;
import io.minio.CopySource;
import io.minio.GetObjectArgs;
import io.minio.ListObjectsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.RemoveObjectArgs;
import io.minio.Result;
import io.minio.errors.MinioException;
import io.minio.messages.Item;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.minio.MinioChecks;
import org.apache.camel.component.minio.MinioConfiguration;
import org.apache.camel.component.minio.MinioEndpoint;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.EmptyAsyncCallback;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioConsumer
extends ScheduledBatchPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(MinioConsumer.class);
    private long totalCounter;
    private String continuationToken;
    private transient String minioConsumerToString;

    public MinioConsumer(MinioEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doStart() throws Exception {
        super.doStart();
        if (!this.getConfiguration().isMoveAfterRead()) return;
        String destinationBucketName = this.getConfiguration().getDestinationBucketName();
        if (ObjectHelper.isNotEmpty((String)destinationBucketName)) {
            if (this.bucketExists(destinationBucketName)) {
                LOG.trace("Bucket {} already exists", (Object)destinationBucketName);
                return;
            } else {
                LOG.trace("Destination Bucket {} doesn't exist yet", (Object)destinationBucketName);
                if (!this.getConfiguration().isAutoCreateBucket()) throw new IllegalArgumentException("Destination Bucket does not exists, set autoCreateBucket option for bucket auto creation");
                LOG.trace("Creating Destination bucket {}...", (Object)destinationBucketName);
                this.makeBucket(destinationBucketName);
                LOG.trace("Destination Bucket created");
            }
            return;
        } else {
            LOG.warn("invalid destinationBucketName found: {}", (Object)destinationBucketName);
        }
    }

    private boolean bucketExists(String bucketName) throws Exception {
        return this.getMinioClient().bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build());
    }

    private void makeBucket(String bucketName) throws Exception {
        MakeBucketArgs.Builder makeBucketRequest = ((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).objectLock(this.getConfiguration().isObjectLock());
        if (ObjectHelper.isNotEmpty((String)this.getConfiguration().getRegion())) {
            makeBucketRequest.region(this.getConfiguration().getRegion());
        }
        this.getMinioClient().makeBucket((MakeBucketArgs)makeBucketRequest.build());
    }

    protected int poll() throws Exception {
        Iterator<Result<Item>> listObjects;
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        String bucketName = this.getConfiguration().getBucketName();
        String objectName = this.getConfiguration().getObjectName();
        if (ObjectHelper.isNotEmpty((String)objectName)) {
            LOG.trace("Getting object in bucket {} with object name {}...", (Object)bucketName, (Object)objectName);
            Deque<Exchange> exchanges = this.createExchanges(objectName);
            return this.processBatch(CastUtils.cast(exchanges));
        }
        LOG.trace("Queueing objects in bucket {}...", (Object)bucketName);
        ListObjectsArgs.Builder listObjectRequest = ((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).includeUserMetadata(this.getConfiguration().isIncludeUserMetadata()).includeVersions(this.getConfiguration().isIncludeVersions()).recursive(this.getConfiguration().isRecursive()).useApiVersion1(this.getConfiguration().isUseVersion1());
        if (ObjectHelper.isNotEmpty((String)this.getConfiguration().getDelimiter())) {
            listObjectRequest.delimiter(this.getConfiguration().getDelimiter());
        }
        if (this.maxMessagesPerPoll > 0) {
            listObjectRequest.maxKeys(this.maxMessagesPerPoll);
        }
        if (ObjectHelper.isNotEmpty((String)this.getConfiguration().getPrefix())) {
            listObjectRequest.prefix(this.getConfiguration().getPrefix());
        }
        if (ObjectHelper.isNotEmpty((String)this.getConfiguration().getStartAfter())) {
            listObjectRequest.startAfter(this.getConfiguration().getStartAfter());
            this.continuationToken = null;
        }
        if (ObjectHelper.isNotEmpty((String)this.continuationToken)) {
            LOG.trace("Resuming from marker: {}", (Object)this.continuationToken);
            listObjectRequest.startAfter(this.continuationToken);
        }
        if ((listObjects = this.getMinioClient().listObjects((ListObjectsArgs)listObjectRequest.build()).iterator()).hasNext()) {
            Deque<Exchange> exchanges = this.createExchanges(listObjects);
            this.continuationToken = this.maxMessagesPerPoll <= 0 || exchanges.size() < this.maxMessagesPerPoll ? null : (String)exchanges.getLast().getIn().getHeader("CamelMinioObjectName", String.class);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Found {} objects in bucket {}...", (Object)this.totalCounter, (Object)bucketName);
            }
            return this.processBatch(CastUtils.cast(exchanges));
        }
        this.continuationToken = null;
        return 0;
    }

    protected Deque<Exchange> createExchanges(String objectName) throws Exception {
        LinkedList<Exchange> answer = new LinkedList<Exchange>();
        Exchange exchange = this.createExchange(objectName);
        answer.add(exchange);
        return answer;
    }

    protected Deque<Exchange> createExchanges(Iterator<Result<Item>> minioObjectSummaries) throws Exception {
        int messageCounter = 0;
        LinkedList<Exchange> answer = new LinkedList<Exchange>();
        try {
            if (this.getConfiguration().isIncludeFolders()) {
                do {
                    ++messageCounter;
                    Item minioObjectSummary = (Item)minioObjectSummaries.next().get();
                    Exchange exchange = this.createExchange(minioObjectSummary.objectName());
                    answer.add(exchange);
                } while (minioObjectSummaries.hasNext());
            } else {
                do {
                    ++messageCounter;
                    Item minioObjectSummary = (Item)minioObjectSummaries.next().get();
                    if (minioObjectSummary.isDir()) continue;
                    Exchange exchange = this.createExchange(minioObjectSummary.objectName());
                    answer.add(exchange);
                } while (minioObjectSummaries.hasNext());
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Received {} messages in this poll", (Object)messageCounter);
                this.totalCounter += (long)messageCounter;
            }
        }
        catch (Exception e) {
            LOG.warn("Error getting MinioObject due: {}", (Object)e.getMessage());
            throw e;
        }
        return answer;
    }

    private InputStream getObject(String bucketName, MinioClient minioClient, String objectName) throws Exception {
        GetObjectArgs.Builder getObjectRequest = (GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(objectName);
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getServerSideEncryptionCustomerKey, arg_0 -> ((GetObjectArgs.Builder)getObjectRequest).ssec(arg_0));
        MinioChecks.checkLengthAndSetConfig(this.getConfiguration()::getOffset, arg_0 -> ((GetObjectArgs.Builder)getObjectRequest).offset(arg_0));
        MinioChecks.checkLengthAndSetConfig(this.getConfiguration()::getLength, arg_0 -> ((GetObjectArgs.Builder)getObjectRequest).length(arg_0));
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getVersionId, arg_0 -> ((GetObjectArgs.Builder)getObjectRequest).versionId(arg_0));
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getMatchETag, arg_0 -> ((GetObjectArgs.Builder)getObjectRequest).matchETag(arg_0));
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getNotMatchETag, arg_0 -> ((GetObjectArgs.Builder)getObjectRequest).notMatchETag(arg_0));
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getModifiedSince, arg_0 -> ((GetObjectArgs.Builder)getObjectRequest).modifiedSince(arg_0));
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getUnModifiedSince, arg_0 -> ((GetObjectArgs.Builder)getObjectRequest).unmodifiedSince(arg_0));
        return minioClient.getObject((GetObjectArgs)getObjectRequest.build());
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty(ExchangePropertyKey.BATCH_INDEX, (Object)index);
            exchange.setProperty(ExchangePropertyKey.BATCH_SIZE, (Object)total);
            exchange.setProperty(ExchangePropertyKey.BATCH_COMPLETE, (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            String srcBucketName = (String)exchange.getIn().getHeader("CamelMinioBucketName", String.class);
            String srcObjectName = (String)exchange.getIn().getHeader("CamelMinioObjectName", String.class);
            if (this.getConfiguration().isIncludeBody()) {
                try {
                    final InputStream minioObject = this.getObject(srcBucketName, this.getMinioClient(), srcObjectName);
                    exchange.getIn().setBody((Object)IOUtils.toByteArray((InputStream)minioObject));
                    if (this.getConfiguration().isAutoCloseBody()) {
                        exchange.getExchangeExtension().addOnCompletion((Synchronization)new SynchronizationAdapter(){

                            public void onDone(Exchange exchange) {
                                IOHelper.close((Closeable)minioObject);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    LOG.warn("Error getting MinioObject due: {}", (Object)e.getMessage());
                    throw e;
                }
            }
            exchange.getExchangeExtension().addOnCompletion(new Synchronization(){

                public void onComplete(Exchange exchange) {
                    MinioConsumer.this.processCommit(exchange);
                }

                public void onFailure(Exchange exchange) {
                    MinioConsumer.this.processRollback(exchange);
                }

                public String toString() {
                    return "MinioConsumerOnCompletion";
                }
            });
            this.getAsyncProcessor().process(exchange, EmptyAsyncCallback.get());
        }
        return total;
    }

    protected void processCommit(Exchange exchange) {
        try {
            String srcBucketName = (String)exchange.getIn().getHeader("CamelMinioBucketName", String.class);
            String srcObjectName = (String)exchange.getIn().getHeader("CamelMinioObjectName", String.class);
            if (this.getConfiguration().isDeleteAfterRead() || this.getConfiguration().isMoveAfterRead()) {
                if (this.getConfiguration().isMoveAfterRead()) {
                    this.copyObject(srcBucketName, srcObjectName);
                    LOG.trace("Copied object from bucket {} with objectName {} to bucket {}...", new Object[]{srcBucketName, srcObjectName, this.getConfiguration().getDestinationBucketName()});
                }
                LOG.trace("Deleting object from bucket {} with objectName {}...", (Object)srcBucketName, (Object)srcObjectName);
                this.removeObject(srcBucketName, srcObjectName);
                LOG.trace("Deleted object from bucket {} with objectName {}...", (Object)srcBucketName, (Object)srcObjectName);
            }
        }
        catch (MinioException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            this.getExceptionHandler().handleException("Error occurred during moving or deleting object. This exception is ignored.", exchange, e);
        }
    }

    private void removeObject(String srcBucketName, String srcObjectName) throws MinioException, IOException, InvalidKeyException, NoSuchAlgorithmException {
        RemoveObjectArgs.Builder removeObjectRequest = ((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(srcBucketName)).object(srcObjectName)).bypassGovernanceMode(this.getConfiguration().isBypassGovernanceMode());
        if (ObjectHelper.isNotEmpty((String)this.getConfiguration().getVersionId())) {
            removeObjectRequest.versionId(this.getConfiguration().getVersionId());
        }
        this.getMinioClient().removeObject((RemoveObjectArgs)removeObjectRequest.build());
    }

    private void copyObject(String srcBucketName, String srcObjectName) throws MinioException, IOException, InvalidKeyException, NoSuchAlgorithmException {
        String destinationBucketName = this.getConfiguration().getDestinationBucketName();
        if (ObjectHelper.isEmpty((String)destinationBucketName)) {
            throw new IllegalArgumentException("Destination Bucket name must be specified to copy operation");
        }
        String destinationObjectName = ObjectHelper.isNotEmpty((String)this.getConfiguration().getDestinationObjectName()) ? this.getConfiguration().getDestinationObjectName() : srcObjectName;
        LOG.trace("Copying object from bucket {} with objectName {} to bucket {}...", new Object[]{srcBucketName, srcObjectName, destinationBucketName});
        CopySource.Builder copySourceBuilder = (CopySource.Builder)((CopySource.Builder)CopySource.builder().bucket(srcBucketName)).object(srcObjectName);
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getServerSideEncryptionCustomerKey, arg_0 -> ((CopySource.Builder)copySourceBuilder).ssec(arg_0));
        MinioChecks.checkLengthAndSetConfig(this.getConfiguration()::getOffset, arg_0 -> ((CopySource.Builder)copySourceBuilder).offset(arg_0));
        MinioChecks.checkLengthAndSetConfig(this.getConfiguration()::getLength, arg_0 -> ((CopySource.Builder)copySourceBuilder).length(arg_0));
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getVersionId, arg_0 -> ((CopySource.Builder)copySourceBuilder).versionId(arg_0));
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getMatchETag, arg_0 -> ((CopySource.Builder)copySourceBuilder).matchETag(arg_0));
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getNotMatchETag, arg_0 -> ((CopySource.Builder)copySourceBuilder).notMatchETag(arg_0));
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getModifiedSince, arg_0 -> ((CopySource.Builder)copySourceBuilder).modifiedSince(arg_0));
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getUnModifiedSince, arg_0 -> ((CopySource.Builder)copySourceBuilder).unmodifiedSince(arg_0));
        CopyObjectArgs.Builder copyObjectRequest = (CopyObjectArgs.Builder)((CopyObjectArgs.Builder)CopyObjectArgs.builder().source((CopySource)copySourceBuilder.build()).bucket(this.getConfiguration().getDestinationBucketName())).object(destinationObjectName);
        MinioChecks.checkIfConfigIsNotEmptyAndSetAndConfig(this.getConfiguration()::getServerSideEncryption, arg_0 -> ((CopyObjectArgs.Builder)copyObjectRequest).sse(arg_0));
        this.getMinioClient().copyObject((CopyObjectArgs)copyObjectRequest.build());
    }

    protected void processRollback(Exchange exchange) {
        Exception cause = exchange.getException();
        if (ObjectHelper.isNotEmpty((Object)cause)) {
            LOG.warn("Exchange failed, so rolling back message status: {}", (Object)exchange, (Object)cause);
        } else {
            LOG.warn("Exchange failed, so rolling back message status: {}", (Object)exchange);
        }
    }

    protected MinioConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    protected MinioClient getMinioClient() {
        return this.getEndpoint().getMinioClient();
    }

    public MinioEndpoint getEndpoint() {
        return (MinioEndpoint)super.getEndpoint();
    }

    private Exchange createExchange(String objectName) throws Exception {
        LOG.trace("Getting object with objectName {} from bucket {}...", (Object)objectName, (Object)this.getConfiguration().getBucketName());
        Exchange exchange = this.createExchange(true);
        exchange.setPattern(this.getEndpoint().getExchangePattern());
        Message message = exchange.getIn();
        LOG.trace("Got object!");
        this.getEndpoint().getObjectStat(objectName, message);
        return exchange;
    }

    public String toString() {
        if (ObjectHelper.isEmpty((String)this.minioConsumerToString)) {
            this.minioConsumerToString = "MinioConsumer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.minioConsumerToString;
    }
}

