/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mqtt;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.mqtt.MQTTConfiguration;
import org.apache.camel.component.mqtt.MQTTEndpoint;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.fusesource.mqtt.client.Callback;
import org.fusesource.mqtt.client.QoS;

public class MQTTProducer
extends DefaultAsyncProducer
implements Processor {
    private final MQTTEndpoint mqttEndpoint;

    public MQTTProducer(MQTTEndpoint mqttEndpoint) {
        super((Endpoint)mqttEndpoint);
        this.mqttEndpoint = mqttEndpoint;
    }

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        byte[] body;
        if (!this.mqttEndpoint.isConnected()) {
            try {
                this.ensureConnected();
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
                callback.done(true);
                return true;
            }
        }
        if ((body = (byte[])exchange.getIn().getBody(byte[].class)) != null) {
            MQTTConfiguration configuration = this.mqttEndpoint.getConfiguration();
            boolean retain = (Boolean)exchange.getProperty(configuration.getMqttRetainPropertyName(), (Object)configuration.isByDefaultRetain(), Boolean.class);
            QoS qoS = configuration.getQoS();
            Object qoSValue = exchange.getProperty(configuration.getMqttQosPropertyName());
            if (qoSValue != null) {
                qoS = MQTTConfiguration.getQoS(qoSValue.toString());
            }
            String topicName = configuration.getPublishTopicName();
            Object topicValue = exchange.getIn().getHeader("CamelMQTTPublishTopic");
            if (topicValue != null) {
                topicName = topicValue.toString();
            }
            final String name = topicName;
            try {
                this.log.debug("Publishing to {}", (Object)name);
                this.mqttEndpoint.publish(name, body, qoS, retain, new Callback<Void>(){

                    public void onSuccess(Void aVoid) {
                        MQTTProducer.this.log.trace("onSuccess from {}", (Object)name);
                        callback.done(false);
                    }

                    public void onFailure(Throwable throwable) {
                        MQTTProducer.this.log.trace("onFailure from {}", (Object)name);
                        exchange.setException(throwable);
                        callback.done(false);
                    }
                });
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
                callback.done(true);
                return true;
            }
            return false;
        }
        this.log.trace("No data to publish");
        callback.done(true);
        return true;
    }

    protected void doStart() throws Exception {
        if (!this.mqttEndpoint.getConfiguration().isLazySessionCreation()) {
            this.ensureConnected();
        }
        super.doStart();
    }

    protected synchronized void ensureConnected() throws Exception {
        if (!this.mqttEndpoint.isConnected()) {
            this.mqttEndpoint.connect();
        }
    }
}

