/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.neo4j;

import org.apache.camel.CamelContext;
import org.apache.camel.component.neo4j.Neo4jComponent;
import org.apache.camel.component.neo4j.Neo4jConfiguration;
import org.apache.camel.component.neo4j.Neo4jSimilarityFunction;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.neo4j.driver.Driver;

public class Neo4jComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private Neo4jConfiguration getOrCreateConfiguration(Neo4jComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new Neo4jConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        Neo4jComponent target = (Neo4jComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "alias": {
                this.getOrCreateConfiguration(target).setAlias((String)Neo4jComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled((Boolean)Neo4jComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((Neo4jConfiguration)Neo4jComponentConfigurer.property((CamelContext)camelContext, Neo4jConfiguration.class, (Object)value));
                return true;
            }
            case "databaseurl": 
            case "databaseUrl": {
                this.getOrCreateConfiguration(target).setDatabaseUrl((String)Neo4jComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "detachrelationship": 
            case "detachRelationship": {
                this.getOrCreateConfiguration(target).setDetachRelationship((Boolean)Neo4jComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "dimension": {
                this.getOrCreateConfiguration(target).setDimension((Integer)Neo4jComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "driver": {
                this.getOrCreateConfiguration(target).setDriver((Driver)Neo4jComponentConfigurer.property((CamelContext)camelContext, Driver.class, (Object)value));
                return true;
            }
            case "kerberosauthticket": 
            case "kerberosAuthTicket": {
                this.getOrCreateConfiguration(target).setKerberosAuthTicket((String)Neo4jComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "label": {
                this.getOrCreateConfiguration(target).setLabel((String)Neo4jComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)Neo4jComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxresults": 
            case "maxResults": {
                this.getOrCreateConfiguration(target).setMaxResults((Integer)Neo4jComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "minscore": 
            case "minScore": {
                this.getOrCreateConfiguration(target).setMinScore((Double)Neo4jComponentConfigurer.property((CamelContext)camelContext, Double.TYPE, (Object)value));
                return true;
            }
            case "password": {
                this.getOrCreateConfiguration(target).setPassword((String)Neo4jComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "query": {
                this.getOrCreateConfiguration(target).setQuery((String)Neo4jComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "realm": {
                this.getOrCreateConfiguration(target).setRealm((String)Neo4jComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "similarityfunction": 
            case "similarityFunction": {
                this.getOrCreateConfiguration(target).setSimilarityFunction((Neo4jSimilarityFunction)((Object)Neo4jComponentConfigurer.property((CamelContext)camelContext, Neo4jSimilarityFunction.class, (Object)value)));
                return true;
            }
            case "token": {
                this.getOrCreateConfiguration(target).setToken((String)Neo4jComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "username": {
                this.getOrCreateConfiguration(target).setUsername((String)Neo4jComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "vectorindexname": 
            case "vectorIndexName": {
                this.getOrCreateConfiguration(target).setVectorIndexName((String)Neo4jComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public String[] getAutowiredNames() {
        return new String[]{"driver"};
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "alias": {
                return String.class;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return Neo4jConfiguration.class;
            }
            case "databaseurl": 
            case "databaseUrl": {
                return String.class;
            }
            case "detachrelationship": 
            case "detachRelationship": {
                return Boolean.TYPE;
            }
            case "dimension": {
                return Integer.class;
            }
            case "driver": {
                return Driver.class;
            }
            case "kerberosauthticket": 
            case "kerberosAuthTicket": {
                return String.class;
            }
            case "label": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "maxresults": 
            case "maxResults": {
                return Integer.TYPE;
            }
            case "minscore": 
            case "minScore": {
                return Double.TYPE;
            }
            case "password": {
                return String.class;
            }
            case "query": {
                return String.class;
            }
            case "realm": {
                return String.class;
            }
            case "similarityfunction": 
            case "similarityFunction": {
                return Neo4jSimilarityFunction.class;
            }
            case "token": {
                return String.class;
            }
            case "username": {
                return String.class;
            }
            case "vectorindexname": 
            case "vectorIndexName": {
                return String.class;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        Neo4jComponent target = (Neo4jComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "alias": {
                return this.getOrCreateConfiguration(target).getAlias();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "databaseurl": 
            case "databaseUrl": {
                return this.getOrCreateConfiguration(target).getDatabaseUrl();
            }
            case "detachrelationship": 
            case "detachRelationship": {
                return this.getOrCreateConfiguration(target).isDetachRelationship();
            }
            case "dimension": {
                return this.getOrCreateConfiguration(target).getDimension();
            }
            case "driver": {
                return this.getOrCreateConfiguration(target).getDriver();
            }
            case "kerberosauthticket": 
            case "kerberosAuthTicket": {
                return this.getOrCreateConfiguration(target).getKerberosAuthTicket();
            }
            case "label": {
                return this.getOrCreateConfiguration(target).getLabel();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maxresults": 
            case "maxResults": {
                return this.getOrCreateConfiguration(target).getMaxResults();
            }
            case "minscore": 
            case "minScore": {
                return this.getOrCreateConfiguration(target).getMinScore();
            }
            case "password": {
                return this.getOrCreateConfiguration(target).getPassword();
            }
            case "query": {
                return this.getOrCreateConfiguration(target).getQuery();
            }
            case "realm": {
                return this.getOrCreateConfiguration(target).getRealm();
            }
            case "similarityfunction": 
            case "similarityFunction": {
                return this.getOrCreateConfiguration(target).getSimilarityFunction();
            }
            case "token": {
                return this.getOrCreateConfiguration(target).getToken();
            }
            case "username": {
                return this.getOrCreateConfiguration(target).getUsername();
            }
            case "vectorindexname": 
            case "vectorIndexName": {
                return this.getOrCreateConfiguration(target).getVectorIndexName();
            }
        }
        return null;
    }
}

