/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.FallbackConverter;
import org.apache.camel.component.netty.NettyConverter;
import org.apache.camel.component.netty.http.NettyHttpHelper;
import org.apache.camel.component.netty.http.NettyHttpMessage;
import org.apache.camel.spi.TypeConverterRegistry;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;

@Converter
public final class NettyHttpConverter {
    private NettyHttpConverter() {
    }

    @FallbackConverter
    public static Object convertToHttpRequest(Class<?> type, Exchange exchange, Object value, TypeConverterRegistry registry) {
        NettyHttpMessage msg;
        if (value != null && HttpRequest.class.isAssignableFrom(type) && (msg = exchange.hasOut() ? (NettyHttpMessage)((Object)exchange.getOut(NettyHttpMessage.class)) : (NettyHttpMessage)((Object)exchange.getIn(NettyHttpMessage.class))) != null && msg.getBody() == value) {
            HttpRequest request = msg.getHttpRequest();
            request.getContent().resetReaderIndex();
            return request;
        }
        return null;
    }

    @FallbackConverter
    public static Object convertToHttpResponse(Class<?> type, Exchange exchange, Object value, TypeConverterRegistry registry) {
        NettyHttpMessage msg;
        if (value != null && HttpResponse.class.isAssignableFrom(type) && (msg = exchange.hasOut() ? (NettyHttpMessage)((Object)exchange.getOut(NettyHttpMessage.class)) : (NettyHttpMessage)((Object)exchange.getIn(NettyHttpMessage.class))) != null && msg.getBody() == value) {
            return msg.getHttpResponse();
        }
        return null;
    }

    @Converter
    public static String toString(HttpResponse response, Exchange exchange) {
        String contentType = response.headers().get("Content-Type");
        String charset = NettyHttpHelper.getCharsetFromContentType(contentType);
        if (charset == null && exchange != null) {
            charset = (String)exchange.getProperty("CamelCharsetName", String.class);
        }
        if (charset != null) {
            return response.getContent().toString(Charset.forName(charset));
        }
        return response.getContent().toString(Charset.defaultCharset());
    }

    @Converter
    public static byte[] toBytes(HttpResponse response, Exchange exchange) {
        return NettyConverter.toByteArray((ChannelBuffer)response.getContent(), (Exchange)exchange);
    }

    @Converter
    public static InputStream toInputStream(HttpResponse response, Exchange exchange) {
        return NettyConverter.toInputStream((ChannelBuffer)response.getContent(), (Exchange)exchange);
    }
}

