/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.netty.ChannelHandlerFactory;
import org.apache.camel.component.netty.ClientInitializerFactory;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyProducer;
import org.apache.camel.component.netty.NettyServerBootstrapConfiguration;
import org.apache.camel.component.netty.http.InitializerHelper;
import org.apache.camel.component.netty.http.NettyHttpConfiguration;
import org.apache.camel.component.netty.http.NettyHttpProducer;
import org.apache.camel.component.netty.http.handlers.HttpClientChannelHandler;
import org.apache.camel.component.netty.http.handlers.HttpInboundStreamHandler;
import org.apache.camel.component.netty.http.handlers.HttpOutboundStreamHandler;
import org.apache.camel.component.netty.ssl.SSLEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientInitializerFactory
extends ClientInitializerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientInitializerFactory.class);
    protected NettyHttpConfiguration configuration;
    private NettyHttpProducer producer;
    private SSLContext sslContext;
    private List<SNIServerName> sniServerNames;

    public HttpClientInitializerFactory() {
    }

    public HttpClientInitializerFactory(NettyHttpProducer nettyProducer) {
        this.producer = nettyProducer;
        try {
            this.sslContext = this.createSSLContext(this.producer);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        if (this.sslContext != null) {
            LOG.info("Created SslContext {}", (Object)this.sslContext);
        }
        this.configuration = nettyProducer.getConfiguration();
    }

    public ClientInitializerFactory createPipelineFactory(NettyProducer nettyProducer) {
        return new HttpClientInitializerFactory((NettyHttpProducer)nettyProducer);
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        SslHandler sslHandler = this.configureClientSSLOnDemand();
        if (sslHandler != null) {
            LOG.debug("Client SSL handler configured and added as an interceptor against the ChannelPipeline: {}", (Object)sslHandler);
            pipeline.addLast("ssl", (ChannelHandler)sslHandler);
        }
        pipeline.addLast("http", (ChannelHandler)new HttpClientCodec());
        this.addToPipeline(this.producer.getConfiguration().getEncodersAsList(), pipeline, "encoder-");
        this.addToPipeline(this.producer.getConfiguration().getDecodersAsList(), pipeline, "decoder-");
        if (this.configuration.isDisableStreamCache()) {
            pipeline.addLast("inbound-streamer", (ChannelHandler)new HttpInboundStreamHandler());
        }
        pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(this.configuration.getChunkedMaxContentLength()));
        pipeline.addLast("outbound-streamer", (ChannelHandler)new HttpOutboundStreamHandler());
        if (this.producer.getConfiguration().getRequestTimeout() > 0L) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Using request timeout {} millis", (Object)this.producer.getConfiguration().getRequestTimeout());
            }
            ReadTimeoutHandler timeout = new ReadTimeoutHandler(this.producer.getConfiguration().getRequestTimeout(), TimeUnit.MILLISECONDS);
            pipeline.addLast("timeout", (ChannelHandler)timeout);
        }
        pipeline.addLast("handler", (ChannelHandler)new HttpClientChannelHandler(this.producer));
    }

    private void addToPipeline(List<ChannelHandler> handlers, ChannelPipeline pipeline, String prefix) {
        for (int x = 0; x < handlers.size(); ++x) {
            ChannelHandler handler = handlers.get(x);
            if (handler instanceof ChannelHandlerFactory) {
                handler = ((ChannelHandlerFactory)handler).newChannelHandler();
            }
            pipeline.addLast(prefix + x, handler);
        }
    }

    private SSLContext createSSLContext(NettyProducer producer) throws Exception {
        SSLContext answer;
        NettyConfiguration configuration = producer.getConfiguration();
        if (!configuration.isSsl()) {
            return null;
        }
        if (configuration.getSslContextParameters() != null) {
            answer = configuration.getSslContextParameters().createSSLContext(producer.getContext());
            if (answer.getSupportedSSLParameters().getServerNames() != null && !answer.getSupportedSSLParameters().getServerNames().isEmpty()) {
                this.sniServerNames = answer.getSupportedSSLParameters().getServerNames();
            }
        } else {
            char[] pw;
            InitializerHelper.logConfiguration((NettyServerBootstrapConfiguration)configuration);
            char[] cArray = pw = configuration.getPassphrase() != null ? configuration.getPassphrase().toCharArray() : null;
            if (configuration.getKeyStoreFile() != null || configuration.getTrustStoreFile() != null) {
                SSLEngineFactory sslEngineFactory = new SSLEngineFactory();
                answer = sslEngineFactory.createSSLContext(producer.getContext(), configuration.getKeyStoreFormat(), configuration.getSecurityProvider(), "file:" + configuration.getKeyStoreFile().getPath(), "file:" + configuration.getTrustStoreFile().getPath(), pw);
            } else if (configuration.getKeyStoreResource() != null || configuration.getTrustStoreResource() != null) {
                SSLEngineFactory sslEngineFactory = new SSLEngineFactory();
                answer = sslEngineFactory.createSSLContext(producer.getContext(), configuration.getKeyStoreFormat(), configuration.getSecurityProvider(), configuration.getKeyStoreResource(), configuration.getTrustStoreResource(), pw);
            } else {
                answer = SSLContext.getDefault();
            }
        }
        return answer;
    }

    private SslHandler configureClientSSLOnDemand() throws Exception {
        if (!this.producer.getConfiguration().isSsl()) {
            return null;
        }
        if (this.producer.getConfiguration().getSslHandler() != null) {
            return this.producer.getConfiguration().getSslHandler();
        }
        if (this.sslContext != null) {
            URI uri = new URI(this.producer.getEndpoint().getEndpointUri());
            SSLEngine engine = this.sslContext.createSSLEngine(uri.getHost(), uri.getPort());
            engine.setUseClientMode(true);
            SSLParameters sslParameters = engine.getSSLParameters();
            sslParameters.setServerNames(this.sniServerNames != null ? this.sniServerNames : List.of(new SNIHostName(uri.getHost())));
            engine.setSSLParameters(sslParameters);
            if (this.producer.getConfiguration().getSslContextParameters() == null) {
                engine.setEnabledProtocols(this.producer.getConfiguration().getEnabledProtocols().split(","));
            }
            return new SslHandler(engine);
        }
        return null;
    }
}

