/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.Service;
import org.apache.camel.component.netty.NettyComponent;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyServerBootstrapConfiguration;
import org.apache.camel.component.netty.http.DefaultNettyHttpBinding;
import org.apache.camel.component.netty.http.HttpServerBootstrapFactory;
import org.apache.camel.component.netty.http.HttpServerConsumerChannelFactory;
import org.apache.camel.component.netty.http.HttpServerInitializerFactory;
import org.apache.camel.component.netty.http.NettyHttpBinding;
import org.apache.camel.component.netty.http.NettyHttpConfiguration;
import org.apache.camel.component.netty.http.NettyHttpConsumer;
import org.apache.camel.component.netty.http.NettyHttpEndpoint;
import org.apache.camel.component.netty.http.NettyHttpHeaderFilterStrategy;
import org.apache.camel.component.netty.http.NettyHttpRestHeaderFilterStrategy;
import org.apache.camel.component.netty.http.NettyHttpSecurityConfiguration;
import org.apache.camel.component.netty.http.NettySharedHttpServer;
import org.apache.camel.component.netty.http.RestNettyHttpBinding;
import org.apache.camel.component.netty.http.handlers.HttpServerMultiplexChannelHandler;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestApiConsumerFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.spi.RestProducerFactory;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.RestComponentHelper;
import org.apache.camel.support.RestProducerFactoryHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="netty-http")
public class NettyHttpComponent
extends NettyComponent
implements HeaderFilterStrategyAware,
RestConsumerFactory,
RestApiConsumerFactory,
RestProducerFactory,
SSLContextParametersAware {
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpComponent.class);
    private final Map<Integer, HttpServerConsumerChannelFactory> multiplexChannelHandlers = new HashMap<Integer, HttpServerConsumerChannelFactory>();
    private final Map<String, HttpServerBootstrapFactory> bootstrapFactories = new HashMap<String, HttpServerBootstrapFactory>();
    @Metadata(label="advanced")
    private NettyHttpBinding nettyHttpBinding;
    @Metadata(label="advanced")
    private HeaderFilterStrategy headerFilterStrategy;
    @Metadata(label="security")
    private NettyHttpSecurityConfiguration securityConfiguration;
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;
    @Metadata(label="consumer")
    private boolean muteException;

    public NettyHttpComponent() {
        super(NettyHttpEndpoint.class);
        this.setConfiguration(new NettyHttpConfiguration());
        this.setHeaderFilterStrategy((HeaderFilterStrategy)new NettyHttpHeaderFilterStrategy());
        this.setNettyHttpBinding(new RestNettyHttpBinding(this.getHeaderFilterStrategy()));
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        boolean hasSlash;
        boolean hasProtocol;
        NettyHttpConfiguration config = this.getConfiguration() != null ? this.getConfiguration().copy() : new NettyHttpConfiguration();
        HeaderFilterStrategy headerFilterStrategy = (HeaderFilterStrategy)this.resolveAndRemoveReferenceParameter(parameters, "headerFilterStrategy", HeaderFilterStrategy.class);
        boolean muteException = (Boolean)this.getAndRemoveParameter(parameters, "muteException", Boolean.TYPE, this.isMuteException());
        NettyServerBootstrapConfiguration bootstrapConfiguration = (NettyServerBootstrapConfiguration)this.resolveAndRemoveReferenceParameter(parameters, "bootstrapConfiguration", NettyServerBootstrapConfiguration.class);
        if (bootstrapConfiguration != null) {
            HashMap options = new HashMap();
            BeanIntrospection beanIntrospection = PluginHelper.getBeanIntrospection((CamelContext)this.getCamelContext());
            if (beanIntrospection.getProperties((Object)bootstrapConfiguration, options, null, false)) {
                PropertyBindingSupport.bindProperties((CamelContext)this.getCamelContext(), (Object)((Object)config), options);
            }
        }
        NettyHttpSecurityConfiguration securityConfiguration = (NettyHttpSecurityConfiguration)this.resolveAndRemoveReferenceParameter(parameters, "securityConfiguration", NettyHttpSecurityConfiguration.class);
        Map securityOptions = PropertiesHelper.extractProperties(parameters, (String)"securityConfiguration.");
        NettyHttpBinding bindingFromUri = (NettyHttpBinding)this.resolveAndRemoveReferenceParameter(parameters, "nettyHttpBinding", NettyHttpBinding.class);
        int sharedPort = -1;
        NettySharedHttpServer shared = (NettySharedHttpServer)this.resolveAndRemoveReferenceParameter(parameters, "nettySharedHttpServer", NettySharedHttpServer.class);
        if (shared != null) {
            LOG.debug("Using NettySharedHttpServer: {} with port: {}", (Object)shared, (Object)shared.getPort());
            sharedPort = shared.getPort();
        }
        boolean bl = hasProtocol = remaining != null && (((String)remaining).startsWith("http://") || ((String)remaining).startsWith("http:") || ((String)remaining).startsWith("https://") || ((String)remaining).startsWith("https:") || ((String)remaining).startsWith("proxy://") || ((String)remaining).startsWith("proxy:"));
        if (!hasProtocol) {
            remaining = "http://" + (String)remaining;
        }
        boolean bl2 = hasSlash = ((String)remaining).startsWith("http://") || ((String)remaining).startsWith("https://") || ((String)remaining).startsWith("proxy://");
        if (!hasSlash) {
            remaining = ((String)remaining).startsWith("http:") ? "http://" + ((String)remaining).substring(5) : "https://" + ((String)remaining).substring(6);
        }
        LOG.debug("Netty http url: {}", remaining);
        if (sharedPort != -1) {
            config.setPort(sharedPort);
        } else if (config.getPort() == -1 || config.getPort() == 0) {
            if (((String)remaining).startsWith("http:")) {
                config.setPort(80);
            } else if (((String)remaining).startsWith("https:")) {
                config.setPort(443);
            } else if (((String)remaining).startsWith("proxy:")) {
                config.setPort(3128);
            }
        }
        if (config.getPort() == -1) {
            throw new IllegalArgumentException("Port number must be configured");
        }
        if ((config = this.parseConfiguration((NettyConfiguration)config, (String)remaining, (Map)parameters)).getSslContextParameters() == null) {
            config.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        config.validateConfiguration();
        URI u = new URI(UnsafeUriCharactersEncoder.encodeHttpURI((String)remaining));
        String addressUri = URISupport.createRemainingURI((URI)u, parameters).toString();
        NettyHttpEndpoint answer = new NettyHttpEndpoint(addressUri, this, config);
        answer.getConfiguration().setMuteException(muteException);
        this.setProperties((Endpoint)answer, parameters);
        if (answer.getNettyHttpBinding() == null) {
            NettyHttpBinding binding = bindingFromUri != null ? bindingFromUri : this.getNettyHttpBinding();
            if (binding instanceof RestNettyHttpBinding) {
                RestNettyHttpBinding copy = ((RestNettyHttpBinding)binding).copy();
                answer.setNettyHttpBinding(copy);
            } else if (binding instanceof DefaultNettyHttpBinding) {
                DefaultNettyHttpBinding copy = ((DefaultNettyHttpBinding)binding).copy();
                answer.setNettyHttpBinding(copy);
            }
        }
        if (headerFilterStrategy != null) {
            answer.setHeaderFilterStrategy(headerFilterStrategy);
        } else if (answer.getHeaderFilterStrategy() == null) {
            answer.setHeaderFilterStrategy(this.getHeaderFilterStrategy());
        }
        if (securityConfiguration != null) {
            answer.setSecurityConfiguration(securityConfiguration);
        } else if (answer.getSecurityConfiguration() == null) {
            answer.setSecurityConfiguration(this.getSecurityConfiguration());
        }
        if (securityOptions != null && !securityOptions.isEmpty()) {
            securityConfiguration = answer.getSecurityConfiguration();
            if (securityConfiguration == null) {
                securityConfiguration = new NettyHttpSecurityConfiguration();
                answer.setSecurityConfiguration(securityConfiguration);
            }
            this.setProperties(securityConfiguration, securityOptions);
            this.validateParameters(uri, securityOptions, null);
        }
        answer.setNettySharedHttpServer(shared);
        return answer;
    }

    protected NettyHttpConfiguration parseConfiguration(NettyConfiguration configuration, String remaining, Map<String, Object> parameters) throws Exception {
        String safe = UnsafeUriCharactersEncoder.encodeHttpURI((String)remaining);
        URI uri = new URI(safe);
        configuration.parseURI(uri, parameters, (NettyComponent)this, new String[]{"http", "https", "proxy"});
        configuration.setProtocol("tcp");
        configuration.setTextline(false);
        if ("https".equals(uri.getScheme())) {
            configuration.setSsl(true);
        }
        if (configuration instanceof NettyHttpConfiguration) {
            NettyHttpConfiguration httpConfiguration = (NettyHttpConfiguration)configuration;
            httpConfiguration.setPath(uri.getPath());
            return httpConfiguration;
        }
        throw new IllegalStateException("Received NettyConfiguration instead of expected NettyHttpConfiguration, this is not supported.");
    }

    public NettyHttpBinding getNettyHttpBinding() {
        return this.nettyHttpBinding;
    }

    public void setNettyHttpBinding(NettyHttpBinding nettyHttpBinding) {
        this.nettyHttpBinding = nettyHttpBinding;
    }

    public NettyHttpConfiguration getConfiguration() {
        return (NettyHttpConfiguration)super.getConfiguration();
    }

    public void setConfiguration(NettyHttpConfiguration configuration) {
        super.setConfiguration((NettyConfiguration)configuration);
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public NettyHttpSecurityConfiguration getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public void setSecurityConfiguration(NettyHttpSecurityConfiguration securityConfiguration) {
        this.securityConfiguration = securityConfiguration;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public boolean isMuteException() {
        return this.muteException;
    }

    public void setMuteException(boolean muteException) {
        this.muteException = muteException;
    }

    public synchronized HttpServerConsumerChannelFactory getMultiplexChannelHandler(int port) {
        return this.multiplexChannelHandlers.computeIfAbsent(port, s -> NettyHttpComponent.newHttpServerConsumerChannelFactory(port));
    }

    private static HttpServerConsumerChannelFactory newHttpServerConsumerChannelFactory(int port) {
        HttpServerMultiplexChannelHandler answer = new HttpServerMultiplexChannelHandler();
        answer.init(port);
        return answer;
    }

    protected synchronized HttpServerBootstrapFactory getOrCreateHttpNettyServerBootstrapFactory(NettyHttpConsumer consumer) {
        String key = consumer.getConfiguration().getAddress();
        return this.bootstrapFactories.computeIfAbsent(key, s -> this.newHttpServerBootstrapFactory(consumer));
    }

    private HttpServerBootstrapFactory newHttpServerBootstrapFactory(NettyHttpConsumer consumer) {
        HttpServerConsumerChannelFactory channelFactory = this.getMultiplexChannelHandler(consumer.getConfiguration().getPort());
        HttpServerBootstrapFactory answer = new HttpServerBootstrapFactory(channelFactory);
        answer.init(this.getCamelContext(), (NettyServerBootstrapConfiguration)consumer.getConfiguration(), (ChannelInitializer<Channel>)new HttpServerInitializerFactory(consumer));
        return answer;
    }

    public Consumer createConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, verb, basePath, uriTemplate, configuration, parameters, false);
    }

    public Consumer createApiConsumer(CamelContext camelContext, Processor processor, String contextPath, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, "GET", contextPath, null, configuration, parameters, true);
    }

    Consumer doCreateConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, RestConfiguration configuration, Map<String, Object> parameters, boolean api) throws Exception {
        String contextPath;
        int num;
        Object path = basePath;
        if (uriTemplate != null) {
            path = uriTemplate.startsWith("/") ? (String)path + uriTemplate : (String)path + "/" + uriTemplate;
        }
        path = FileUtil.stripLeadingSeparator((String)path);
        String scheme = "http";
        String host = "";
        int port = 0;
        RestConfiguration config = configuration;
        if (config == null) {
            config = CamelContextHelper.getRestConfiguration((CamelContext)this.getCamelContext(), (String)"netty-http");
        }
        if (config.getScheme() != null) {
            scheme = config.getScheme();
        }
        if (config.getHost() != null) {
            host = config.getHost();
        }
        if ((num = config.getPort()) > 0) {
            port = num;
        }
        if (ObjectHelper.isNotEmpty((String)(contextPath = config.getContextPath()))) {
            contextPath = FileUtil.stripTrailingSeparator((String)contextPath);
            if (ObjectHelper.isNotEmpty((String)(contextPath = FileUtil.stripLeadingSeparator((String)contextPath)))) {
                path = contextPath + "/" + (String)path;
            }
        }
        if (ObjectHelper.isEmpty((String)host)) {
            host = RestComponentHelper.resolveRestHostName((String)host, (RestConfiguration)config);
        }
        Map map = RestComponentHelper.initRestEndpointProperties((String)"netty-http", (RestConfiguration)config);
        boolean cors = config.isEnableCORS();
        if (api) {
            map.put("matchOnUriPrefix", "true");
        }
        RestComponentHelper.addHttpRestrictParam((Map)map, (String)verb, (boolean)cors);
        String url = RestComponentHelper.createRestConsumerUrl((String)"netty-http", (String)scheme, (String)host, (int)port, (String)path, (Map)map);
        NettyHttpEndpoint endpoint = (NettyHttpEndpoint)camelContext.getEndpoint(url, parameters);
        Consumer consumer = endpoint.createConsumer(processor);
        if (config.getConsumerProperties() != null && !config.getConsumerProperties().isEmpty()) {
            this.setProperties(camelContext, consumer, config.getConsumerProperties());
        }
        return consumer;
    }

    public Producer createProducer(CamelContext camelContext, String host, String verb, String basePath, String uriTemplate, String queryParameters, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        String query;
        basePath = FileUtil.stripLeadingSeparator((String)basePath);
        uriTemplate = FileUtil.stripLeadingSeparator((String)uriTemplate);
        String url = "netty-http:" + host;
        if (!ObjectHelper.isEmpty((String)basePath)) {
            url = url + "/" + basePath;
        }
        if (!ObjectHelper.isEmpty((String)uriTemplate)) {
            url = url + "/" + uriTemplate;
        }
        RestConfiguration config = CamelContextHelper.getRestConfiguration((CamelContext)this.getCamelContext(), null, (String)"netty-http");
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        if ((config.getProducerComponent() == null || config.getProducerComponent().equals("netty-http")) && config.getEndpointProperties() != null && !config.getEndpointProperties().isEmpty()) {
            map.putAll(config.getEndpointProperties());
        }
        if (host.startsWith("https:")) {
            map.put("ssl", true);
        }
        if (!(query = URISupport.createQueryString(map)).isEmpty()) {
            url = url + "?" + query;
        }
        parameters = parameters != null ? new HashMap<String, Object>(parameters) : new HashMap();
        RestProducerFactoryHelper.setupComponentFor((String)url, (CamelContext)camelContext, (Map)((Map)parameters.remove("component")));
        NettyHttpEndpoint endpoint = (NettyHttpEndpoint)camelContext.getEndpoint(url, parameters);
        String path = uriTemplate != null ? uriTemplate : basePath;
        HeaderFilterStrategy headerFilterStrategy = (HeaderFilterStrategy)this.resolveAndRemoveReferenceParameter(parameters, "headerFilterStrategy", HeaderFilterStrategy.class);
        if (headerFilterStrategy != null) {
            endpoint.setHeaderFilterStrategy(headerFilterStrategy);
        } else {
            endpoint.setHeaderFilterStrategy((HeaderFilterStrategy)new NettyHttpRestHeaderFilterStrategy(path, queryParameters));
        }
        ServiceHelper.startService((Service)endpoint);
        return endpoint.createProducer();
    }

    protected void doInit() throws Exception {
        super.doInit();
        try {
            RestConfiguration config = CamelContextHelper.getRestConfiguration((CamelContext)this.getCamelContext(), (String)"netty-http");
            if (config.getComponentProperties() != null && !config.getComponentProperties().isEmpty()) {
                this.setProperties((Object)this, config.getComponentProperties());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService(this.bootstrapFactories.values());
        this.bootstrapFactories.clear();
        ServiceHelper.stopService(this.multiplexChannelHandlers.values());
        this.multiplexChannelHandlers.clear();
    }
}

