/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.component.netty.ClientModeTCPNettyServerBootstrapFactory;
import org.apache.camel.component.netty.DefaultServerInitializerFactory;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyConsumerExceptionHandler;
import org.apache.camel.component.netty.NettyEndpoint;
import org.apache.camel.component.netty.NettyServerBootstrapConfiguration;
import org.apache.camel.component.netty.NettyServerBootstrapFactory;
import org.apache.camel.component.netty.ServerInitializerFactory;
import org.apache.camel.component.netty.SingleTCPNettyServerBootstrapFactory;
import org.apache.camel.component.netty.SingleUDPNettyServerBootstrapFactory;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(NettyConsumer.class);
    private CamelContext context = this.getEndpoint().getCamelContext();
    private NettyConfiguration configuration;
    private NettyServerBootstrapFactory nettyServerBootstrapFactory;

    public NettyConsumer(NettyEndpoint nettyEndpoint, Processor processor, NettyConfiguration configuration) {
        super((Endpoint)nettyEndpoint, processor);
        this.configuration = configuration;
        this.setNettyServerBootstrapFactory(configuration.getNettyServerBootstrapFactory());
        this.setExceptionHandler(new NettyConsumerExceptionHandler(this));
    }

    public NettyEndpoint getEndpoint() {
        return (NettyEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.debug("Netty consumer binding to: {}", (Object)this.configuration.getAddress());
        if (this.nettyServerBootstrapFactory == null) {
            ServerInitializerFactory factory = this.configuration.getServerInitializerFactory();
            ServerInitializerFactory pipelineFactory = factory != null ? factory.createPipelineFactory(this) : new DefaultServerInitializerFactory(this);
            this.nettyServerBootstrapFactory = this.isTcp() ? (this.configuration.isClientMode() ? new ClientModeTCPNettyServerBootstrapFactory() : new SingleTCPNettyServerBootstrapFactory()) : new SingleUDPNettyServerBootstrapFactory();
            this.nettyServerBootstrapFactory.init(this.context, (NettyServerBootstrapConfiguration)this.configuration, (ChannelInitializer<Channel>)pipelineFactory);
        }
        ServiceHelper.startService((Service)this.nettyServerBootstrapFactory);
        LOG.info("Netty consumer bound to: {}", (Object)this.configuration.getAddress());
    }

    protected void doStop() throws Exception {
        LOG.debug("Netty consumer unbinding from: {}", (Object)this.configuration.getAddress());
        ServiceHelper.stopService((Service)this.nettyServerBootstrapFactory);
        LOG.info("Netty consumer unbound from: {}", (Object)this.configuration.getAddress());
        super.doStop();
    }

    public CamelContext getContext() {
        return this.context;
    }

    public NettyConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(NettyConfiguration configuration) {
        this.configuration = configuration;
    }

    public NettyServerBootstrapFactory getNettyServerBootstrapFactory() {
        return this.nettyServerBootstrapFactory;
    }

    public void setNettyServerBootstrapFactory(NettyServerBootstrapFactory nettyServerBootstrapFactory) {
        this.nettyServerBootstrapFactory = nettyServerBootstrapFactory;
    }

    protected boolean isTcp() {
        return this.configuration.getProtocol().equalsIgnoreCase("tcp");
    }
}

