/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.oaipmh.component;

import java.net.URI;
import java.util.List;
import java.util.function.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.oaipmh.component.OAIPMHEndpoint;
import org.apache.camel.oaipmh.handler.Harvester;
import org.apache.camel.oaipmh.handler.ProducerResponseHandler;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAIPMHProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(OAIPMHProducer.class);
    private OAIPMHEndpoint endpoint;

    public OAIPMHProducer(OAIPMHEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        Harvester harvester = new Harvester(new ProducerResponseHandler(), this.endpoint.getUrl(), this.endpoint.getVerb(), this.endpoint.getMetadataPrefix(), this.endpoint.getUntil(), this.endpoint.getFrom(), this.endpoint.getSet(), this.endpoint.getIdentifier());
        this.overrideHarvesterConfigs(exchange.getIn(), harvester);
        if (this.endpoint.isIgnoreSSLWarnings()) {
            harvester.getHttpClient().setIgnoreSSLWarnings(true);
        }
        List<String> synHarvest = harvester.synHarvest(this.endpoint.isOnlyFirst());
        exchange.getMessage().setBody(synHarvest);
        if (this.endpoint.isOnlyFirst() && harvester.getResumptionToken() != null) {
            exchange.getMessage().setHeader("CamelOaimphResumptionToken", (Object)harvester.getResumptionToken());
        } else {
            exchange.getMessage().removeHeader("CamelOaimphResumptionToken");
        }
    }

    private void overrideHarvesterConfigs(Message msg, Harvester harvester) {
        this.checkAndSetConfigs(msg, "CamelOaimphUrl", x -> harvester.setBaseURI(URI.create(x)), String.class);
        this.checkAndSetConfigs(msg, "CamelOaimphEndpointUrl", x -> harvester.setBaseURI(URI.create(x)), String.class);
        this.checkAndSetConfigs(msg, "CamelOaimphVerb", harvester::setVerb, String.class);
        this.checkAndSetConfigs(msg, "CamelOaimphMetadataPrefix", harvester::setMetadata, String.class);
        this.checkAndSetConfigs(msg, "CamelOaimphUntil", harvester::setUntil, String.class);
        this.checkAndSetConfigs(msg, "CamelOaimphFrom", harvester::setFrom, String.class);
        this.checkAndSetConfigs(msg, "CamelOaimphSet", harvester::setSet, String.class);
        this.checkAndSetConfigs(msg, "CamelOaimphIdentifier", harvester::setIdentifier, String.class);
        this.checkAndSetConfigs(msg, "CamelOaimphResumptionToken", harvester::setResumptionToken, String.class);
        this.checkAndSetConfigs(msg, "CamelOaimphOnlyFirst", this.endpoint::setOnlyFirst, Boolean.class);
        this.checkAndSetConfigs(msg, "CamelOaimphIgnoreSSLWarnings", this.endpoint::setIgnoreSSLWarnings, Boolean.class);
    }

    private <T> void checkAndSetConfigs(Message message, String key, Consumer<T> fn, Class<T> type) {
        Object header = message.getHeader(key, type);
        if (!ObjectHelper.isEmpty((Object)header)) {
            fn.accept(header);
        }
    }
}

