/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.oaipmh.utils;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.TrustSelfSignedStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.net.URLEncodedUtils;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAIPMHHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(OAIPMHHttpClient.class);
    private boolean ignoreSSLWarnings;

    public String doRequest(URI baseURI, String verb, String set, String from, String until, String metadataPrefix, String token, String identifier) throws IOException, URISyntaxException {
        try (CloseableHttpClient httpclient = this.getCloseableHttpClient();){
            URIBuilder builder = new URIBuilder();
            builder.setScheme(baseURI.getScheme()).setHost(baseURI.getHost()).setPort(baseURI.getPort()).setPath(baseURI.getPath()).addParameter("verb", verb).addParameters(URLEncodedUtils.parse((URI)baseURI, (Charset)Charset.defaultCharset()));
            if (identifier != null) {
                builder.addParameter("identifier", identifier);
            }
            if (token != null) {
                builder.addParameter("resumptionToken", token);
            } else {
                if (metadataPrefix != null) {
                    builder.addParameter("metadataPrefix", metadataPrefix);
                }
                if (set != null) {
                    builder.addParameter("set", set);
                }
                if (from != null) {
                    builder.addParameter("from", from);
                }
                if (until != null) {
                    builder.addParameter("until", until);
                }
            }
            HttpGet httpget = new HttpGet(builder.build());
            LOG.info("Executing request: {} ", (Object)httpget);
            HttpClientResponseHandler<String> responseHandler = new HttpClientResponseHandler<String>(){

                public String handleResponse(ClassicHttpResponse response) throws HttpException, IOException {
                    int status = response.getCode();
                    if (status >= 200 && status < 300) {
                        HttpEntity entity = response.getEntity();
                        if (entity == null) {
                            throw new IOException("No response received");
                        }
                        return EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                    }
                    throw new ClientProtocolException("Unexpected response status: " + status);
                }
            };
            String responseBody = (String)httpclient.execute((ClassicHttpRequest)httpget, (HttpClientResponseHandler)responseHandler);
            LOG.debug("Response received: {}", (Object)responseBody);
            String string = responseBody;
            return string;
        }
    }

    protected CloseableHttpClient getCloseableHttpClient() throws IOException {
        if (this.isIgnoreSSLWarnings()) {
            try {
                SSLContextBuilder builder = new SSLContextBuilder();
                builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build());
                RegistryBuilder registryBuilder = RegistryBuilder.create();
                registryBuilder.register("https", (Object)sslsf);
                return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(registryBuilder.build())).build();
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException ex) {
                throw new IOException("The HTTP Client could not be started", ex);
            }
        }
        return HttpClients.createDefault();
    }

    public boolean isIgnoreSSLWarnings() {
        return this.ignoreSSLWarnings;
    }

    public void setIgnoreSSLWarnings(boolean ignoreSSLWarnings) {
        this.ignoreSSLWarnings = ignoreSSLWarnings;
    }
}

