/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.observation;

import io.micrometer.observation.Observation;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Traceable;
import org.apache.camel.observation.MicrometerObservationSpanAdapter;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.tracing.ActiveSpanManager;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(AttributeProcessor.class);
    private final String attributeName;
    private final Expression expression;
    private String id;
    private String routeId;

    public AttributeProcessor(String tagName, Expression expression) {
        this.attributeName = (String)ObjectHelper.notNull((Object)tagName, (String)"tagName");
        this.expression = (Expression)ObjectHelper.notNull((Object)expression, (String)"expression");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            MicrometerObservationSpanAdapter camelSpan = (MicrometerObservationSpanAdapter)ActiveSpanManager.getSpan((Exchange)exchange);
            Observation observation = camelSpan.getMicrometerObservation();
            if (observation != null) {
                String tag = (String)this.expression.evaluate(exchange, String.class);
                observation.highCardinalityKeyValue(this.attributeName, tag);
            } else {
                LOG.warn("Micrometer Observation: could not find managed span for exchange={}", (Object)exchange);
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        finally {
            callback.done(true);
        }
        return true;
    }

    public String getTraceLabel() {
        return "attribute[" + this.attributeName + ", " + this.expression + "]";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String toString() {
        return this.id;
    }
}

