/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.ognl;

import ognl.ClassResolver;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionEvaluationException;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.language.ognl.CamelClassResolver;
import org.apache.camel.language.ognl.RootObject;
import org.apache.camel.support.ExpressionSupport;

public class OgnlExpression
extends ExpressionSupport {
    private final String expressionString;
    private final Class<?> type;
    private Object expression;

    public OgnlExpression(String expressionString, Class<?> type) {
        this.expressionString = expressionString;
        this.type = type;
        try {
            this.expression = Ognl.parseExpression((String)expressionString);
        }
        catch (OgnlException e) {
            throw new ExpressionIllegalSyntaxException(expressionString, (Throwable)e);
        }
    }

    public static OgnlExpression ognl(String expression) {
        return new OgnlExpression(expression, Object.class);
    }

    public <T> T evaluate(Exchange exchange, Class<T> tClass) {
        CamelClassResolver cr = new CamelClassResolver(exchange.getContext().getClassResolver());
        OgnlContext oglContext = Ognl.createDefaultContext(null, (ClassResolver)cr);
        try {
            Object value = Ognl.getValue((Object)this.expression, (OgnlContext)oglContext, (Object)new RootObject(exchange));
            return (T)exchange.getContext().getTypeConverter().convertTo(tClass, value);
        }
        catch (OgnlException e) {
            throw new ExpressionEvaluationException((Expression)this, exchange, (Throwable)e);
        }
    }

    public Class<?> getType() {
        return this.type;
    }

    protected String assertionFailureMessage(Exchange exchange) {
        return this.expressionString;
    }

    public String toString() {
        return "OGNL[" + this.expressionString + "]";
    }
}

