/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.generator.openapi;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.apicurio.datamodels.openapi.models.OasDocument;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.generator.openapi.PathVisitor;
import org.apache.camel.generator.openapi.RestDefinitionEmitter;
import org.apache.camel.generator.openapi.RestDslGenerator;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.util.ObjectHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RestDslYamlGenerator
extends RestDslGenerator<RestDslYamlGenerator> {
    private static final String[] VERBS = new String[]{"delete", "get", "head", "patch", "post", "put"};
    private static final String[] FIELD_ORDER = new String[]{"id", "path", "description", "consumes", "produces", "type", "outType", "param"};

    RestDslYamlGenerator(OasDocument document) {
        super(document);
    }

    public String generate(CamelContext context) throws Exception {
        return this.generate(context, false);
    }

    public String generate(CamelContext context, boolean generateRoutes) throws Exception {
        RestDefinitionEmitter emitter = new RestDefinitionEmitter();
        String basePath = RestDslGenerator.determineBasePathFrom(this.basePath, this.document);
        PathVisitor<RestsDefinition> restDslStatement = new PathVisitor<RestsDefinition>(basePath, emitter, this.filter, this.destinationGenerator());
        this.document.paths.getPathItems().forEach(restDslStatement::visit);
        RestsDefinition rests = emitter.result();
        ExtendedCamelContext ecc = (ExtendedCamelContext)context.adapt(ExtendedCamelContext.class);
        String xml = ecc.getModelToXMLDumper().dumpModelAsXml(context, (NamedNode)rests);
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        builderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        builderFactory.setNamespaceAware(true);
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xml)));
        Element root = document.getDocumentElement();
        NodeList elements = document.getElementsByTagName("*");
        for (int i = 0; i < elements.getLength(); ++i) {
            Element element = (Element)elements.item(i);
            element.removeAttribute("customId");
        }
        if (this.restComponent != null) {
            Element configuration = document.createElement("restConfiguration");
            configuration.setAttribute("component", this.restComponent);
            if (this.restContextPath != null) {
                configuration.setAttribute("contextPath", this.restContextPath);
            }
            if (ObjectHelper.isNotEmpty((String)this.apiContextPath)) {
                configuration.setAttribute("apiContextPath", this.apiContextPath);
            }
            if (this.clientRequestValidation) {
                configuration.setAttribute("clientRequestValidation", "true");
            }
            root.insertBefore(configuration, root.getFirstChild());
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        Transformer transformer = transformerFactory.newTransformer();
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(document), new StreamResult(writer));
        String newXml = writer.toString();
        XmlMapper xmlMapper = new XmlMapper();
        JsonNode node = xmlMapper.readTree(newXml.getBytes());
        HashMap<String, String> toTagData = new HashMap<String, String>();
        for (String v : VERBS) {
            RestDslYamlGenerator.fixVerbNodes(xmlMapper, node, v);
            RestDslYamlGenerator.fixParamNodes(xmlMapper, node, v);
            RestDslYamlGenerator.sortVerb(node, v);
            toTagData.putAll(RestDslYamlGenerator.fixToTags(xmlMapper, node, v));
        }
        node = RestDslYamlGenerator.fixRootNode(xmlMapper, node);
        if (generateRoutes) {
            for (String uri : toTagData.keySet()) {
                ObjectNode from = JsonNodeFactory.instance.objectNode();
                from.set("uri", (JsonNode)new TextNode(uri));
                String description = (String)toTagData.get(uri);
                if (description != null && !description.isBlank()) {
                    from.set("description", (JsonNode)new TextNode(description));
                }
                ObjectNode route = JsonNodeFactory.instance.objectNode();
                route.set("from", (JsonNode)from);
                ((ArrayNode)node).add(xmlMapper.createObjectNode().set("route", (JsonNode)route));
            }
        }
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER));
        String yaml = mapper.writeValueAsString((Object)node);
        return yaml;
    }

    private static JsonNode fixRootNode(XmlMapper xmlMapper, JsonNode node) {
        JsonNode r = node.get("rest");
        if (r != null) {
            ArrayNode arr = xmlMapper.createArrayNode();
            JsonNode rc = node.get("restConfiguration");
            if (rc != null) {
                arr.add(xmlMapper.createObjectNode().set("rest-configuration", rc));
            }
            arr.add(xmlMapper.createObjectNode().set("rest", r));
            node = arr;
        }
        return node;
    }

    private static void sortVerb(JsonNode node, String verb) {
        JsonNode verbs = node.path("rest").path(verb);
        if (verbs == null || verbs.isMissingNode()) {
            return;
        }
        for (JsonNode n : verbs) {
            ArrayList<String> names = new ArrayList<String>();
            if (!n.isObject()) continue;
            ObjectNode on = (ObjectNode)n;
            Iterator it = on.fieldNames();
            while (it.hasNext()) {
                names.add((String)it.next());
            }
            names.sort((o1, o2) -> {
                int i2;
                int i1 = RestDslYamlGenerator.fieldOrderIndex(o1);
                if (i1 == (i2 = RestDslYamlGenerator.fieldOrderIndex(o2))) {
                    return o1.compareTo((String)o2);
                }
                return i1 < i2 ? -1 : 1;
            });
            ArrayList<JsonNode> nodes = new ArrayList<JsonNode>();
            for (String name : names) {
                nodes.add(on.get(name));
            }
            on.removeAll();
            for (int i = 0; i < nodes.size(); ++i) {
                JsonNode nn = (JsonNode)nodes.get(i);
                String fn = (String)names.get(i);
                on.set(fn, nn);
            }
        }
    }

    private static void fixParamNodes(XmlMapper xmlMapper, JsonNode node, String verb) {
        JsonNode verbs = node.path("rest").path(verb);
        if (verbs == null || verbs.isMissingNode()) {
            return;
        }
        if (!verbs.isArray()) {
            ArrayNode arr = xmlMapper.createArrayNode();
            arr.add(verbs);
            verbs = arr;
        }
        for (JsonNode n : verbs) {
            JsonNode p = n.get("param");
            if (p != null && !p.isArray()) {
                ArrayNode arr = xmlMapper.createArrayNode();
                arr.add(p);
                ObjectNode on = (ObjectNode)n;
                on.set("param", (JsonNode)arr);
                p = arr;
            }
            if (p == null) continue;
            for (JsonNode pc : p) {
                JsonNode v;
                String k;
                ObjectNode on;
                JsonNode r = pc.get("required");
                if (r != null) {
                    String t = r.textValue();
                    boolean b = Boolean.parseBoolean(t);
                    on = (ObjectNode)pc;
                    BooleanNode bn = xmlMapper.createObjectNode().booleanNode(b);
                    on.set("required", (JsonNode)bn);
                }
                if ((r = pc.get(k = "allowableValues")) == null) {
                    k = "allowable-values";
                    r = pc.get(k);
                }
                if (r == null || !(v = r.get("value")).isArray()) continue;
                on = (ObjectNode)pc;
                on.set(k, v);
                on.remove("value");
            }
        }
    }

    private static void fixVerbNodes(XmlMapper xmlMapper, JsonNode node, String verb) {
        JsonNode verbs = node.path("rest").path(verb);
        if (verbs == null || verbs.isMissingNode()) {
            return;
        }
        if (verbs.isObject()) {
            ArrayNode arr = xmlMapper.createArrayNode();
            ObjectNode on = (ObjectNode)verbs;
            arr.add((JsonNode)on);
            ObjectNode n = (ObjectNode)node.path("rest");
            n.set(verb, (JsonNode)arr);
        }
    }

    private static Map<String, String> fixToTags(XmlMapper xmlMapper, JsonNode node, String verb) {
        HashMap<String, String> toTags = new HashMap<String, String>();
        JsonNode verbs = node.path("rest").path(verb);
        if (verbs == null || verbs.isMissingNode()) {
            return toTags;
        }
        if (!verbs.isArray()) {
            ArrayNode arr = xmlMapper.createArrayNode();
            arr.add(verbs);
            verbs = arr;
        }
        for (JsonNode n : verbs) {
            if (!n.has("to")) continue;
            ObjectNode on = (ObjectNode)n;
            JsonNode uri = n.get("to").get("uri");
            on.set("to", uri);
            String description = n.has("description") ? n.get("description").asText() : "";
            toTags.put(uri.textValue(), description);
        }
        return toTags;
    }

    private static int fieldOrderIndex(String field) {
        if ("to".equals(field)) {
            return Integer.MAX_VALUE;
        }
        for (int i = 0; i < FIELD_ORDER.length; ++i) {
            if (!FIELD_ORDER[i].equals(field)) continue;
            return i;
        }
        return 0x7FFFFFFE;
    }
}

