/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openshift;

import com.openshift.client.ApplicationScale;
import com.openshift.client.IApplication;
import com.openshift.client.IDomain;
import com.openshift.client.IEnvironmentVariable;
import com.openshift.client.IGear;
import com.openshift.client.IGearGroup;
import com.openshift.client.IGearProfile;
import com.openshift.client.OpenShiftException;
import com.openshift.client.cartridge.ICartridge;
import com.openshift.client.cartridge.IDeployedStandaloneCartridge;
import com.openshift.client.cartridge.IEmbeddableCartridge;
import com.openshift.client.cartridge.IEmbeddedCartridge;
import com.openshift.client.cartridge.query.LatestEmbeddableCartridge;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.openshift.OpenShiftEndpoint;
import org.apache.camel.component.openshift.OpenShiftHelper;
import org.apache.camel.component.openshift.OpenShiftOperation;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;

public class OpenShiftProducer
extends DefaultProducer {
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

    public OpenShiftProducer(Endpoint endpoint) {
        super(endpoint);
    }

    public OpenShiftEndpoint getEndpoint() {
        return (OpenShiftEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        String openshiftServer = OpenShiftHelper.getOpenShiftServer(this.getEndpoint());
        IDomain domain = OpenShiftHelper.loginAndGetDomain(this.getEndpoint(), openshiftServer);
        if (domain == null) {
            throw new CamelExchangeException("User has no domain with id " + this.getEndpoint().getDomain(), exchange);
        }
        OpenShiftOperation operation = (OpenShiftOperation)((Object)exchange.getIn().getHeader("CamelOpenShiftOperation", (Object)this.getEndpoint().getOperation(), OpenShiftOperation.class));
        switch (operation) {
            case start: {
                this.doStart(exchange, domain);
                break;
            }
            case stop: {
                this.doStop(exchange, domain);
                break;
            }
            case restart: {
                this.doRestart(exchange, domain);
                break;
            }
            case state: {
                this.doState(exchange, domain);
                break;
            }
            case getStandaloneCartridge: {
                this.doGetStandaloneCartridge(exchange, domain);
                break;
            }
            case getEmbeddedCartridges: {
                this.doGetEmbeddedCartridges(exchange, domain);
                break;
            }
            case getGitUrl: {
                this.doGetGitUrl(exchange, domain);
                break;
            }
            case addEmbeddedCartridge: {
                this.doAddEmbeddedCartridge(exchange, domain);
                break;
            }
            case removeEmbeddedCartridge: {
                this.doRemoveEmbeddedCartridge(exchange, domain);
                break;
            }
            case scaleUp: {
                this.doScaleUp(exchange, domain);
                break;
            }
            case scaleDown: {
                this.doScaleDown(exchange, domain);
                break;
            }
            case getDeploymentType: {
                this.doGetDeploymentType(exchange, domain);
                break;
            }
            case setDeploymentType: {
                this.doSetDeploymentType(exchange, domain);
                break;
            }
            case addEnvironmentVariable: {
                this.doAddEnvironmentVariable(exchange, domain);
                break;
            }
            case addMultipleEnvironmentVariables: {
                this.doAddMultipleEnvironmentVariables(exchange, domain);
                break;
            }
            case updateEnvironmentVariable: {
                this.doUpdateEnvironmentVariable(exchange, domain);
                break;
            }
            case getAllEnvironmentVariables: {
                this.doGetAllEnvironmentVariables(exchange, domain);
                break;
            }
            case getEnvironmentVariableValue: {
                this.doGetEnvironmentVariableValue(exchange, domain);
                break;
            }
            case removeEnvironmentVariable: {
                this.doRemoveEnvironmentVariable(exchange, domain);
                break;
            }
            case getGearProfile: {
                this.doGetGearProfile(exchange, domain);
                break;
            }
            case addAlias: {
                this.doAddAlias(exchange, domain);
                break;
            }
            case removeAlias: {
                this.doRemoveAlias(exchange, domain);
                break;
            }
            case getAliases: {
                this.doGetAliases(exchange, domain);
                break;
            }
            default: {
                if (this.getEndpoint().getMode().equals("json")) {
                    this.doListJson(exchange, domain);
                    break;
                }
                this.doListPojo(exchange, domain);
            }
        }
    }

    protected void doListJson(Exchange exchange, IDomain domain) {
        StringBuilder sb = new StringBuilder("{\n  \"applications\": [");
        boolean first = true;
        for (IApplication application : domain.getApplications()) {
            if (!first) {
                sb.append("\n    ],");
            } else {
                first = false;
            }
            String date = new SimpleDateFormat(TIMESTAMP_FORMAT).format(application.getCreationTime());
            sb.append("\n    {");
            sb.append("\n      \"uuid\": \"" + application.getUUID() + "\",");
            sb.append("\n      \"domain\": \"" + application.getDomain().getId() + "\",");
            sb.append("\n      \"name\": \"" + application.getName() + "\",");
            sb.append("\n      \"creationTime\": \"" + date + "\",");
            sb.append("\n      \"applicationUrl\": \"" + application.getApplicationUrl() + "\",");
            sb.append("\n      \"gitUrl\": \"" + application.getGitUrl() + "\",");
            sb.append("\n      \"sshUrl\": \"" + application.getSshUrl() + "\",");
            sb.append("\n      \"catridge\": {");
            sb.append("\n        \"name\": \"" + application.getCartridge().getName() + "\",");
            sb.append("\n        \"displayName\": \"" + application.getCartridge().getDisplayName() + "\",");
            sb.append("\n        \"description\": \"" + application.getCartridge().getDescription() + "\"");
            sb.append("\n      },");
            List embeddedCartridges = application.getEmbeddedCartridges();
            if (embeddedCartridges != null && !embeddedCartridges.isEmpty()) {
                sb.append("\n      \"embeddedCatridges\": [");
                Iterator it = embeddedCartridges.iterator();
                while (it.hasNext()) {
                    IEmbeddedCartridge cartridge = (IEmbeddedCartridge)it.next();
                    sb.append("\n      \"catridge\": {");
                    sb.append("\n        \"name\": \"" + cartridge.getName() + "\",");
                    sb.append("\n        \"displayName\": \"" + cartridge.getDisplayName() + "\",");
                    sb.append("\n        \"description\": \"" + cartridge.getDescription() + "\"");
                    sb.append("\n      }");
                    if (!it.hasNext()) continue;
                    sb.append(",");
                }
                sb.append("\n      ]");
            }
            sb.append("\n      \"gearProfile\": \"" + application.getGearProfile().getName() + "\",");
            sb.append("\n      \"gears\": [");
            boolean firstGear = true;
            for (IGearGroup group : application.getGearGroups()) {
                for (IGear gear : group.getGears()) {
                    if (!firstGear) {
                        sb.append(",");
                    } else {
                        firstGear = false;
                    }
                    sb.append("\n        {");
                    sb.append("\n         \"id\": \"" + gear.getId() + "\",");
                    sb.append("\n         \"sshUrl\": \"" + gear.getSshUrl() + "\",");
                    sb.append("\n         \"state\": \"" + gear.getState().getState().toLowerCase(Locale.ENGLISH) + "\"");
                    sb.append("\n        }");
                }
            }
            sb.append("\n      ]");
            sb.append("\n    }");
        }
        sb.append("\n  ]");
        sb.append("\n}");
        exchange.getIn().setBody((Object)sb.toString());
    }

    protected void doListPojo(Exchange exchange, IDomain domain) {
        exchange.getIn().setBody((Object)domain.getApplications());
    }

    protected void doStart(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        app.start();
    }

    protected void doStop(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        app.stop();
    }

    protected void doRestart(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        app.restart();
    }

    protected void doState(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        String state = OpenShiftHelper.getStateForApplication(app);
        exchange.getIn().setBody((Object)state);
    }

    protected void doGetStandaloneCartridge(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        IDeployedStandaloneCartridge p = app.getCartridge();
        exchange.getIn().setBody((Object)p.getDisplayName());
    }

    protected void doGetEmbeddedCartridges(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        List p = app.getEmbeddedCartridges();
        exchange.getIn().setBody((Object)p);
    }

    protected void doAddEmbeddedCartridge(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        String embeddedCartridgeName = (String)exchange.getIn().getHeader("CamelOpenShiftEmbeddedCartridgeName", (Object)this.getEndpoint().getApplication(), String.class);
        if (!ObjectHelper.isNotEmpty((Object)embeddedCartridgeName)) {
            throw new CamelExchangeException("Cartridge not specified", exchange);
        }
        IEmbeddedCartridge p = app.addEmbeddableCartridge((ICartridge)new LatestEmbeddableCartridge(embeddedCartridgeName).get(app));
        exchange.getIn().setBody((Object)p.getDisplayName());
    }

    protected void doRemoveEmbeddedCartridge(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        String embeddedCartridgeName = (String)exchange.getIn().getHeader("CamelOpenShiftEmbeddedCartridgeName", (Object)this.getEndpoint().getApplication(), String.class);
        if (ObjectHelper.isNotEmpty((Object)embeddedCartridgeName)) {
            IEmbeddableCartridge removingCartridge = new LatestEmbeddableCartridge(embeddedCartridgeName).get(app);
            for (IEmbeddedCartridge cartridge : app.getEmbeddedCartridges()) {
                if (!cartridge.equals(removingCartridge)) continue;
                cartridge.destroy();
                exchange.getIn().setBody((Object)cartridge.getDisplayName());
            }
        } else {
            throw new CamelExchangeException("Cartridge not specified", exchange);
        }
    }

    protected void doScaleUp(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        try {
            app.scaleUp();
            ApplicationScale result = app.getApplicationScale();
            exchange.getIn().setBody((Object)result.getValue());
        }
        catch (OpenShiftException e) {
            throw new CamelExchangeException("Application with id " + name + " is not scalable", exchange);
        }
    }

    protected void doScaleDown(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        ApplicationScale scale = app.getApplicationScale();
        if (scale.getValue().equals(ApplicationScale.NO_SCALE.getValue())) {
            this.log.info("Scaling on application with id {} is not enabled", (Object)name);
        } else {
            app.scaleDown();
            ApplicationScale result = app.getApplicationScale();
            exchange.getIn().setBody((Object)result.getValue());
        }
    }

    protected void doGetGitUrl(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        String gitUrl = app.getGitUrl();
        exchange.getIn().setBody((Object)gitUrl);
    }

    protected void doGetDeploymentType(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        String deploymentType = app.getDeploymentType();
        exchange.getIn().setBody((Object)deploymentType);
    }

    protected void doSetDeploymentType(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        String deploymentType = (String)exchange.getIn().getHeader("CamelOpenShiftDeploymentType", (Object)this.getEndpoint().getApplication(), String.class);
        if (!ObjectHelper.isNotEmpty((Object)deploymentType)) {
            throw new CamelExchangeException("Deployment Type not specified", exchange);
        }
        String result = app.setDeploymentType(deploymentType);
        exchange.getIn().setBody((Object)result);
    }

    protected void doAddEnvironmentVariable(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        String variableName = (String)exchange.getIn().getHeader("CamelOpenShiftEnvironmentVariableName", (Object)this.getEndpoint().getApplication(), String.class);
        String variableValue = (String)exchange.getIn().getHeader("CamelOpenShiftEnvironmentVariableValue", (Object)this.getEndpoint().getApplication(), String.class);
        if (!app.canUpdateEnvironmentVariables()) {
            throw new CamelExchangeException("The application with id " + name + " can't update Environment Variables", exchange);
        }
        if (!ObjectHelper.isNotEmpty((Object)variableName) || !ObjectHelper.isNotEmpty((Object)variableValue)) {
            throw new CamelExchangeException("Environment variable not correctly specified", exchange);
        }
        IEnvironmentVariable result = app.addEnvironmentVariable(variableName, variableValue);
        exchange.getIn().setBody((Object)result.getName());
    }

    protected void doAddMultipleEnvironmentVariables(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        Map environmentVariables = (Map)exchange.getIn().getHeader("CamelOpenShiftEnvironmentVariableMap", (Object)this.getEndpoint().getApplication(), Map.class);
        if (!app.canUpdateEnvironmentVariables()) {
            throw new CamelExchangeException("The application with id " + name + " can't update Environment Variables", exchange);
        }
        if (!ObjectHelper.isNotEmpty((Object)environmentVariables)) {
            throw new CamelExchangeException("Environment variables not correctly specified", exchange);
        }
        Map result = app.addEnvironmentVariables(environmentVariables);
        exchange.getIn().setBody((Object)result);
    }

    protected void doUpdateEnvironmentVariable(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        String variableName = (String)exchange.getIn().getHeader("CamelOpenShiftEnvironmentVariableName", (Object)this.getEndpoint().getApplication(), String.class);
        String variableValue = (String)exchange.getIn().getHeader("CamelOpenShiftEnvironmentVariableValue", (Object)this.getEndpoint().getApplication(), String.class);
        if (!app.canUpdateEnvironmentVariables()) {
            throw new CamelExchangeException("The application with id " + name + " can't update Environment Variables", exchange);
        }
        if (!ObjectHelper.isNotEmpty((Object)variableName) || !ObjectHelper.isNotEmpty((Object)variableValue)) {
            throw new CamelExchangeException("Environment variable not correctly specified", exchange);
        }
        IEnvironmentVariable result = app.updateEnvironmentVariable(variableName, variableValue);
        exchange.getIn().setBody((Object)result.getName());
    }

    protected void doGetEnvironmentVariableValue(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        String variableName = (String)exchange.getIn().getHeader("CamelOpenShiftEnvironmentVariableName", (Object)this.getEndpoint().getApplication(), String.class);
        if (!app.canGetEnvironmentVariables()) {
            throw new CamelExchangeException("The application with id " + name + " can't get Environment Variables", exchange);
        }
        if (!ObjectHelper.isNotEmpty((Object)variableName)) {
            throw new CamelExchangeException("Environment variable name not specified", exchange);
        }
        IEnvironmentVariable result = app.getEnvironmentVariable(variableName);
        exchange.getIn().setBody((Object)result.getValue());
    }

    protected void doGetAllEnvironmentVariables(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        Map result = app.getEnvironmentVariables();
        exchange.getIn().setBody((Object)result);
    }

    protected void doRemoveEnvironmentVariable(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        String variableName = (String)exchange.getIn().getHeader("CamelOpenShiftEnvironmentVariableName", (Object)this.getEndpoint().getApplication(), String.class);
        if (!app.canGetEnvironmentVariables()) {
            throw new CamelExchangeException("The application with id " + name + " can't get Environment Variables", exchange);
        }
        if (!ObjectHelper.isNotEmpty((Object)variableName)) {
            throw new CamelExchangeException("Environment variable name not specified", exchange);
        }
        app.removeEnvironmentVariable(variableName);
        exchange.getIn().setBody((Object)variableName);
    }

    protected void doGetGearProfile(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        IGearProfile result = app.getGearProfile();
        exchange.getIn().setBody((Object)result.getName());
    }

    protected void doAddAlias(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        String alias = (String)exchange.getIn().getHeader("CamelOpenShiftApplicationAlias", (Object)this.getEndpoint().getApplication(), String.class);
        if (!app.canGetEnvironmentVariables()) {
            throw new CamelExchangeException("The application with id " + name + " can't get Environment Variables", exchange);
        }
        if (!ObjectHelper.isNotEmpty((Object)alias)) {
            throw new CamelExchangeException("Application Alias name not specified", exchange);
        }
        app.addAlias(alias);
        exchange.getIn().setBody((Object)alias);
    }

    protected void doRemoveAlias(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        String alias = (String)exchange.getIn().getHeader("CamelOpenShiftApplicationAlias", (Object)this.getEndpoint().getApplication(), String.class);
        if (!app.canGetEnvironmentVariables()) {
            throw new CamelExchangeException("The application with id " + name + " can't get Environment Variables", exchange);
        }
        if (!ObjectHelper.isNotEmpty((Object)alias)) {
            throw new CamelExchangeException("Application Alias not specified", exchange);
        }
        app.removeAlias(alias);
        exchange.getIn().setBody((Object)alias);
    }

    protected void doGetAliases(Exchange exchange, IDomain domain) throws CamelExchangeException {
        String name = (String)exchange.getIn().getHeader("CamelOpenShiftApplication", (Object)this.getEndpoint().getApplication(), String.class);
        if (name == null) {
            throw new CamelExchangeException("Application not specified", exchange);
        }
        IApplication app = domain.getApplicationByName(name);
        if (app == null) {
            throw new CamelExchangeException("Application with id " + name + " not found.", exchange);
        }
        List aliases = app.getAliases();
        exchange.getIn().setBody((Object)aliases);
    }
}

