/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.keystone;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Producer;
import org.apache.camel.component.openstack.common.AbstractOpenstackEndpoint;
import org.apache.camel.component.openstack.keystone.KeystoneComponent;
import org.apache.camel.component.openstack.keystone.KeystoneConstants;
import org.apache.camel.component.openstack.keystone.producer.DomainProducer;
import org.apache.camel.component.openstack.keystone.producer.GroupProducer;
import org.apache.camel.component.openstack.keystone.producer.ProjectProducer;
import org.apache.camel.component.openstack.keystone.producer.RegionProducer;
import org.apache.camel.component.openstack.keystone.producer.UserProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.openstack4j.core.transport.Config;

@UriEndpoint(firstVersion="2.19.0", scheme="openstack-keystone", title="OpenStack Keystone", syntax="openstack-keystone:host", category={Category.CLOUD, Category.PAAS}, producerOnly=true, headersClass=KeystoneConstants.class)
public class KeystoneEndpoint
extends AbstractOpenstackEndpoint {
    @UriParam(enums="regions,domains,projects,users,groups")
    @Metadata(required=true)
    String subsystem;
    @UriPath
    @Metadata(required=true)
    private String host;
    @UriParam(defaultValue="default")
    private String domain = "default";
    @UriParam
    @Metadata(required=true)
    private String project;
    @UriParam
    private String operation;
    @UriParam
    @Metadata(required=true, secret=true)
    private String username;
    @UriParam
    @Metadata(required=true, secret=true)
    private String password;
    @UriParam
    private Config config;

    public KeystoneEndpoint(String uri, KeystoneComponent component) {
        super(uri, (Component)component);
    }

    public Producer createProducer() throws Exception {
        switch (this.getSubsystem()) {
            case "regions": {
                return new RegionProducer(this, this.createClient());
            }
            case "domains": {
                return new DomainProducer(this, this.createClient());
            }
            case "projects": {
                return new ProjectProducer(this, this.createClient());
            }
            case "users": {
                return new UserProducer(this, this.createClient());
            }
            case "groups": {
                return new GroupProducer(this, this.createClient());
            }
        }
        throw new IllegalArgumentException("Can't create producer with subsystem " + this.subsystem);
    }

    public String getSubsystem() {
        return this.subsystem;
    }

    public void setSubsystem(String subsystem) {
        this.subsystem = subsystem;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    @Override
    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    @Override
    public String getApiVersion() {
        return "V3";
    }
}

