/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentracing;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.tracerresolver.TracerResolver;
import io.opentracing.noop.NoopTracerFactory;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.opentracing.OpenTracingExtractAdapter;
import org.apache.camel.opentracing.OpenTracingInjectAdapter;
import org.apache.camel.opentracing.OpenTracingSpanAdapter;
import org.apache.camel.tracing.InjectAdapter;
import org.apache.camel.tracing.SpanAdapter;
import org.apache.camel.tracing.SpanDecorator;
import org.apache.camel.tracing.SpanKind;
import org.apache.camel.tracing.decorators.AbstractInternalSpanDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="OpenTracingTracer")
@Deprecated
public class OpenTracingTracer
extends org.apache.camel.tracing.Tracer {
    private static final Logger LOG = LoggerFactory.getLogger(OpenTracingTracer.class);
    Tracer tracer;

    private String mapToSpanKind(SpanKind kind) {
        switch (kind) {
            case SPAN_KIND_CLIENT: {
                return "client";
            }
            case SPAN_KIND_SERVER: {
                return "server";
            }
            case CONSUMER: {
                return "consumer";
            }
            case PRODUCER: {
                return "producer";
            }
        }
        return null;
    }

    protected void initTracer() {
        Set tracers;
        if (this.tracer == null && (tracers = this.getCamelContext().getRegistry().findByType(Tracer.class)).size() == 1) {
            this.tracer = (Tracer)tracers.iterator().next();
        }
        if (this.tracer == null) {
            this.tracer = TracerResolver.resolveTracer();
        }
        if (this.tracer == null) {
            this.tracer = NoopTracerFactory.create();
        }
        if (this.tracer != null) {
            try {
                GlobalTracer.registerIfAbsent((Tracer)this.tracer);
            }
            catch (NoClassDefFoundError globalTracerNotInClasspath) {
                LOG.trace("GlobalTracer is not found on the classpath.");
            }
        }
    }

    protected SpanAdapter startSendingEventSpan(String operationName, SpanKind kind, SpanAdapter parent, Exchange exchange, InjectAdapter injectAdapter) {
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(operationName).withTag(Tags.SPAN_KIND.getKey(), this.mapToSpanKind(kind));
        if (parent != null) {
            Span parentSpan = ((OpenTracingSpanAdapter)parent).getOpenTracingSpan();
            spanBuilder.asChildOf(parentSpan);
        }
        return new OpenTracingSpanAdapter(spanBuilder.start());
    }

    protected SpanAdapter startExchangeBeginSpan(Exchange exchange, SpanDecorator sd, String operationName, SpanKind kind, SpanAdapter parent) {
        Tracer.SpanBuilder builder = this.tracer.buildSpan(operationName);
        if (parent != null) {
            Span parentFromExchange = ((OpenTracingSpanAdapter)parent).getOpenTracingSpan();
            builder.asChildOf(parentFromExchange);
        } else {
            SpanContext parentFromHeaders = this.tracer.extract(Format.Builtin.TEXT_MAP, (Object)new OpenTracingExtractAdapter(sd.getExtractAdapter(exchange.getIn().getHeaders(), this.encoding)));
            if (parentFromHeaders != null) {
                builder.asChildOf(parentFromHeaders).withTag(Tags.SPAN_KIND.getKey(), this.mapToSpanKind(sd.getReceiverSpanKind()));
            } else if (!(sd instanceof AbstractInternalSpanDecorator)) {
                builder.withTag(Tags.SPAN_KIND.getKey(), this.mapToSpanKind(sd.getReceiverSpanKind()));
            }
        }
        return new OpenTracingSpanAdapter(builder.start());
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    protected void finishSpan(SpanAdapter span) {
        OpenTracingSpanAdapter openTracingSpanWrapper = (OpenTracingSpanAdapter)span;
        openTracingSpanWrapper.getOpenTracingSpan().finish();
    }

    protected void inject(SpanAdapter span, InjectAdapter adapter) {
        OpenTracingSpanAdapter openTracingSpanWrapper = (OpenTracingSpanAdapter)span;
        this.tracer.inject(openTracingSpanWrapper.getOpenTracingSpan().context(), Format.Builtin.TEXT_MAP, (Object)new OpenTracingInjectAdapter(adapter));
    }
}

