/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.optaplanner;

import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.optaplanner.OptaPlannerConfiguration;
import org.apache.camel.component.optaplanner.OptaPlannerEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.domain.solution.Solution;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptaPlannerProducer
extends DefaultProducer {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(OptaPlannerProducer.class);
    private ExecutorService executor;
    private final OptaPlannerEndpoint endpoint;
    private final OptaPlannerConfiguration configuration;

    public OptaPlannerProducer(OptaPlannerEndpoint endpoint, OptaPlannerConfiguration configuration) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.configuration = configuration;
    }

    protected void doStart() throws Exception {
        if (this.configuration.isAsync()) {
            this.executor = this.endpoint.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, this.endpoint.getEndpointUri(), this.configuration.getThreadPoolSize());
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.executor != null) {
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdown(this.executor);
            this.executor = null;
        }
        super.doStop();
    }

    public synchronized void process(Exchange exchange) throws Exception {
        final Object body = exchange.getIn().getMandatoryBody();
        final String solverId = this.getSolverId(exchange);
        if (body.getClass().isAnnotationPresent(PlanningSolution.class) || body instanceof Solution) {
            if (this.isAsync(exchange)) {
                LOGGER.debug("Asynchronously solving problem: [{}] with id [{}]", body, (Object)solverId);
                final Solver<Object> solver = this.endpoint.getOrCreateSolver(solverId);
                this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            solver.solve(body);
                        }
                        catch (Throwable e) {
                            LOGGER.error("Asynchronously solving failed for solverId ({})", (Object)solverId, (Object)e);
                        }
                    }
                });
            } else {
                LOGGER.debug("Synchronously solving problem: [{}] with id [{}]", body, (Object)solverId);
                Solver<Object> solver = this.endpoint.getSolver(solverId);
                if (solver == null) {
                    solver = this.endpoint.createSolver();
                }
                solver.solve(body);
                this.populateResult(exchange, solver);
            }
        } else if (body instanceof ProblemFactChange) {
            LOGGER.debug("Adding ProblemFactChange to solver: [{}] with id [{}]", body, (Object)solverId);
            Solver<Object> solver = this.endpoint.getOrCreateSolver(solverId);
            solver.addProblemFactChange((ProblemFactChange)body);
            if (!this.isAsync(exchange)) {
                while (!solver.isEveryProblemFactChangeProcessed()) {
                    Thread.sleep(100L);
                }
            }
            this.populateResult(exchange, solver);
        } else {
            LOGGER.debug("Retrieving best score for solver: [{}]", (Object)solverId);
            Solver<Object> solver = this.endpoint.getSolver(solverId);
            if (solver == null) {
                throw new RuntimeException("Solver not found: " + solverId);
            }
            this.populateResult(exchange, solver);
        }
    }

    private void populateResult(Exchange exchange, Solver<Object> solver) {
        exchange.getIn().setBody(solver.getBestSolution());
        exchange.getIn().setHeader("CamelOptaPlannerTimeSpent", (Object)solver.getTimeMillisSpent());
        exchange.getIn().setHeader("CamelOptaPlannerIsEveryProblemFactChangeProcessed", (Object)solver.isEveryProblemFactChangeProcessed());
        exchange.getIn().setHeader("CamelOptaPlannerIsTerminateEarly", (Object)solver.isTerminateEarly());
        exchange.getIn().setHeader("CamelOptaPlannerIsSolving", (Object)solver.isSolving());
    }

    private String getSolverId(Exchange exchange) throws Exception {
        String solverId = (String)exchange.getIn().getHeader("CamelOptaPlannerSolverId", String.class);
        if (solverId == null) {
            solverId = this.configuration.getSolverId();
        }
        LOGGER.debug("SolverId: [{}]", (Object)solverId);
        return solverId;
    }

    private boolean isAsync(Exchange exchange) {
        Boolean isAsync = (Boolean)exchange.getIn().getHeader("CamelOptaPlannerIsAsync", Boolean.class);
        return isAsync != null ? isAsync.booleanValue() : this.configuration.isAsync();
    }
}

