/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.optaplanner;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.optaplanner.OptaPlannerConfiguration;
import org.apache.camel.component.optaplanner.OptaPlannerEndpoint;
import org.apache.camel.component.optaplanner.OptaplannerEventSupport;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.task.ForegroundTask;
import org.apache.camel.support.task.Tasks;
import org.apache.camel.support.task.budget.Budgets;
import org.apache.camel.support.task.budget.IterationBudget;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.api.solver.ProblemFactChange;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverJob;
import org.optaplanner.core.api.solver.SolverManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptaPlannerProducer
extends DefaultAsyncProducer {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(OptaPlannerProducer.class);
    private ExecutorService executor;
    private final OptaPlannerEndpoint endpoint;
    private final OptaPlannerConfiguration configuration;

    public OptaPlannerProducer(OptaPlannerEndpoint endpoint, OptaPlannerConfiguration configuration) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.configuration = configuration;
    }

    protected void doStart() throws Exception {
        if (this.configuration.isAsync()) {
            this.executor = this.endpoint.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, this.endpoint.getEndpointUri(), this.configuration.getThreadPoolSize());
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.executor != null) {
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdown(this.executor);
            this.executor = null;
        }
        super.doStop();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            Object body = exchange.getIn().getMandatoryBody();
            if (this.endpoint.getConfiguration().isUseSolverManager()) {
                return this.processWithSolverManager(exchange, body, callback);
            }
            this.processWithXmlFile(exchange, body);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    private void processWithXmlFile(Exchange exchange, Object body) {
        String solverId = this.getSolverId(exchange);
        if (body.getClass().isAnnotationPresent(PlanningSolution.class)) {
            if (this.isAsync(exchange)) {
                this.solveProblemAsync(exchange, body, solverId);
            } else {
                this.solveProblemSync(exchange, body, solverId);
            }
        } else if (body instanceof ProblemFactChange) {
            LOGGER.debug("Adding ProblemFactChange to solver: [{}] with id [{}]", body, (Object)solverId);
            Solver<Object> solver = this.endpoint.getOrCreateSolver(solverId);
            solver.addProblemFactChange((ProblemFactChange)body);
            if (!this.isAsync(exchange)) {
                ForegroundTask task = Tasks.foregroundTask().withBudget((IterationBudget)Budgets.iterationBudget().withMaxIterations(-1).withInterval(Duration.ofMillis(100L)).build()).build();
                task.run(() -> solver.isEveryProblemFactChangeProcessed());
            }
            this.populateResult(exchange, solver, null);
        } else {
            exchange.setException((Throwable)new Exception("Unsupported type. Body must be of Type PlanningSolution or ProblemFactChange. To get the Best Result from the async Solver, use the camel optaplanner consumer"));
        }
    }

    private void solveProblemSync(Exchange exchange, Object body, String solverId) {
        LOGGER.debug("Synchronously solving problem: [{}] with id [{}]", body, (Object)solverId);
        Solver<Object> solver = this.endpoint.getSolver(solverId);
        if (solver == null) {
            solver = this.endpoint.createSolver();
        }
        Object solution = solver.solve(body);
        this.populateResult(exchange, solver, solution);
    }

    private void solveProblemAsync(Exchange exchange, Object body, String solverId) {
        LOGGER.debug("Asynchronously solving problem: [{}] with id [{}]", body, (Object)solverId);
        Solver<Object> solver = this.endpoint.getOrCreateSolver(solverId);
        this.executor.submit(() -> {
            try {
                solver.solve(body);
            }
            catch (Exception e) {
                exchange.setException((Throwable)new Exception("Asynchronously solving failed for solverId " + solverId, e));
            }
        });
    }

    private boolean processWithSolverManager(Exchange exchange, Object body, AsyncCallback callback) throws Exception {
        SolverManager solverManager = this.getSolverManager(exchange);
        if (body.getClass().isAnnotationPresent(PlanningSolution.class)) {
            Long problemId = this.endpoint.getConfiguration().getProblemId();
            LOGGER.debug("Asynchronously solving problem: [{}] with id [{}]", body, (Object)problemId);
            if (this.isAsync(exchange)) {
                this.executor.submit(() -> {
                    try {
                        OptaplannerEventSupport eventSupport = new OptaplannerEventSupport(this.endpoint, problemId);
                        SolverJob solverJob = solverManager.solveAndListen((Object)problemId, t -> body, eventSupport::updateBestSolution);
                        this.populateResultWithSolverManager(exchange, solverJob);
                    }
                    catch (Exception e) {
                        exchange.setException((Throwable)e);
                    }
                    finally {
                        callback.done(false);
                    }
                });
                return false;
            }
            SolverJob solverJob = solverManager.solve((Object)problemId, body);
            this.populateResultWithSolverManager(exchange, solverJob);
        } else {
            exchange.setException((Throwable)new Exception("Unsupported type. Body must be of Type PlanningSolution"));
        }
        callback.done(true);
        return true;
    }

    private void populateResultWithSolverManager(Exchange exchange, SolverJob solverJob) throws InterruptedException, ExecutionException {
        exchange.getIn().setBody(solverJob.getFinalBestSolution());
        exchange.getIn().setHeader("CamelOptaPlannerIsSolving", (Object)false);
    }

    private void populateResult(Exchange exchange, Solver<Object> solver, Object solution) {
        exchange.getIn().setBody(solution);
        exchange.getIn().setHeader("CamelOptaPlannerIsEveryProblemFactChangeProcessed", (Object)solver.isEveryProblemFactChangeProcessed());
        exchange.getIn().setHeader("CamelOptaPlannerIsTerminateEarly", (Object)solver.isTerminateEarly());
        exchange.getIn().setHeader("CamelOptaPlannerIsSolving", (Object)solver.isSolving());
    }

    private String getSolverId(Exchange exchange) {
        String solverId = (String)exchange.getIn().getHeader("CamelOptaPlannerSolverId", String.class);
        if (solverId == null) {
            solverId = this.configuration.getSolverId();
        }
        LOGGER.debug("SolverId: [{}]", (Object)solverId);
        return solverId;
    }

    private boolean isAsync(Exchange exchange) {
        Boolean isAsync = (Boolean)exchange.getIn().getHeader("CamelOptaPlannerIsAsync", Boolean.class);
        return isAsync != null ? isAsync.booleanValue() : this.configuration.isAsync();
    }

    private SolverManager getSolverManager(Exchange exchange) {
        return (SolverManager)exchange.getIn().getHeader("CamelOptaPlannerSolverManager", SolverManager.class);
    }
}

