/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="prepare-assembly", threadSafe=true)
public class PrepareAssemblyMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/../../../apache-camel/pom.xml")
    protected File releasePom;
    @Parameter(defaultValue="${project.build.directory}/../../../apache-camel/src/main/descriptors/common-bin.xml")
    protected File commonBinXml;
    @Parameter(defaultValue="${project.build.directory}/../../../catalog/camel-allcomponents/pom.xml")
    protected File allComponentsPomFile;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.updatePomAndCommonBin(this.allComponentsPomFile, "org.apache.camel", "camel components");
    }

    protected void updatePomAndCommonBin(File allComponentsPom, String groupId, String token) throws MojoExecutionException {
        String pomText;
        TreeSet<String> artifactIds = new TreeSet<String>();
        try {
            pomText = PackageHelper.loadText((File)allComponentsPom);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error loading camel-allcomponents pom.xml file", (Exception)e);
        }
        String before = Strings.before((String)pomText, (String)"<dependencies>");
        String after = Strings.after((String)pomText, (String)"</dependencies>");
        String between = pomText.substring(before.length(), pomText.length() - after.length());
        Pattern pattern = Pattern.compile("<dependency>\\s*<groupId>(?<groupId>.*)</groupId>\\s*<artifactId>(?<artifactId>.*)</artifactId>\\s*</dependency>");
        Matcher matcher = pattern.matcher(between);
        while (matcher.find()) {
            artifactIds.add(matcher.group(2));
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("ArtifactIds: " + artifactIds));
        }
        StringBuilder sb = new StringBuilder();
        for (String aid : artifactIds) {
            sb.append("    <dependency>\n");
            sb.append("      <groupId>").append(groupId).append("</groupId>\n");
            sb.append("      <artifactId>").append(aid).append("</artifactId>\n");
            sb.append("      <version>${project.version}</version>\n");
            sb.append("    </dependency>\n");
        }
        String changed = sb.toString();
        boolean updated = this.updateXmlFile(this.releasePom, token, changed, "    ");
        if (updated) {
            this.getLog().info((CharSequence)"Updated apache-camel/pom.xml file");
        } else {
            this.getLog().debug((CharSequence)"No changes to apache-camel/pom.xml file");
        }
        this.getLog().info((CharSequence)("apache-camel/pom.xml contains " + artifactIds.size() + " " + token + " dependencies"));
        sb = new StringBuilder();
        for (String aid : artifactIds) {
            sb.append("        <include>").append(groupId).append(":").append(aid).append("</include>\n");
        }
        changed = sb.toString();
        updated = this.updateXmlFile(this.commonBinXml, token, changed, "        ");
        if (updated) {
            this.getLog().info((CharSequence)"Updated apache-camel/src/main/descriptors/common-bin.xml file");
        } else {
            this.getLog().debug((CharSequence)"No changes to apache-camel/src/main/descriptors/common-bin.xml file");
        }
        this.getLog().info((CharSequence)("apache-camel/src/main/descriptors/common-bin.xml contains " + artifactIds.size() + " " + token + " dependencies"));
    }

    private boolean updateXmlFile(File file, String token, String changed, String spaces) throws MojoExecutionException {
        String start = "<!-- " + token + ": START -->";
        String end = "<!-- " + token + ": END -->";
        if (!file.exists()) {
            return false;
        }
        try {
            Object text = PackageHelper.loadText((File)file);
            String existing = Strings.between((String)text, (String)start, (String)end);
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = Strings.before((String)text, (String)start);
                String after = Strings.after((String)text, (String)end);
                text = before + start + "\n" + spaces + changed + "\n" + spaces + end + after;
                PackageHelper.writeText((File)file, (String)text);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }
}

