/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.SupportLevelHelper;
import org.apache.camel.maven.packaging.generics.ClassUtil;
import org.apache.camel.spi.Metadata;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.camel.tooling.model.DataFormatModel;
import org.apache.camel.tooling.model.EipModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.model.SupportLevel;
import org.apache.camel.tooling.util.JavadocHelper;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="generate-dataformats-list", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class PackageDataFormatMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File dataFormatOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/java")
    protected File configurerSourceOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File configurerResourceOutDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File schemaOutDir;
    protected ClassLoader projectClassLoader;
    private final Map<String, Optional<JavaClassSource>> sources = new HashMap<String, Optional<JavaClassSource>>();

    public PackageDataFormatMojo() {
    }

    public PackageDataFormatMojo(Log log, MavenProject project, MavenProjectHelper projectHelper, File dataFormatOutDir, File configurerSourceOutDir, File configurerResourceOutDir, File schemaOutDir, BuildContext buildContext) {
        this.setLog(log);
        this.project = project;
        this.projectHelper = projectHelper;
        this.dataFormatOutDir = dataFormatOutDir;
        this.configurerSourceOutDir = configurerSourceOutDir;
        this.configurerResourceOutDir = configurerResourceOutDir;
        this.schemaOutDir = schemaOutDir;
        this.buildContext = buildContext;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.prepareDataFormat();
    }

    public int prepareDataFormat() throws MojoExecutionException {
        int count;
        StringBuilder buffer;
        File camelMetaDir;
        Log log;
        block17: {
            String javaType;
            File[] files;
            log = this.getLog();
            camelMetaDir = new File(this.dataFormatOutDir, "META-INF/services/org/apache/camel/");
            if (this.projectHelper != null) {
                this.projectHelper.addResource(this.project, this.dataFormatOutDir.getPath(), Collections.singletonList("**/dataformat.properties"), Collections.emptyList());
            }
            if (!PackageDataFormatMojo.haveResourcesChanged(log, this.project, this.buildContext, "META-INF/services/org/apache/camel/dataformat")) {
                return 0;
            }
            HashMap<String, String> javaTypes = new HashMap<String, String>();
            buffer = new StringBuilder();
            count = 0;
            File f = new File(this.project.getBasedir(), "target/classes");
            if ((f = new File(f, "META-INF/services/org/apache/camel/dataformat")).exists() && f.isDirectory() && (files = f.listFiles()) != null) {
                for (File file : files) {
                    javaType = PackageDataFormatMojo.readClassFromCamelResource(file, buffer, this.buildContext);
                    if (!file.isDirectory() && file.getName().charAt(0) != '.') {
                        ++count;
                    }
                    if (javaType == null) continue;
                    javaTypes.put(file.getName(), javaType);
                }
            }
            boolean apacheCamel = "org.apache.camel".equals(this.project.getGroupId());
            try {
                if (!apacheCamel || count <= 0) break block17;
                File core = PackageHelper.findCamelCoreModelDirectory((File)this.project.getBasedir());
                if (core != null) {
                    for (Map.Entry entry : javaTypes.entrySet()) {
                        String name = (String)entry.getKey();
                        javaType = (String)entry.getValue();
                        String modelName = PackageDataFormatMojo.asModelName(name);
                        String json = PackageHelper.loadText((File)new File(core, "target/classes/org/apache/camel/model/dataformat/" + modelName + ".json"));
                        Class<?> clazz = this.loadClass(javaType);
                        Metadata metadata = clazz.getAnnotation(Metadata.class);
                        String included = "";
                        String excluded = "";
                        if (metadata != null) {
                            included = metadata.includeProperties();
                            excluded = metadata.excludeProperties();
                        }
                        DataFormatModel dataFormatModel = PackageDataFormatMojo.extractDataFormatModel(this.project, json, name, clazz, included, excluded);
                        if (!modelName.equals(name)) {
                            this.setDescriptionFromClass(clazz, dataFormatModel);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((CharSequence)("Model: " + dataFormatModel));
                        }
                        String schema = JsonMapper.createParameterJsonSchema((DataFormatModel)dataFormatModel);
                        if (log.isDebugEnabled()) {
                            log.debug((CharSequence)("JSON schema:\n" + schema));
                        }
                        Path out = this.schemaOutDir.toPath().resolve(PackageDataFormatMojo.schemaSubDirectory(dataFormatModel.getJavaType())).resolve(name + ".json");
                        this.updateResource(this.schemaOutDir.toPath(), PackageDataFormatMojo.schemaSubDirectory(dataFormatModel.getJavaType()) + "/" + name + ".json", schema);
                        if (log.isDebugEnabled()) {
                            log.debug((CharSequence)("Generated " + out + " containing JSON schema for " + name + " data format"));
                        }
                        String cn = javaType.substring(javaType.lastIndexOf(46) + 1);
                        String pn = javaType.substring(0, javaType.length() - cn.length() - 1);
                        Set names = dataFormatModel.getOptions().stream().map(BaseOptionModel::getName).collect(Collectors.toSet());
                        List<DataFormatModel.DataFormatOptionModel> options = this.parseConfigurationSource(this.project, javaType);
                        options.removeIf(o -> !names.contains(o.getName()));
                        options.stream().map(BaseOptionModel::getName).collect(Collectors.toList()).forEach(names::remove);
                        names.removeAll(List.of("id"));
                        if (!names.isEmpty()) {
                            log.warn((CharSequence)("Unmapped options: " + String.join((CharSequence)",", names)));
                        }
                        this.updateResource(this.configurerSourceOutDir.toPath(), pn.replace('.', '/') + "/" + cn + "Configurer.java", PackageDataFormatMojo.generatePropertyConfigurer(pn, cn + "Configurer", cn, options));
                        this.updateResource(this.configurerResourceOutDir.toPath(), "META-INF/services/org/apache/camel/configurer/" + name + "-dataformat", PackageDataFormatMojo.generateMetaInfConfigurer(pn + "." + cn + "Configurer"));
                    }
                    break block17;
                }
                throw new MojoExecutionException("Error finding core/camel-core/target/camel-core-model-" + this.project.getVersion() + ".jar file. Make sure camel-core has been built first.");
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error loading dataformat model from camel-core. Reason: " + e, e);
            }
        }
        if (count > 0) {
            String names = Stream.of(buffer.toString().split(" ")).sorted().collect(Collectors.joining(" "));
            String properties = PackageDataFormatMojo.createProperties(this.project, "dataFormats", names);
            this.updateResource(camelMetaDir.toPath(), "dataformat.properties", properties);
            log.info((CharSequence)("Generated dataformat.properties containing " + count + " Camel " + (count > 1 ? "dataformats: " : "dataformat: ") + names));
        } else {
            log.debug((CharSequence)"No META-INF/services/org/apache/camel/dataformat directory found. Are you sure you have created a Camel data format?");
        }
        return count;
    }

    private void setDescriptionFromClass(Class<?> clazz, DataFormatModel dataFormatModel) {
        this.javaClassSource(clazz.getName()).ifPresent(src -> {
            String doc = src.getJavaDoc().getFullText();
            if (doc != null && !Strings.isNullOrEmpty((String)(doc = JavadocHelper.sanitizeDescription((String)doc, (boolean)true)))) {
                dataFormatModel.setDescription(doc);
            }
        });
    }

    private static DataFormatModel extractDataFormatModel(MavenProject project, String json, String name, Class<?> javaType, String includedProperties, String excludedProperties) {
        EipModel def = JsonMapper.generateEipModel((String)json);
        DataFormatModel model = new DataFormatModel();
        model.setName(name);
        model.setTitle(PackageDataFormatMojo.asModelTitle(name, def.getTitle()));
        model.setDescription(def.getDescription());
        model.setFirstVersion(PackageDataFormatMojo.asModelFirstVersion(name, def.getFirstVersion()));
        model.setLabel(def.getLabel());
        model.setDeprecated(def.isDeprecated());
        model.setDeprecationNote(def.getDeprecationNote());
        model.setDeprecatedSince(project.getProperties().getProperty("deprecatedSince"));
        model.setJavaType(javaType.getCanonicalName());
        model.setModelName(def.getName());
        model.setModelJavaType(def.getJavaType());
        model.setGroupId(project.getGroupId());
        model.setArtifactId(project.getArtifactId());
        model.setVersion(project.getVersion());
        String level = project.getProperties().getProperty("supportLevel");
        boolean experimental = ClassUtil.hasAnnotation("org.apache.camel.Experimental", javaType);
        if (experimental) {
            model.setSupportLevel(SupportLevel.Experimental);
        } else if (level != null) {
            model.setSupportLevel(SupportLevel.safeValueOf((String)level));
        } else {
            model.setSupportLevel(SupportLevelHelper.defaultSupportLevel(model.getFirstVersion(), model.getVersion()));
        }
        for (EipModel.EipOptionModel opt : def.getOptions()) {
            DataFormatModel.DataFormatOptionModel option = new DataFormatModel.DataFormatOptionModel();
            if (excludedProperties.contains(opt.getName()) || !includedProperties.isEmpty() && !includedProperties.contains(opt.getName())) continue;
            option.setName(opt.getName());
            option.setKind(opt.getKind());
            option.setDisplayName(opt.getDisplayName());
            option.setGroup(opt.getGroup());
            option.setLabel(opt.getLabel());
            option.setRequired(opt.isRequired());
            option.setType(opt.getType());
            option.setJavaType(opt.getJavaType());
            option.setEnums(opt.getEnums());
            option.setOneOfs(opt.getOneOfs());
            option.setPrefix(opt.getPrefix());
            option.setOptionalPrefix(opt.getOptionalPrefix());
            option.setMultiValue(opt.isMultiValue());
            option.setDeprecated(opt.isDeprecated());
            option.setDeprecationNote(opt.getDeprecationNote());
            option.setSecret(opt.isSecret());
            option.setDefaultValue(opt.getDefaultValue());
            option.setDefaultValueNote(opt.getDefaultValueNote());
            option.setAsPredicate(opt.isAsPredicate());
            option.setConfigurationClass(opt.getConfigurationClass());
            option.setConfigurationField(opt.getConfigurationField());
            option.setDescription(opt.getDescription());
            if ("type".equals(option.getName()) && "bindy".equals(model.getModelName())) {
                switch (name) {
                    case "bindyCsv": {
                        option.setDefaultValue((Object)"Csv");
                        break;
                    }
                    case "bindyFixed": {
                        option.setDefaultValue((Object)"Fixed");
                        break;
                    }
                    case "bindyKvp": {
                        option.setDefaultValue((Object)"KeyValue");
                        break;
                    }
                }
            }
            if ("objectMapper".equals(option.getName()) && "johnzon".equals(name)) {
                option.setDisplayName("Mapper");
                option.setDescription("Lookup and use the existing Mapper with the given id.");
            }
            if ("objectMapper".equals(option.getName()) && "jsonb".equals(name)) {
                option.setDisplayName("Jsonb instance");
                option.setDescription("Lookup and use the existing Jsonb instance with the given id.");
            }
            if ("library".equals(option.getName()) && "json".equals(model.getModelName())) {
                switch (name) {
                    case "gson": {
                        option.setDefaultValue((Object)"Gson");
                        break;
                    }
                    case "jackson": {
                        option.setDefaultValue((Object)"Jackson");
                        break;
                    }
                    case "johnzon": {
                        option.setDefaultValue((Object)"Johnzon");
                        break;
                    }
                    case "jsonb": {
                        option.setDefaultValue((Object)"JSON-B");
                        break;
                    }
                    case "json-fastson": {
                        option.setDefaultValue((Object)"Fastjson");
                        break;
                    }
                    case "xstreamJson": {
                        option.setDefaultValue((Object)"XStream");
                        break;
                    }
                }
            }
            model.addOption((BaseOptionModel)option);
        }
        return model;
    }

    private static String readClassFromCamelResource(File file, StringBuilder buffer, BuildContext buildContext) throws MojoExecutionException {
        if (file.isDirectory()) {
            return null;
        }
        String name = file.getName();
        if (name.charAt(0) != '.') {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(name);
        }
        if (!buildContext.hasDelta(file)) {
            return null;
        }
        try {
            String text = PackageHelper.loadText((File)file);
            Map map = PackageHelper.parseAsMap((String)text);
            return (String)map.get("class");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read file " + file + ". Reason: " + e, (Exception)e);
        }
    }

    private static String asModelName(String name) {
        if ("gson".equals(name) || "jackson".equals(name) || "johnzon".equals(name) || "xstreamJson".equals(name) || "fastjson".equals(name) || "jsonb".equals(name)) {
            return "json";
        }
        if ("bindyCsv".equals(name) || "bindyFixed".equals(name) || "bindyKvp".equals(name)) {
            return "bindy";
        }
        if ("snakeYaml".equals(name)) {
            return "yaml";
        }
        if ("avroJackson".equals(name)) {
            return "avro";
        }
        if ("protobufJackson".equals(name)) {
            return "protobuf";
        }
        return name;
    }

    private static String asModelFirstVersion(String name, String firstVersion) {
        switch (name) {
            case "gson": {
                return "2.10.0";
            }
            case "jackson": {
                return "2.0.0";
            }
            case "johnzon": {
                return "2.18.0";
            }
            case "jsonb": {
                return "3.7.0";
            }
            case "xstreamJson": {
                return "2.0.0";
            }
            case "fastjson": {
                return "2.20.0";
            }
            case "avroJackson": {
                return "3.10.0";
            }
            case "protobufJackson": {
                return "3.10.0";
            }
        }
        return firstVersion;
    }

    private static String asModelTitle(String name, String title) {
        if ("gson".equals(name)) {
            return "JSON Gson";
        }
        if ("jackson".equals(name)) {
            return "JSON Jackson";
        }
        if ("avroJackson".equals(name)) {
            return "Avro Jackson";
        }
        if ("protobufJackson".equals(name)) {
            return "Protobuf Jackson";
        }
        if ("johnzon".equals(name)) {
            return "JSON Johnzon";
        }
        if ("jsonb".equals(name)) {
            return "JSON JSON-B";
        }
        if ("xstreamJson".equals(name)) {
            return "JSON XStream";
        }
        if ("fastjson".equals(name)) {
            return "JSON Fastjson";
        }
        if ("bindyCsv".equals(name)) {
            return "Bindy CSV";
        }
        if ("bindyFixed".equals(name)) {
            return "Bindy Fixed Length";
        }
        if ("bindyKvp".equals(name)) {
            return "Bindy Key Value Pair";
        }
        if ("snakeYaml".equals(name)) {
            return "YAML SnakeYAML";
        }
        return title;
    }

    private static String schemaSubDirectory(String javaType) {
        int idx = javaType.lastIndexOf(46);
        String pckName = javaType.substring(0, idx);
        return pckName.replace('.', '/');
    }

    private List<DataFormatModel.DataFormatOptionModel> parseConfigurationSource(MavenProject project, String className) throws IOException {
        ArrayList<DataFormatModel.DataFormatOptionModel> answer = new ArrayList<DataFormatModel.DataFormatOptionModel>();
        Optional<JavaClassSource> optClazz = this.javaClassSource(className);
        if (!optClazz.isPresent()) {
            return Collections.emptyList();
        }
        JavaClassSource clazz = optClazz.get();
        List<FieldSource> fields = clazz.getFields();
        fields = fields.stream().filter(f -> !f.isFinal() && !f.isStatic()).collect(Collectors.toList());
        fields.forEach(f -> {
            String name = f.getName();
            Object javaType = f.getType().getQualifiedName();
            if (f.getType().isArray()) {
                javaType = (String)javaType + "[]";
            }
            String setterName = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            MethodSource setter = clazz.getMethod(setterName, new String[]{javaType});
            if (setter != null) {
                DataFormatModel.DataFormatOptionModel model = new DataFormatModel.DataFormatOptionModel();
                model.setName(name);
                model.setJavaType((String)javaType);
                answer.add(model);
            }
        });
        if (clazz.getSuperType() != null) {
            answer.addAll(this.parseConfigurationSource(project, clazz.getSuperType()));
        }
        return answer;
    }

    private Optional<JavaClassSource> javaClassSource(String className) {
        return this.sources.computeIfAbsent(className, this::doParseJavaClassSource);
    }

    private Optional<JavaClassSource> doParseJavaClassSource(String className) {
        try {
            Path srcDir = this.project.getBasedir().toPath().resolve("src/main/java");
            Path file = srcDir.resolve(className.replaceAll("<.*>", "").replace('.', '/') + ".java");
            if (!Files.isRegularFile(file, new LinkOption[0])) {
                return Optional.empty();
            }
            return Optional.of((JavaClassSource)Roaster.parse((File)file.toFile()));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse java class " + className, e);
        }
    }

    public static String generatePropertyConfigurer(String pn, String cn, String en, Collection<DataFormatModel.DataFormatOptionModel> options) throws IOException {
        try (StringWriter w = new StringWriter();){
            w.write("/* Generated by camel build tools - do NOT edit this file! */\n");
            w.write("package " + pn + ";\n");
            w.write("\n");
            w.write("import java.util.HashMap;\n");
            w.write("import java.util.Map;\n");
            w.write("\n");
            w.write("import org.apache.camel.CamelContext;\n");
            w.write("import org.apache.camel.spi.GeneratedPropertyConfigurer;\n");
            w.write("import org.apache.camel.support.component.PropertyConfigurerSupport;\n");
            w.write("\n");
            w.write("/**\n");
            w.write(" * Generated by camel build tools - do NOT edit this file!\n");
            w.write(" */\n");
            w.write("@SuppressWarnings(\"unchecked\")\n");
            w.write("public class " + cn + " extends PropertyConfigurerSupport implements GeneratedPropertyConfigurer {\n");
            w.write("\n");
            w.write("    @Override\n");
            w.write("    public boolean configure(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase) {\n");
            w.write("        " + en + " dataformat = (" + en + ") target;\n");
            w.write("        switch (ignoreCase ? name.toLowerCase() : name) {\n");
            for (DataFormatModel.DataFormatOptionModel option : options) {
                String name = option.getName();
                if ("id".equals(name)) continue;
                String setter = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
                String type = Strings.canonicalClassName((String)option.getJavaType());
                if (!name.toLowerCase().equals(name)) {
                    w.write(String.format("        case \"%s\":\n", name.toLowerCase()));
                }
                w.write(String.format("        case \"%s\": dataformat.%s(property(camelContext, %s.class, value)); return true;\n", name, setter, type));
            }
            w.write("        default: return false;\n");
            w.write("        }\n");
            w.write("    }\n");
            w.write("\n");
            w.write("}\n");
            w.write("\n");
            String string = w.toString();
            return string;
        }
    }

    public static String generateMetaInfConfigurer(String fqn) {
        return "# Generated by camel build tools - do NOT edit this file!\nclass=" + fqn + "\n";
    }
}

