/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.EndpointUriFactoryGenerator;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate-endpoint-uri-factory", threadSafe=true, defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyCollection=ResolutionScope.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class GenerateEndpointUriFactoryMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/java")
    protected File sourcesOutputDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File resourcesOutputDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Map<File, Supplier<String>> files;
        if ("pom".equals(this.project.getPackaging())) {
            return;
        }
        this.buildDir = new File(this.project.getBuild().getDirectory());
        if (this.sourcesOutputDir == null) {
            this.sourcesOutputDir = new File(this.project.getBasedir(), "src/generated/java");
        }
        if (this.resourcesOutputDir == null) {
            this.resourcesOutputDir = new File(this.project.getBasedir(), "src/generated/resources");
        }
        try (Stream<Path> pathStream = Files.find(this.buildDir.toPath(), Integer.MAX_VALUE, (x$0, x$1) -> super.isJsonFile((Path)x$0, (BasicFileAttributes)x$1), new FileVisitOption[0]);){
            files = pathStream.collect(Collectors.toMap(Path::toFile, s -> GenerateEndpointUriFactoryMojo.cache(() -> GenerateEndpointUriFactoryMojo.loadJson(s.toFile()))));
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.executeComponent(files);
    }

    private void executeComponent(Map<File, Supplier<String>> jsonFiles) throws MojoExecutionException {
        TreeSet<String> componentNames = new TreeSet<String>();
        this.findComponentNames(this.buildDir, componentNames);
        if (!componentNames.isEmpty()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Found " + componentNames.size() + " components"));
            }
            LinkedList<ComponentModel> allModels = new LinkedList<ComponentModel>();
            for (String componentName : componentNames) {
                String json = GenerateEndpointUriFactoryMojo.loadComponentJson(jsonFiles, componentName);
                if (json == null) continue;
                ComponentModel model = JsonMapper.generateComponentModel((String)json);
                allModels.add(model);
            }
            Map<String, List<ComponentModel>> grModels = allModels.stream().collect(Collectors.groupingBy(BaseModel::getJavaType));
            for (List<ComponentModel> compModels : grModels.values()) {
                for (ComponentModel model : compModels) {
                    try {
                        this.createEndpointUriFactory(model);
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Error generating source code", (Exception)e);
                    }
                }
            }
        }
    }

    protected void createEndpointUriFactory(ComponentModel model) throws IOException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Generating endpoint-uri-factory: " + model.getScheme()));
        }
        Object fqn = model.getJavaType();
        this.generateEndpointUriFactory((String)fqn, model, this.sourcesOutputDir);
        int pos = ((String)fqn).lastIndexOf(46);
        String pn = ((String)fqn).substring(0, pos);
        Object cn = ((String)fqn).substring(pos + 1) + "EndpointUriFactory";
        cn = ((String)cn).replace("Component", "");
        fqn = pn + "." + (String)cn;
        String pval = model.getScheme() + "-endpoint";
        this.updateResource(this.resourcesOutputDir.toPath(), "META-INF/services/org/apache/camel/urifactory/" + pval, "# Generated by camel build tools - do NOT edit this file!\nclass=" + (String)fqn + "\n");
        if (model.getAlternativeSchemes() != null) {
            String[] schemes;
            for (String alt : schemes = model.getAlternativeSchemes().split(",")) {
                pval = alt + "-endpoint";
                this.updateResource(this.resourcesOutputDir.toPath(), "META-INF/services/org/apache/camel/urifactory/" + pval, "# Generated by camel build tools - do NOT edit this file!\nclass=" + (String)fqn + "\n");
            }
        }
    }

    @Deprecated
    private void generateEndpointUriFactory(String targetFqn, ComponentModel model, File outputDir) {
        int pos = targetFqn.lastIndexOf(46);
        String pn = targetFqn.substring(0, pos);
        Object cn = targetFqn.substring(pos + 1) + "EndpointUriFactory";
        cn = ((String)cn).replace("Component", "");
        String psn = "org.apache.camel.support.component.EndpointUriFactorySupport";
        String source = EndpointUriFactoryGenerator.generateEndpointUriFactory(pn, (String)cn, psn, model);
        String fileName = pn.replace('.', '/') + "/" + (String)cn + ".java";
        outputDir.mkdirs();
        boolean updated = GenerateEndpointUriFactoryMojo.updateResource(this.buildContext, outputDir.toPath().resolve(fileName), source);
        if (updated) {
            this.getLog().info((CharSequence)("Updated " + fileName));
        }
    }

    protected static String loadJson(File file) {
        try {
            return PackageHelper.loadText((File)file);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    protected static String loadComponentJson(Map<File, Supplier<String>> jsonFiles, String componentName) {
        return GenerateEndpointUriFactoryMojo.loadJsonOfType(jsonFiles, componentName, "component");
    }

    protected static String loadJsonOfType(Map<File, Supplier<String>> jsonFiles, String modelName, String type) {
        for (Map.Entry<File, Supplier<String>> entry : jsonFiles.entrySet()) {
            String json;
            if (!entry.getKey().getName().equals(modelName + ".json") || !(json = entry.getValue().get()).contains("\"kind\": \"" + type + "\"")) continue;
            return json;
        }
        return null;
    }

    protected void findComponentNames(File dir, Set<String> componentNames) {
        File[] files;
        File f = new File(dir, "classes/META-INF/services/org/apache/camel/component");
        if (f.exists() && f.isDirectory() && (files = f.listFiles()) != null) {
            for (File file : files) {
                String name;
                if (file.isDirectory() || (name = file.getName()).charAt(0) == '.') continue;
                componentNames.add(name);
            }
        }
    }
}

