/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.spi.Metadata;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.model.MainModel;
import org.apache.camel.tooling.util.JavadocHelper;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.build.BuildContext;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;

@Mojo(name="prepare-main-doc", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class PrepareCamelMainMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.basedir}/src/main/doc")
    protected File outFolder;

    @Inject
    public PrepareCamelMainMojo(MavenProjectHelper projectHelper, BuildContext buildContext) {
        super(projectHelper, buildContext);
    }

    public static List<MainModel.MainOptionModel> parseConfigurationSource(String fileName) throws IOException {
        return PrepareCamelMainMojo.parseConfigurationSource(new File(fileName));
    }

    public static List<MainModel.MainOptionModel> parseConfigurationSource(File file) throws IOException {
        ArrayList<MainModel.MainOptionModel> answer = new ArrayList<MainModel.MainOptionModel>();
        JavaClassSource clazz = (JavaClassSource)Roaster.parse((File)file);
        List<FieldSource> fields = clazz.getFields();
        fields = fields.stream().filter(f -> !f.isFinal() && !f.isStatic()).collect(Collectors.toList());
        fields.forEach(f -> {
            String setterName;
            MethodSource setter;
            AnnotationSource as = f.getAnnotation(Metadata.class);
            String name = f.getName();
            String javaType = f.getType().getQualifiedName();
            String sourceType = clazz.getQualifiedName();
            String defaultValue = f.getStringInitializer();
            if (as != null) {
                defaultValue = as.getStringValue("defaultValue");
            }
            if (defaultValue != null && defaultValue.startsWith("new ")) {
                defaultValue = null;
            }
            if ((setter = clazz.getMethod(setterName = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1), new String[]{javaType})) != null) {
                String text;
                String desc = setter.getJavaDoc().getFullText();
                boolean deprecated = clazz.getAnnotation(Deprecated.class) != null || setter.getAnnotation(Deprecated.class) != null;
                String type = PrepareCamelMainMojo.fromMainToType(javaType);
                MainModel.MainOptionModel model = new MainModel.MainOptionModel();
                model.setName(name);
                model.setType(type);
                model.setJavaType(javaType);
                model.setDescription(JavadocHelper.sanitizeDescription((String)desc, (boolean)false));
                model.setSourceType(sourceType);
                model.setDefaultValue(PrepareCamelMainMojo.asDefaultValue(type, defaultValue));
                model.setDeprecated(deprecated);
                List<String> enums = null;
                if ("org.apache.camel.LoggingLevel".equals(javaType)) {
                    enums = Arrays.asList("ERROR,WARN,INFO,DEBUG,TRACE,OFF".split(","));
                } else if ("org.apache.camel.ManagementStatisticsLevel".equals(javaType)) {
                    enums = Arrays.asList("Extended,Default,RoutesOnly,Off".split(","));
                } else if ("org.apache.camel.spi.RestBindingMode".equals(javaType)) {
                    enums = Arrays.asList("auto,off,json,xml,json_xml".split(","));
                } else if ("org.apache.camel.spi.RestHostNameResolver".equals(javaType)) {
                    enums = Arrays.asList("allLocalIp,localIp,localHostName".split(","));
                } else if ("org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy".equals(javaType)) {
                    enums = Arrays.asList("Abort,CallerRuns,DiscardOldest,Discard".split(","));
                }
                if (enums == null && as != null && (text = as.getStringValue("enums")) != null) {
                    enums = Arrays.asList(text.split(","));
                }
                model.setEnums(enums);
                answer.add(model);
            }
        });
        return answer;
    }

    private static String fromMainToType(String type) {
        if ("boolean".equals(type) || "java.lang.Boolean".equals(type)) {
            return "boolean";
        }
        if ("int".equals(type) || "java.lang.Integer".equals(type)) {
            return "integer";
        }
        if ("long".equals(type) || "java.lang.Long".equals(type)) {
            return "integer";
        }
        if ("float".equals(type) || "java.lang.Float".equals(type)) {
            return "number";
        }
        if ("double".equals(type) || "java.lang.Double".equals(type)) {
            return "number";
        }
        if ("string".equals(type) || "java.lang.String".equals(type)) {
            return "string";
        }
        return "object";
    }

    private static Object asDefaultValue(String type, String defaultValue) {
        if (defaultValue != null) {
            if ("boolean".equals(type)) {
                return Boolean.parseBoolean(defaultValue);
            }
            if ("integer".equals(type)) {
                return Integer.parseInt(defaultValue);
            }
        }
        if (defaultValue == null && "boolean".equals(type)) {
            return "false";
        }
        return defaultValue;
    }

    @Override
    public void execute(MavenProject project) throws MojoFailureException, MojoExecutionException {
        this.outFolder = new File(project.getBasedir(), "src/generated/resources");
        super.execute(project);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        MainModel model;
        List<MainModel.MainOptionModel> model2;
        File[] files = new File(this.project.getBasedir(), "src/main/java/org/apache/camel/main").listFiles(f -> f.isFile() && f.getName().endsWith("Properties.java"));
        if (files == null || files.length == 0) {
            return;
        }
        ArrayList<MainModel.MainOptionModel> data = new ArrayList<MainModel.MainOptionModel>();
        for (File file : files) {
            this.getLog().info((CharSequence)("Parsing Camel Main configuration file: " + String.valueOf(file)));
            try {
                String prefix;
                model2 = PrepareCamelMainMojo.parseConfigurationSource(file);
                if (file.getName().contains("Resilience")) {
                    prefix = "camel.resilience4j.";
                } else if (file.getName().contains("FaultTolerance")) {
                    prefix = "camel.faulttolerance.";
                } else if (file.getName().contains("Rest")) {
                    prefix = "camel.rest.";
                } else if (file.getName().contains("AwsVault")) {
                    prefix = "camel.vault.aws.";
                } else if (file.getName().contains("GcpVault")) {
                    prefix = "camel.vault.gcp.";
                } else if (file.getName().contains("AzureVault")) {
                    prefix = "camel.vault.azure.";
                } else if (file.getName().contains("KubernetesVault")) {
                    prefix = "camel.vault.kubernetes.";
                } else if (file.getName().contains("KubernetesConfigMapVault")) {
                    prefix = "camel.vault.kubernetescm.";
                } else if (file.getName().contains("HashicorpVault")) {
                    prefix = "camel.vault.hashicorp.";
                } else if (file.getName().contains("Health")) {
                    prefix = "camel.health.";
                } else if (file.getName().contains("StartupCondition")) {
                    prefix = "camel.startupcondition.";
                } else if (file.getName().contains("Lra")) {
                    prefix = "camel.lra.";
                } else if (file.getName().contains("Otel")) {
                    prefix = "camel.opentelemetry.";
                } else if (file.getName().contains("Metrics")) {
                    prefix = "camel.metrics.";
                } else if (file.getName().contains("HttpServer")) {
                    prefix = "camel.server.";
                } else {
                    if (file.getName().contains("ThreadPoolProfileConfigurationProperties")) continue;
                    prefix = file.getName().contains("ThreadPoolConfigurationProperties") ? "camel.threadpool." : (file.getName().contains("SSLConfigurationProperties") ? "camel.ssl." : (file.getName().contains("DebuggerConfigurationProperties") ? "camel.debug." : (file.getName().contains("TracerConfigurationProperties") ? "camel.trace." : (file.getName().contains("RouteControllerConfigurationProperties") ? "camel.routecontroller." : "camel.main."))));
                }
                String namePrefix = prefix;
                model2.forEach(m -> m.setName(namePrefix + m.getName()));
                data.addAll(model2);
            }
            catch (Exception e) {
                throw new MojoFailureException("Error parsing file " + String.valueOf(file) + " due " + e.getMessage(), (Throwable)e);
            }
        }
        File camelApiDir = PackageHelper.findCamelDirectory((File)this.project.getBasedir(), (String)"core/camel-api");
        File restConfig = new File(camelApiDir, "src/main/java/org/apache/camel/spi/RestConfiguration.java");
        try {
            List<MainModel.MainOptionModel> model3 = PrepareCamelMainMojo.parseConfigurationSource(restConfig);
            model3.forEach(m -> m.setName("camel.rest." + m.getName()));
            data.addAll(model3);
        }
        catch (Exception e) {
            throw new MojoFailureException("Error parsing file " + String.valueOf(restConfig) + " due " + e.getMessage(), (Throwable)e);
        }
        File awsVaultConfig = new File(camelApiDir, "src/main/java/org/apache/camel/vault/AwsVaultConfiguration.java");
        try {
            List<MainModel.MainOptionModel> model4 = PrepareCamelMainMojo.parseConfigurationSource(awsVaultConfig);
            model4.forEach(m -> m.setName("camel.vault.aws." + m.getName()));
            data.addAll(model4);
        }
        catch (Exception e) {
            throw new MojoFailureException("Error parsing file " + String.valueOf(awsVaultConfig) + " due " + e.getMessage(), (Throwable)e);
        }
        File gcpVaultConfig = new File(camelApiDir, "src/main/java/org/apache/camel/vault/GcpVaultConfiguration.java");
        try {
            model2 = PrepareCamelMainMojo.parseConfigurationSource(gcpVaultConfig);
            model2.forEach(m -> m.setName("camel.vault.gcp." + m.getName()));
            data.addAll(model2);
        }
        catch (Exception e) {
            throw new MojoFailureException("Error parsing file " + String.valueOf(gcpVaultConfig) + " due " + e.getMessage(), (Throwable)e);
        }
        File azureVaultConfig = new File(camelApiDir, "src/main/java/org/apache/camel/vault/AzureVaultConfiguration.java");
        try {
            List<MainModel.MainOptionModel> model5 = PrepareCamelMainMojo.parseConfigurationSource(azureVaultConfig);
            model5.forEach(m -> m.setName("camel.vault.azure." + m.getName()));
            data.addAll(model5);
        }
        catch (Exception e) {
            throw new MojoFailureException("Error parsing file " + String.valueOf(azureVaultConfig) + " due " + e.getMessage(), (Throwable)e);
        }
        File kubernetesVaultConfig = new File(camelApiDir, "src/main/java/org/apache/camel/vault/KubernetesVaultConfiguration.java");
        try {
            List<MainModel.MainOptionModel> model6 = PrepareCamelMainMojo.parseConfigurationSource(kubernetesVaultConfig);
            model6.forEach(m -> m.setName("camel.vault.kubernetes." + m.getName()));
            data.addAll(model6);
        }
        catch (Exception e) {
            throw new MojoFailureException("Error parsing file " + String.valueOf(kubernetesVaultConfig) + " due " + e.getMessage(), (Throwable)e);
        }
        File kubernetesConfigmapsVaultConfig = new File(camelApiDir, "src/main/java/org/apache/camel/vault/KubernetesConfigMapVaultConfiguration.java");
        try {
            List<MainModel.MainOptionModel> model7 = PrepareCamelMainMojo.parseConfigurationSource(kubernetesConfigmapsVaultConfig);
            model7.forEach(m -> m.setName("camel.vault.kubernetescm." + m.getName()));
            data.addAll(model7);
        }
        catch (Exception e) {
            throw new MojoFailureException("Error parsing file " + String.valueOf(kubernetesConfigmapsVaultConfig) + " due " + e.getMessage(), (Throwable)e);
        }
        File hashicorpVaultConfig = new File(camelApiDir, "src/main/java/org/apache/camel/vault/HashicorpVaultConfiguration.java");
        try {
            model = PrepareCamelMainMojo.parseConfigurationSource(hashicorpVaultConfig);
            model.forEach(m -> m.setName("camel.vault.hashicorp." + m.getName()));
            data.addAll((Collection<MainModel.MainOptionModel>)model);
        }
        catch (Exception e) {
            throw new MojoFailureException("Error parsing file " + String.valueOf(hashicorpVaultConfig) + " due " + e.getMessage(), (Throwable)e);
        }
        data.sort((o1, o2) -> {
            if (o1.getName().startsWith("camel.main.") && !o2.getName().startsWith("camel.main.")) {
                return -1;
            }
            if (!o1.getName().startsWith("camel.main.") && o2.getName().startsWith("camel.main.")) {
                return 1;
            }
            return o1.getName().compareToIgnoreCase(o2.getName());
        });
        if (!data.isEmpty()) {
            model = new MainModel();
            model.getOptions().addAll(data);
            model.getGroups().add(new MainModel.MainGroupModel("camel.main", "Camel Main configurations", "org.apache.camel.main.DefaultConfigurationProperties"));
            model.getGroups().add(new MainModel.MainGroupModel("camel.startupcondition", "Camel Startup Condition configurations", "org.apache.camel.main.StartupConditionConfigurationProperties"));
            model.getGroups().add(new MainModel.MainGroupModel("camel.routecontroller", "Camel Route Controller configurations", "org.apache.camel.main.RouteControllerConfigurationProperties"));
            model.getGroups().add(new MainModel.MainGroupModel("camel.server", "Camel Embedded HTTP Server (only for standalone; not Spring Boot or Quarkus) configurations", "org.apache.camel.main.HttpServerConfigurationProperties"));
            model.getGroups().add(new MainModel.MainGroupModel("camel.debug", "Camel Debugger configurations", "org.apache.camel.main.DebuggerConfigurationProperties"));
            model.getGroups().add(new MainModel.MainGroupModel("camel.trace", "Camel Tracer configurations", "org.apache.camel.main.TracerConfigurationProperties"));
            model.getGroups().add(new MainModel.MainGroupModel("camel.ssl", "Camel SSL configurations", "org.apache.camel.main.SSLConfigurationProperties"));
            model.getGroups().add(new MainModel.MainGroupModel("camel.threadpool", "Camel Thread Pool configurations", "org.apache.camel.main.ThreadPoolConfigurationProperties"));
            model.getGroups().add(new MainModel.MainGroupModel("camel.health", "Camel Health Check configurations", "org.apache.camel.main.HealthConfigurationProperties"));
            model.getGroups().add(new MainModel.MainGroupModel("camel.rest", "Camel Rest-DSL configurations", "org.apache.camel.spi.RestConfiguration"));
            model.getGroups().add(new MainModel.MainGroupModel("camel.vault.aws", "Camel AWS Vault configurations", "org.apache.camel.vault.AwsVaultConfiguration"));
            model.getGroups().add(new MainModel.MainGroupModel("camel.vault.gcp", "Camel GCP Vault configurations", "org.apache.camel.vault.GcpVaultConfiguration"));
            model.getGroups().add(new MainModel.MainGroupModel("camel.vault.azure", "Camel Azure Key Vault configurations", "org.apache.camel.vault.AzureVaultConfiguration"));
            model.getGroups().add(new MainModel.MainGroupModel("camel.vault.kubernetes", "Camel Kubernetes Vault configurations", "org.apache.camel.vault.KubernetesVaultConfiguration"));
            model.getGroups().add(new MainModel.MainGroupModel("camel.vault.kubernetescm", "Camel Kubernetes Configmaps Vault configurations", "org.apache.camel.vault.KubernetesConfigMapVaultConfiguration"));
            model.getGroups().add(new MainModel.MainGroupModel("camel.vault.hashicorp", "Camel Hashicorp Vault configurations", "org.apache.camel.vault.HashicorpVaultConfiguration"));
            model.getGroups().add(new MainModel.MainGroupModel("camel.opentelemetry", "Camel OpenTelemetry configurations", "org.apache.camel.main.OtelConfigurationProperties"));
            model.getGroups().add(new MainModel.MainGroupModel("camel.metrics", "Camel Micrometer Metrics configurations", "org.apache.camel.main.MetricsConfigurationProperties"));
            model.getGroups().add(new MainModel.MainGroupModel("camel.faulttolerance", "Fault Tolerance EIP Circuit Breaker configurations", "org.apache.camel.main.FaultToleranceConfigurationProperties"));
            model.getGroups().add(new MainModel.MainGroupModel("camel.resilience4j", "Resilience4j EIP Circuit Breaker configurations", "org.apache.camel.main.Resilience4jConfigurationProperties"));
            model.getGroups().add(new MainModel.MainGroupModel("camel.lra", "Camel Saga EIP (Long Running Actions) configurations", "org.apache.camel.main.LraConfigurationProperties"));
            String json = JsonMapper.createJsonSchema((MainModel)model);
            this.updateResource(this.outFolder.toPath(), "META-INF/camel-main-configuration-metadata.json", json);
        }
    }
}

