/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.StringJoiner;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.MojoHelper;
import org.apache.camel.maven.packaging.generics.PackagePluginUtils;
import org.apache.camel.tooling.util.Strings;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;

@Mojo(name="generate-data-type-transformer", threadSafe=true, defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyCollection=ResolutionScope.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class GenerateDataTypeTransformerMojo
extends AbstractGeneratorMojo {
    public static final DotName DATA_TYPE_ANNOTATION = DotName.createSimple((String)"org.apache.camel.spi.DataTypeTransformer");
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File resourcesOutputDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Index index;
        if ("pom".equals(this.project.getPackaging())) {
            return;
        }
        this.buildDir = new File(this.project.getBuild().getDirectory());
        if (this.resourcesOutputDir == null) {
            this.resourcesOutputDir = new File(this.project.getBasedir(), "src/generated/resources");
        }
        if ((index = PackagePluginUtils.readJandexIndexIgnoreMissing(this.project, this.getLog())) == null) {
            return;
        }
        ArrayList<DataTypeTransformerModel> models = new ArrayList<DataTypeTransformerModel>();
        List annotations = index.getAnnotations(DATA_TYPE_ANNOTATION);
        annotations.forEach(a -> {
            DataTypeTransformerModel model = new DataTypeTransformerModel();
            String currentClass = a.target().asClass().name().toString();
            boolean deprecated = a.target().asClass().hasAnnotation(Deprecated.class) || this.project.getName().contains("(deprecated)");
            model.setClassName(currentClass);
            model.setDeprecated(deprecated);
            model.setName(MojoHelper.annotationValue(a, "name"));
            model.setFrom(MojoHelper.annotationValue(a, "from"));
            model.setTo(MojoHelper.annotationValue(a, "to"));
            model.setDescription(MojoHelper.annotationValue(a, "description"));
            models.add(model);
        });
        models.sort(Comparator.comparing(DataTypeTransformerModel::getName));
        if (!models.isEmpty()) {
            try {
                StringJoiner names = new StringJoiner(" ");
                for (DataTypeTransformerModel model : models) {
                    names.add(model.getName());
                    JsonObject jo = this.asJsonObject(model);
                    String json = jo.toJson();
                    json = Jsoner.prettyPrint((String)json, (int)2);
                    String fn = this.sanitizeFileName(model.getName()) + ".json";
                    boolean updated = this.updateResource(this.resourcesOutputDir.toPath(), "META-INF/services/org/apache/camel/transformer/" + fn, json + "\n");
                    if (!updated) continue;
                    this.getLog().info((CharSequence)("Updated transformer json: " + model.getName()));
                }
                File camelMetaDir = new File(this.resourcesOutputDir, "META-INF/services/org/apache/camel/");
                int count = models.size();
                String properties = GenerateDataTypeTransformerMojo.createProperties(this.project, "transformers", names.toString());
                this.updateResource(camelMetaDir.toPath(), "transformer.properties", properties);
                this.getLog().info((CharSequence)("Generated transformer.properties containing " + count + " Camel " + (count > 1 ? "transformers: " : "transformer: ") + String.valueOf(names)));
            }
            catch (Exception e) {
                throw new MojoExecutionException((Throwable)e);
            }
        }
    }

    private JsonObject asJsonObject(DataTypeTransformerModel model) {
        JsonObject jo = new JsonObject();
        jo.put((Object)"kind", (Object)"transformer");
        jo.put((Object)"name", (Object)model.getName());
        jo.put((Object)"title", (Object)this.asTitle(model.getName()));
        if (model.getDescription() != null) {
            jo.put((Object)"description", (Object)model.getDescription());
        }
        jo.put((Object)"deprecated", (Object)model.isDeprecated());
        jo.put((Object)"javaType", (Object)model.getClassName());
        if (model.getFrom() != null) {
            jo.put((Object)"from", (Object)model.getFrom());
        }
        if (model.getTo() != null) {
            jo.put((Object)"to", (Object)model.getTo());
        }
        jo.put((Object)"groupId", (Object)this.project.getGroupId());
        jo.put((Object)"artifactId", (Object)this.project.getArtifactId());
        jo.put((Object)"version", (Object)this.project.getVersion());
        JsonObject root = new JsonObject();
        root.put((Object)"transformer", (Object)jo);
        return root;
    }

    private String sanitizeFileName(String fileName) {
        return fileName.replaceAll("[^A-Za-z0-9+-/]", "-");
    }

    private String asTitle(String name) {
        String part = Strings.after((String)(name = Strings.camelDashToTitle((String)name)), (String)":");
        if (part != null) {
            part = Strings.capitalize((String)part);
            name = Strings.before((String)name, (String)":") + " (" + part + ")";
        }
        return name;
    }

    private static class DataTypeTransformerModel {
        private String className;
        private String name;
        private String from;
        private String to;
        private String description;
        private boolean deprecated;

        private DataTypeTransformerModel() {
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getTo() {
            return this.to;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean isDeprecated() {
            return this.deprecated;
        }

        public void setDeprecated(boolean deprecated) {
            this.deprecated = deprecated;
        }
    }
}

