/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.DataFormatModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.model.LanguageModel;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="update-sensitive-helper", threadSafe=true)
public class UpdateSensitizeHelper
extends AbstractGeneratorMojo {
    private static final String KEYS_START_TOKEN = "// SENSITIVE-KEYS: START";
    private static final String KEYS_END_TOKEN = "// SENSITIVE-KEYS: END";
    private static final String PATTERN_START_TOKEN = "// SENSITIVE-PATTERN: START";
    private static final String PATTERN_END_TOKEN = "// SENSITIVE-PATTERN: END";
    private static final String[] EXTRA_KEYS = new String[]{"apipassword", "apiuser", "apiusername", "api_key", "api_secret", "secret", "keystorePassword"};
    @Parameter(defaultValue="${project.basedir}/src/generated/resources/org/apache/camel/catalog/")
    protected File jsonDir;
    @Parameter(defaultValue="${project.basedir}/")
    protected File baseDir;

    public void execute() throws MojoExecutionException {
        List jsonFiles;
        File camelDir = PackageHelper.findCamelDirectory((File)this.baseDir, (String)"core/camel-util");
        if (camelDir == null) {
            this.getLog().debug((CharSequence)"No core/camel-util folder found, skipping execution");
            return;
        }
        try (Stream stream = PackageHelper.findJsonFiles((Path)this.jsonDir.toPath());){
            jsonFiles = stream.toList();
        }
        TreeSet<String> secrets = new TreeSet<String>();
        for (Path file : jsonFiles) {
            String name = PackageHelper.asName((Path)file);
            try {
                boolean isLanguage;
                String json = PackageHelper.loadText((File)file.toFile());
                Object jo = Jsoner.deserialize((String)json);
                if (!(jo instanceof JsonObject)) continue;
                JsonObject obj = (JsonObject)jo;
                boolean isComponent = obj.getMap("component") != null;
                boolean isDataFormat = !isComponent && obj.getMap("dataformat") != null;
                boolean bl = isLanguage = !isComponent && !isDataFormat && obj.getMap("language") != null;
                if (!isComponent && !isDataFormat && !isLanguage) continue;
                if (isComponent) {
                    ComponentModel cm = JsonMapper.generateComponentModel((String)json);
                    cm.getComponentOptions().forEach(o -> {
                        if (o.isSecret()) {
                            String key = o.getName().toLowerCase(Locale.ENGLISH);
                            key = key.replace("-", "");
                            secrets.add(key);
                        }
                    });
                    continue;
                }
                if (isDataFormat) {
                    DataFormatModel dm = JsonMapper.generateDataFormatModel((String)json);
                    dm.getOptions().forEach(o -> {
                        if (o.isSecret()) {
                            String key = o.getName().toLowerCase(Locale.ENGLISH);
                            key = key.replace("-", "");
                            secrets.add(key);
                        }
                    });
                    continue;
                }
                if (!isLanguage) continue;
                LanguageModel lm = JsonMapper.generateLanguageModel((String)json);
                lm.getOptions().forEach(o -> {
                    if (o.isSecret()) {
                        String key = o.getName().toLowerCase(Locale.ENGLISH);
                        key = key.replace("-", "");
                        secrets.add(key);
                    }
                });
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error loading json: " + name, e);
            }
        }
        secrets.addAll(Arrays.asList(EXTRA_KEYS));
        this.getLog().info((CharSequence)("There are " + secrets.size() + " distinct secret options across all the Camel components/dataformats/languages"));
        try {
            boolean updated = this.updateSensitiveHelperKeys(camelDir, secrets);
            if (updated |= this.updateSensitiveHelperPatterns(camelDir, secrets)) {
                this.getLog().info((CharSequence)"Updated camel-util/src/main/java/org/apache/camel/util/SensitiveUtils.java file");
            } else {
                this.getLog().debug((CharSequence)"No changes to camel-util/src/main/java/org/apache/camel/util/SensitiveUtils.java file");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error updating SensitiveUtils.java", e);
        }
        try {
            this.updateSensitiveJsonSchema(this.baseDir, secrets);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error updating sensitive-keys.json", e);
        }
    }

    private boolean updateSensitiveHelperKeys(File camelDir, Set<String> secrets) throws Exception {
        File java = new File(camelDir, "src/main/java/org/apache/camel/util/SensitiveUtils.java");
        Object text = PackageHelper.loadText((File)java);
        String spaces20 = "                    ";
        String spaces12 = "            ";
        StringJoiner sb = new StringJoiner(",\n");
        for (String name : secrets) {
            sb.add(spaces20 + "\"" + name + "\"");
        }
        String changed = sb.toString();
        String existing = Strings.between((String)text, (String)KEYS_START_TOKEN, (String)KEYS_END_TOKEN);
        if (existing != null) {
            if ((existing = existing.trim()).equals(changed = changed.trim())) {
                return false;
            }
            String before = Strings.before((String)text, (String)KEYS_START_TOKEN);
            String after = Strings.after((String)text, (String)KEYS_END_TOKEN);
            text = before + "// SENSITIVE-KEYS: START\n" + spaces20 + changed + "\n" + spaces12 + KEYS_END_TOKEN + after;
            PackageHelper.writeText((File)java, (String)text);
            return true;
        }
        return false;
    }

    private boolean updateSensitiveHelperPatterns(File camelDir, Set<String> secrets) throws Exception {
        File java = new File(camelDir, "src/main/java/org/apache/camel/util/SensitiveUtils.java");
        Object text = PackageHelper.loadText((File)java);
        String spaces52 = "                                                    ";
        StringJoiner sb = new StringJoiner("\n");
        boolean first = true;
        for (String name : secrets) {
            StringBuilder line = new StringBuilder(name.length() + 32);
            line.append(spaces52);
            line.append("+ \"");
            if (!first) {
                line.append("|");
            }
            line.append("\\\\Q");
            line.append(name);
            line.append("\\\\E\"");
            sb.add(line);
            first = false;
        }
        String changed = sb.toString();
        String existing = Strings.between((String)text, (String)PATTERN_START_TOKEN, (String)PATTERN_END_TOKEN);
        if (existing != null) {
            if ((existing = existing.trim()).equals(changed = changed.trim())) {
                return false;
            }
            String before = Strings.before((String)text, (String)PATTERN_START_TOKEN);
            String after = Strings.after((String)text, (String)PATTERN_END_TOKEN);
            text = before + "// SENSITIVE-PATTERN: START\n" + spaces52 + changed + "\n" + spaces52 + PATTERN_END_TOKEN + after;
            PackageHelper.writeText((File)java, (String)text);
            return true;
        }
        return false;
    }

    private void updateSensitiveJsonSchema(File camelDir, Set<String> secrets) throws Exception {
        File target = new File(camelDir, "src/generated/resources/org/apache/camel/catalog/main/sensitive-keys.json");
        JsonArray arr = new JsonArray();
        arr.addAll(secrets);
        String json = JsonMapper.serialize((Object)arr);
        PackageHelper.writeText((File)target, (String)json);
    }
}

