/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.paho.mqtt5;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class PahoMqtt5EndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":topic";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "paho-mqtt5".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "topic", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(33);
        props.add("automaticReconnect");
        props.add("bridgeErrorHandler");
        props.add("brokerUrl");
        props.add("cleanStart");
        props.add("client");
        props.add("clientId");
        props.add("connectionTimeout");
        props.add("customWebSocketHeaders");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("executorServiceTimeout");
        props.add("filePersistenceDirectory");
        props.add("httpsHostnameVerificationEnabled");
        props.add("keepAliveInterval");
        props.add("lazyStartProducer");
        props.add("maxReconnectDelay");
        props.add("password");
        props.add("persistence");
        props.add("qos");
        props.add("receiveMaximum");
        props.add("retained");
        props.add("serverURIs");
        props.add("sessionExpiryInterval");
        props.add("socketFactory");
        props.add("sslClientProps");
        props.add("sslHostnameVerifier");
        props.add("topic");
        props.add("userName");
        props.add("willMqttProperties");
        props.add("willPayload");
        props.add("willQos");
        props.add("willRetained");
        props.add("willTopic");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("password");
        secretProps.add("userName");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

