/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.paho;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.paho.PahoEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PahoConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(PahoConsumer.class);

    public PahoConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    protected void doStart() throws Exception {
        super.doStart();
        final String topic = this.getEndpoint().getTopic();
        this.getEndpoint().getClient().subscribe(topic, this.getEndpoint().getQos());
        this.getEndpoint().getClient().setCallback((MqttCallback)new MqttCallbackExtended(){

            public void connectComplete(boolean reconnect, String serverURI) {
                if (reconnect) {
                    try {
                        PahoConsumer.this.getEndpoint().getClient().subscribe(topic, PahoConsumer.this.getEndpoint().getQos());
                    }
                    catch (MqttException e) {
                        LOG.error("MQTT resubscribe failed {}", (Object)e.getMessage(), (Object)e);
                    }
                }
            }

            public void connectionLost(Throwable cause) {
                LOG.debug("MQTT broker connection lost due {}", (Object)cause.getMessage(), (Object)cause);
            }

            public void messageArrived(String topic2, MqttMessage message) throws Exception {
                LOG.debug("Message arrived on topic: {} -> {}", (Object)topic2, (Object)message);
                Exchange exchange = PahoConsumer.this.getEndpoint().createExchange(message, topic2);
                PahoConsumer.this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                    public void done(boolean doneSync) {
                    }
                });
            }

            public void deliveryComplete(IMqttDeliveryToken token) {
                LOG.debug("Delivery complete. Token: {}", (Object)token);
            }
        });
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.getEndpoint().getClient().isConnected() && this.getEndpoint().getConnectOptions().isCleanSession()) {
            String topic = this.getEndpoint().getTopic();
            this.getEndpoint().getClient().unsubscribe(topic);
        }
    }

    public PahoEndpoint getEndpoint() {
        return (PahoEndpoint)super.getEndpoint();
    }
}

