/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.paho;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.paho.PahoEndpoint;
import org.apache.camel.component.paho.PahoMessage;
import org.apache.camel.support.DefaultConsumer;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PahoConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(PahoConsumer.class);
    private volatile MqttClient client;
    private volatile String clientId;
    private volatile boolean stopClient;
    private volatile MqttConnectOptions connectOptions;

    public PahoConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    public MqttClient getClient() {
        return this.client;
    }

    public void setClient(MqttClient client) {
        this.client = client;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.connectOptions = PahoEndpoint.createMqttConnectOptions(this.getEndpoint().getConfiguration());
        if (this.client == null) {
            this.clientId = this.getEndpoint().getConfiguration().getClientId();
            if (this.clientId == null) {
                this.clientId = "camel-" + MqttClient.generateClientId();
            }
            this.stopClient = true;
            this.client = new MqttClient(this.getEndpoint().getConfiguration().getBrokerUrl(), this.clientId, PahoEndpoint.createMqttClientPersistence(this.getEndpoint().getConfiguration()));
            LOG.debug("Connecting client: {} to broker: {}", (Object)this.clientId, (Object)this.getEndpoint().getConfiguration().getBrokerUrl());
            this.client.connect(this.connectOptions);
        }
        this.client.setCallback((MqttCallback)new MqttCallbackExtended(){

            public void connectComplete(boolean reconnect, String serverURI) {
                if (reconnect) {
                    try {
                        PahoConsumer.this.client.subscribe(PahoConsumer.this.getEndpoint().getTopic(), PahoConsumer.this.getEndpoint().getConfiguration().getQos());
                    }
                    catch (MqttException e) {
                        LOG.error("MQTT resubscribe failed {}", (Object)e.getMessage(), (Object)e);
                    }
                }
            }

            public void connectionLost(Throwable cause) {
                LOG.debug("MQTT broker connection lost due {}", (Object)cause.getMessage(), (Object)cause);
            }

            public void messageArrived(String topic, MqttMessage message) throws Exception {
                LOG.debug("Message arrived on topic: {} -> {}", (Object)topic, (Object)message);
                Exchange exchange = PahoConsumer.this.createExchange(message, topic);
                AsyncCallback cb = PahoConsumer.this.defaultConsumerCallback(exchange, true);
                PahoConsumer.this.getAsyncProcessor().process(exchange, cb);
            }

            public void deliveryComplete(IMqttDeliveryToken token) {
                LOG.debug("Delivery complete. Token: {}", (Object)token);
            }
        });
        LOG.debug("Subscribing client: {} to topic: {}", (Object)this.clientId, (Object)this.getEndpoint().getTopic());
        this.client.subscribe(this.getEndpoint().getTopic(), this.getEndpoint().getConfiguration().getQos());
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.stopClient && this.client != null && this.client.isConnected()) {
            String topic = this.getEndpoint().getTopic();
            if (this.getEndpoint().getConfiguration().isCleanSession()) {
                LOG.debug("Unsubscribing client: {} from topic: {}", (Object)this.clientId, (Object)topic);
                this.client.unsubscribe(topic);
            } else {
                LOG.debug("Client: {} is durable so will not unsubscribe from topic: {}", (Object)this.clientId, (Object)topic);
            }
            LOG.debug("Disconnecting client: {} from broker: {}", (Object)this.clientId, (Object)this.getEndpoint().getConfiguration().getBrokerUrl());
            this.client.disconnect();
        }
        this.client = null;
    }

    public PahoEndpoint getEndpoint() {
        return (PahoEndpoint)super.getEndpoint();
    }

    public Exchange createExchange(MqttMessage mqttMessage, String topic) {
        Exchange exchange = this.createExchange(true);
        PahoMessage paho = new PahoMessage(exchange.getContext(), mqttMessage);
        paho.setBody(mqttMessage.getPayload());
        paho.setHeader("CamelMqttTopic", topic);
        paho.setHeader("CamelMqttQoS", mqttMessage.getQos());
        exchange.setIn((Message)paho);
        return exchange;
    }
}

