/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.parquet.avro;

import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.reflect.ReflectData;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.parquet.avro.ParquetInputStream;
import org.apache.camel.dataformat.parquet.avro.ParquetOutputStream;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.DefaultUuidGenerator;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.OutputFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dataformat(value="parquetAvro")
public class ParquetAvroDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetAvroDataFormat.class);
    private static final DefaultUuidGenerator DEFAULT_UUID_GENERATOR = new DefaultUuidGenerator();
    private CompressionCodecName compressionCodecName = CompressionCodecName.GZIP;
    private Class<?> unmarshalType;

    public String getDataFormatName() {
        return "parquetAvro";
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        Configuration conf = new Configuration();
        FileSystem.get((Configuration)conf).setWriteChecksum(false);
        BufferedOutputStream parquetOutput = new BufferedOutputStream(stream);
        ParquetOutputStream parquetOutputStream = new ParquetOutputStream(DEFAULT_UUID_GENERATOR.generateUuid(), parquetOutput);
        List list = (List)graph;
        Schema schema = null;
        ReflectData model = null;
        if (this.unmarshalType != null) {
            try {
                schema = ReflectData.AllowNull.get().getSchema(this.unmarshalType);
                model = ReflectData.get();
            }
            catch (AvroRuntimeException e) {
                LOG.warn("Fall back to use GenericRecord instead of POJO for marshalling", (Throwable)e);
            }
        }
        if (schema == null) {
            schema = ((GenericContainer)GenericContainer.class.cast(list.get(0))).getSchema();
            model = GenericData.get();
        }
        try (ParquetWriter writer = ((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)AvroParquetWriter.builder((OutputFile)parquetOutputStream).withSchema(schema).withDataModel((GenericData)model).withConf(conf)).withCompressionCodec(this.compressionCodecName)).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).build();){
            for (Object grapElem : list) {
                writer.write(grapElem);
            }
        }
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        ArrayList parquetObjects = new ArrayList();
        Configuration conf = new Configuration();
        ParquetInputStream parquetInputStream = new ParquetInputStream(DEFAULT_UUID_GENERATOR.generateUuid(), stream.readAllBytes());
        Class type = GenericRecord.class;
        GenericData model = GenericData.get();
        if (this.unmarshalType != null) {
            type = this.unmarshalType;
            model = new ReflectData(this.unmarshalType.getClassLoader());
        }
        try (ParquetReader reader = AvroParquetReader.builder((InputFile)parquetInputStream).withDataModel(model).disableCompatibility().withConf(conf).build();){
            Object pojo;
            while ((pojo = type.cast(reader.read())) != null) {
                parquetObjects.add(pojo);
            }
        }
        return parquetObjects;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    public String getCompressionCodecName() {
        return this.compressionCodecName.name();
    }

    public void setCompressionCodecName(String compressionCodecName) {
        this.compressionCodecName = CompressionCodecName.valueOf((String)compressionCodecName);
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }
}

