/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.parquet.avro;

import java.io.BufferedOutputStream;
import java.io.IOException;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.PositionOutputStream;

public class ParquetOutputStream
implements OutputFile {
    private final String streamId;
    private final BufferedOutputStream out;
    private int pos = 0;

    public ParquetOutputStream(String streamId, BufferedOutputStream out) {
        this.streamId = streamId;
        this.out = out;
    }

    public PositionOutputStream create(long blockSizeHint) throws IOException {
        return this.createPositionOutputstream();
    }

    private PositionOutputStream createPositionOutputstream() {
        return new PositionOutputStream(){

            public long getPos() throws IOException {
                return ParquetOutputStream.this.pos;
            }

            public void flush() throws IOException {
                ParquetOutputStream.this.out.flush();
            }

            public void close() throws IOException {
                ParquetOutputStream.this.out.close();
            }

            public void write(int b) throws IOException {
                ParquetOutputStream.this.out.write(b);
                ++ParquetOutputStream.this.pos;
            }

            public void write(byte[] b, int off, int len) throws IOException {
                ParquetOutputStream.this.out.write(b, off, len);
                ParquetOutputStream.this.pos += len;
            }
        };
    }

    public PositionOutputStream createOrOverwrite(long blockSizeHint) throws IOException {
        return this.createPositionOutputstream();
    }

    public boolean supportsBlockSize() {
        return false;
    }

    public long defaultBlockSize() {
        return 0L;
    }

    public String toString() {
        return "ParquetOutputStream[" + this.streamId + "]";
    }
}

