/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pdf.text;

import java.io.IOException;
import java.util.Collection;
import org.apache.camel.component.pdf.PdfConfiguration;
import org.apache.camel.component.pdf.text.PdfUtils;
import org.apache.camel.component.pdf.text.WriteStrategy;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;

public class DefaultWriteStrategy
implements WriteStrategy {
    private final PdfConfiguration pdfConfiguration;

    public DefaultWriteStrategy(PdfConfiguration pdfConfiguration) {
        this.pdfConfiguration = pdfConfiguration;
    }

    @Override
    public PDDocument write(Collection<String> lines, PDDocument document) throws IOException {
        PDPage page = new PDPage(this.pdfConfiguration.getPageSize());
        document.addPage(page);
        float x = this.pdfConfiguration.getMarginLeft();
        float y = page.getMediaBox().getHeight() - (float)this.pdfConfiguration.getMarginTop();
        float averageFontHeight = PdfUtils.getAverageFontHeight(this.pdfConfiguration.getFont(), this.pdfConfiguration.getFontSize());
        float lineSpacing = averageFontHeight * 2.0f;
        PDPageContentStream contentStream = this.initializeContentStream(document, page);
        for (String line : lines) {
            this.writeLine(x, y, line, contentStream);
            if (!this.goToNextPage(y -= lineSpacing)) continue;
            contentStream.close();
            page = new PDPage(this.pdfConfiguration.getPageSize());
            document.addPage(page);
            contentStream = this.initializeContentStream(document, page);
            y = page.getMediaBox().getHeight() - (float)this.pdfConfiguration.getMarginTop();
        }
        contentStream.close();
        return document;
    }

    private boolean goToNextPage(float y) {
        return y < (float)this.pdfConfiguration.getMarginBottom();
    }

    private void writeLine(float x, float y, String currentLine, PDPageContentStream contentStream) throws IOException {
        contentStream.beginText();
        contentStream.moveTextPositionByAmount(x, y);
        contentStream.drawString(currentLine);
        contentStream.endText();
    }

    private PDPageContentStream initializeContentStream(PDDocument document, PDPage page) throws IOException {
        PDPageContentStream contentStream = new PDPageContentStream(document, page);
        contentStream.setFont(this.pdfConfiguration.getFont(), this.pdfConfiguration.getFontSize());
        return contentStream;
    }
}

