/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pdf;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.component.pdf.PdfConfiguration;
import org.apache.camel.component.pdf.PdfEndpoint;
import org.apache.camel.component.pdf.PdfOperation;
import org.apache.camel.component.pdf.TextProcessingFactory;
import org.apache.camel.component.pdf.text.AutoFormattedWriterAbstractFactory;
import org.apache.camel.component.pdf.text.LineBuilderStrategy;
import org.apache.camel.component.pdf.text.LineTerminationWriterAbstractFactory;
import org.apache.camel.component.pdf.text.SplitStrategy;
import org.apache.camel.component.pdf.text.TextProcessingAbstractFactory;
import org.apache.camel.component.pdf.text.WriteStrategy;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.pdfbox.io.RandomAccessStreamCacheImpl;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.StandardProtectionPolicy;
import org.apache.pdfbox.text.PDFTextStripper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(PdfProducer.class);
    private final WriteStrategy writeStrategy;
    private final SplitStrategy splitStrategy;
    private final LineBuilderStrategy lineBuilderStrategy;
    private final PdfConfiguration pdfConfiguration;

    public PdfProducer(PdfEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.pdfConfiguration = endpoint.getPdfConfiguration();
        TextProcessingAbstractFactory textProcessingFactory = this.createTextProcessingFactory(this.pdfConfiguration);
        this.writeStrategy = textProcessingFactory.createWriteStrategy();
        this.splitStrategy = textProcessingFactory.createSplitStrategy();
        this.lineBuilderStrategy = textProcessingFactory.createLineBuilderStrategy();
    }

    public void process(Exchange exchange) throws Exception {
        Object result = switch (this.pdfConfiguration.getOperation()) {
            case PdfOperation.append -> this.doAppend(exchange);
            case PdfOperation.create -> this.doCreate(exchange);
            case PdfOperation.extractText -> this.doExtractText(exchange);
            case PdfOperation.merge -> this.doMerge(exchange);
            default -> throw new IllegalArgumentException(String.format("Unknown operation %s", new Object[]{this.pdfConfiguration.getOperation()}));
        };
        exchange.getMessage().setHeaders(exchange.getIn().getHeaders());
        exchange.getMessage().setBody(result);
    }

    private OutputStream doMerge(Exchange exchange) throws IOException, NoSuchHeaderException {
        LOG.debug("Got {} operation, going to merge multiple files into a single pdf document.", (Object)this.pdfConfiguration.getOperation());
        PDFMergerUtility mergerUtility = new PDFMergerUtility();
        List files = (List)ExchangeHelper.getMandatoryHeader((Exchange)exchange, (String)"files-to-merge", List.class);
        if (files.size() < 2) {
            throw new IllegalArgumentException("Must provide at least 2 files to merge");
        }
        for (File file : files) {
            mergerUtility.addSource(file);
        }
        mergerUtility.setDestinationStream((OutputStream)new ByteArrayOutputStream());
        mergerUtility.mergeDocuments(RandomAccessStreamCacheImpl::new);
        return mergerUtility.getDestinationStream();
    }

    private Object doAppend(Exchange exchange) throws IOException {
        LOG.debug("Got {} operation, going to append text to provided pdf.", (Object)this.pdfConfiguration.getOperation());
        String body = (String)exchange.getIn().getBody(String.class);
        try (PDDocument document = (PDDocument)exchange.getIn().getHeader("pdf-document", PDDocument.class);){
            if (document == null) {
                throw new IllegalArgumentException(String.format("%s header is expected for append operation", "pdf-document"));
            }
            if (document.isEncrypted()) {
                document.setAllSecurityToBeRemoved(true);
            }
            ProtectionPolicy protectionPolicy = (ProtectionPolicy)exchange.getIn().getHeader("protection-policy", ProtectionPolicy.class);
            this.appendToPdfDocument(body, document, protectionPolicy);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            document.save((OutputStream)byteArrayOutputStream);
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            return byteArrayOutputStream2;
        }
    }

    private String doExtractText(Exchange exchange) throws IOException {
        LOG.debug("Got {} operation, going to extract text from provided pdf.", (Object)this.pdfConfiguration.getOperation());
        try (PDDocument document = (PDDocument)exchange.getIn().getBody(PDDocument.class);){
            PDFTextStripper pdfTextStripper = new PDFTextStripper();
            String string = pdfTextStripper.getText(document);
            return string;
        }
    }

    private OutputStream doCreate(Exchange exchange) throws IOException {
        LOG.debug("Got {} operation, going to create and write provided string to pdf document.", (Object)this.pdfConfiguration.getOperation());
        String body = (String)exchange.getIn().getBody(String.class);
        try (PDDocument document = new PDDocument();){
            StandardProtectionPolicy protectionPolicy = (StandardProtectionPolicy)exchange.getIn().getHeader("protection-policy", StandardProtectionPolicy.class);
            this.appendToPdfDocument(body, document, (ProtectionPolicy)protectionPolicy);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            document.save((OutputStream)byteArrayOutputStream);
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            return byteArrayOutputStream2;
        }
    }

    private void appendToPdfDocument(String text, PDDocument document, ProtectionPolicy protectionPolicy) throws IOException {
        Collection<String> words = this.splitStrategy.split(text);
        Collection<String> lines = this.lineBuilderStrategy.buildLines(words);
        this.writeStrategy.write(lines, document);
        if (protectionPolicy != null) {
            document.protect(protectionPolicy);
        }
    }

    private TextProcessingAbstractFactory createTextProcessingFactory(PdfConfiguration pdfConfiguration) {
        return switch (pdfConfiguration.getTextProcessingFactory()) {
            case TextProcessingFactory.autoFormatting -> new AutoFormattedWriterAbstractFactory(pdfConfiguration);
            case TextProcessingFactory.lineTermination -> new LineTerminationWriterAbstractFactory(pdfConfiguration);
            default -> throw new IllegalArgumentException(String.format("Unknown text processing factory %s", new Object[]{pdfConfiguration.getTextProcessingFactory()}));
        };
    }
}

