/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.plugin;

import io.netty.buffer.ByteBufInputStream;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.impl.Arguments;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.management.RuntimeMBeanException;
import org.apache.camel.CamelContext;
import org.apache.camel.component.platform.http.plugin.JolokiaPlatformHttpPlugin;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.service.ServiceSupport;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.config.Configuration;
import org.jolokia.server.core.config.StaticConfiguration;
import org.jolokia.server.core.http.HttpRequestHandler;
import org.jolokia.server.core.restrictor.AllowAllRestrictor;
import org.jolokia.server.core.restrictor.DenyAllRestrictor;
import org.jolokia.server.core.restrictor.RestrictorFactory;
import org.jolokia.server.core.restrictor.policy.PolicyRestrictor;
import org.jolokia.server.core.service.JolokiaServiceManagerFactory;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.api.JolokiaService;
import org.jolokia.server.core.service.api.JolokiaServiceManager;
import org.jolokia.server.core.service.api.LogHandler;
import org.jolokia.server.core.service.api.Restrictor;
import org.jolokia.server.core.util.NetworkUtil;
import org.jolokia.service.jmx.LocalRequestHandler;
import org.jolokia.service.serializer.JolokiaSerializer;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdkService(value="platform-http/jolokia")
public class DefaultJolokiaPlatformHttpPlugin
extends ServiceSupport
implements JolokiaPlatformHttpPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJolokiaPlatformHttpPlugin.class);
    private CamelContext camelContext;
    private final JolokiaServiceManager serviceManager;
    private final LogHandler jolokiaLogHandler;
    private HttpRequestHandler requestHandler;
    private Handler<RoutingContext> handler;

    public DefaultJolokiaPlatformHttpPlugin() {
        StaticConfiguration config = new StaticConfiguration(new Object[]{ConfigKey.AGENT_ID, NetworkUtil.getAgentId((int)((Object)((Object)this)).hashCode(), (String)"vertx")});
        this.jolokiaLogHandler = new JolokiaLogHandler(LOG);
        Restrictor restrictor = this.createRestrictor(NetworkUtil.replaceExpression((String)config.getConfig(ConfigKey.POLICY_LOCATION)));
        this.serviceManager = JolokiaServiceManagerFactory.createJolokiaServiceManager((Configuration)config, (LogHandler)this.jolokiaLogHandler, (Restrictor)restrictor);
        this.serviceManager.addService((JolokiaService)new JolokiaSerializer());
        this.serviceManager.addService((JolokiaService)new LocalRequestHandler(1));
        LOG.info("Creating DefaultJolokiaPlatformHttpPlugin with Restrictor: {}", (Object)restrictor);
    }

    public void doStart() {
        JolokiaContext jolokiaContext = this.serviceManager.start();
        this.requestHandler = new HttpRequestHandler(jolokiaContext);
        this.handler = this.createVertxHandler();
    }

    public void doStop() {
        if (this.serviceManager != null) {
            this.serviceManager.stop();
        }
    }

    public Object getHandler() {
        return this.handler;
    }

    public HttpRequestHandler getJolokiaRequestHandler() {
        return this.requestHandler;
    }

    private Restrictor createRestrictor(String pLocation) {
        try {
            PolicyRestrictor restrictor = RestrictorFactory.lookupPolicyRestrictor((String)pLocation);
            if (restrictor != null) {
                this.jolokiaLogHandler.info("Using access restrictor: " + pLocation);
                return restrictor;
            }
            this.jolokiaLogHandler.info("No access restrictor found at: " + pLocation + ", access to all MBeans is allowed");
            return new AllowAllRestrictor();
        }
        catch (IOException e) {
            this.jolokiaLogHandler.error("Error while accessing access restrictor: at " + pLocation + ". Denying all access to MBeans for security reasons. Exception: " + String.valueOf(e), (Throwable)e);
            return new DenyAllRestrictor();
        }
    }

    public String getId() {
        return "jolokia";
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    private Handler<RoutingContext> createVertxHandler() {
        return routingContext -> {
            JSONObject json;
            block7: {
                HttpServerRequest req = routingContext.request();
                String remainingPath = Utils.pathOffset((String)req.path(), (RoutingContext)routingContext);
                json = null;
                try {
                    this.requestHandler.checkAccess(req.scheme(), req.remoteAddress().host(), req.remoteAddress().host(), this.getOriginOrReferer(req));
                    if (req.method() == HttpMethod.GET) {
                        json = this.requestHandler.handleGetRequest(req.uri(), remainingPath, this.getParams(req.params()));
                    } else {
                        Arguments.require((routingContext.body() != null ? 1 : 0) != 0, (String)"Missing body");
                        ByteBufInputStream inputStream = new ByteBufInputStream(routingContext.body().buffer().getByteBuf());
                        json = this.requestHandler.handlePostRequest(req.uri(), (InputStream)inputStream, StandardCharsets.UTF_8.name(), this.getParams(req.params()));
                    }
                    if (json != null) break block7;
                }
                catch (Throwable exp) {
                    block8: {
                        try {
                            json = this.requestHandler.handleThrowable(exp instanceof RuntimeMBeanException ? ((RuntimeMBeanException)exp).getTargetException() : exp);
                            if (json != null) break block8;
                        }
                        catch (Throwable throwable) {
                            if (json == null) {
                                json = this.requestHandler.handleThrowable((Throwable)new Exception("Internal error while handling an exception"));
                            }
                            routingContext.response().setStatusCode(this.getStatusCode((JSONAware)json)).putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").end(json.toJSONString());
                            throw throwable;
                        }
                        json = this.requestHandler.handleThrowable((Throwable)new Exception("Internal error while handling an exception"));
                    }
                    routingContext.response().setStatusCode(this.getStatusCode((JSONAware)json)).putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").end(json.toJSONString());
                }
                json = this.requestHandler.handleThrowable((Throwable)new Exception("Internal error while handling an exception"));
            }
            routingContext.response().setStatusCode(this.getStatusCode((JSONAware)json)).putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").end(json.toJSONString());
        };
    }

    private Map<String, String[]> getParams(MultiMap params) {
        HashMap<String, String[]> response = new HashMap<String, String[]>();
        for (String name : params.names()) {
            response.put(name, params.getAll(name).toArray(new String[0]));
        }
        return response;
    }

    private String getOriginOrReferer(HttpServerRequest req) {
        String origin = req.getHeader(HttpHeaders.ORIGIN);
        if (origin == null) {
            origin = req.getHeader(HttpHeaders.REFERER);
        }
        return origin != null ? origin.replaceAll("[\\n\\r]*", "") : null;
    }

    private int getStatusCode(JSONAware json) {
        if (json instanceof JSONObject && ((JSONObject)json).get((Object)"status") instanceof Integer) {
            return (Integer)((JSONObject)json).get((Object)"status");
        }
        return 200;
    }

    private record JolokiaLogHandler(Logger log) implements LogHandler
    {
        public void debug(String message) {
            this.log.debug(message);
        }

        public void info(String message) {
            this.log.info(message);
        }

        public void error(String message, Throwable t) {
            this.log.error(message, t);
        }

        public boolean isDebug() {
            return this.log.isDebugEnabled();
        }
    }
}

