/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.plugin;

import io.netty.buffer.ByteBufInputStream;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.impl.Arguments;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.management.RuntimeMBeanException;
import org.apache.camel.CamelContext;
import org.apache.camel.component.platform.http.plugin.JolokiaPlatformHttpPlugin;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ReflectionHelper;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.config.Configuration;
import org.jolokia.server.core.config.StaticConfiguration;
import org.jolokia.server.core.http.HttpRequestHandler;
import org.jolokia.server.core.restrictor.AllowAllRestrictor;
import org.jolokia.server.core.restrictor.DenyAllRestrictor;
import org.jolokia.server.core.restrictor.RestrictorFactory;
import org.jolokia.server.core.restrictor.policy.PolicyRestrictor;
import org.jolokia.server.core.service.JolokiaServiceManagerFactory;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.api.JolokiaService;
import org.jolokia.server.core.service.api.JolokiaServiceManager;
import org.jolokia.server.core.service.api.LogHandler;
import org.jolokia.server.core.service.api.Restrictor;
import org.jolokia.server.core.util.NetworkUtil;
import org.jolokia.service.jmx.LocalRequestHandler;
import org.jolokia.service.serializer.JolokiaSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdkService(value="platform-http/jolokia")
public class DefaultJolokiaPlatformHttpPlugin
extends ServiceSupport
implements JolokiaPlatformHttpPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJolokiaPlatformHttpPlugin.class);
    private CamelContext camelContext;
    private final JolokiaServiceManager serviceManager;
    private final LogHandler jolokiaLogHandler;
    private HttpRequestHandler requestHandler;
    private Handler<RoutingContext> handler;

    public DefaultJolokiaPlatformHttpPlugin() {
        StaticConfiguration config = new StaticConfiguration(new Object[]{ConfigKey.AGENT_ID, NetworkUtil.getAgentId((int)((Object)((Object)this)).hashCode(), (String)"vertx")});
        this.jolokiaLogHandler = new JolokiaLogHandler(LOG);
        Restrictor restrictor = this.createRestrictor(NetworkUtil.replaceExpression((String)config.getConfig(ConfigKey.POLICY_LOCATION)));
        this.serviceManager = JolokiaServiceManagerFactory.createJolokiaServiceManager((Configuration)config, (LogHandler)this.jolokiaLogHandler, (Restrictor)restrictor);
        this.serviceManager.addService((JolokiaService)new JolokiaSerializer());
        this.serviceManager.addService((JolokiaService)new LocalRequestHandler(1));
        LOG.info("Creating DefaultJolokiaPlatformHttpPlugin with Restrictor: {}", (Object)restrictor);
    }

    public void doStart() {
        JolokiaContext jolokiaContext = this.serviceManager.start();
        this.requestHandler = new HttpRequestHandler(jolokiaContext);
        this.handler = this.createVertxHandler();
    }

    public void doStop() {
        if (this.serviceManager != null) {
            this.serviceManager.stop();
        }
    }

    public Object getHandler() {
        return this.handler;
    }

    public HttpRequestHandler getJolokiaRequestHandler() {
        return this.requestHandler;
    }

    private Restrictor createRestrictor(String pLocation) {
        try {
            PolicyRestrictor restrictor = RestrictorFactory.lookupPolicyRestrictor((String)pLocation);
            if (restrictor != null) {
                this.jolokiaLogHandler.info("Using access restrictor: " + pLocation);
                return restrictor;
            }
            this.jolokiaLogHandler.info("No access restrictor found at: " + pLocation + ", access to all MBeans is allowed");
            return new AllowAllRestrictor();
        }
        catch (IOException e) {
            this.jolokiaLogHandler.error("Error while accessing access restrictor: at " + pLocation + ". Denying all access to MBeans for security reasons. Exception: " + String.valueOf(e), (Throwable)e);
            return new DenyAllRestrictor();
        }
    }

    public String getId() {
        return "jolokia";
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    private Handler<RoutingContext> createVertxHandler() {
        return routingContext -> {
            block23: {
                int status;
                Object json;
                block21: {
                    Method m;
                    HttpServerRequest req = routingContext.request();
                    String remainingPath = Utils.pathOffset((String)req.path(), (RoutingContext)routingContext);
                    json = null;
                    status = 200;
                    ObjectHelper.invokeMethodSafe((String)"checkAccess", (Object)this.requestHandler, (Object[])new Object[]{req.scheme(), req.remoteAddress().host(), req.remoteAddress().host(), this.getOriginOrReferer(req)});
                    if (req.method() == HttpMethod.GET) {
                        m = ReflectionHelper.findMethod(this.requestHandler.getClass(), (String)"handleGetRequest", (Class[])new Class[]{String.class, String.class, Map.class});
                        if (m != null) {
                            json = ObjectHelper.invokeMethodSafe((Method)m, (Object)this.requestHandler, (Object[])new Object[]{req.uri(), remainingPath, this.getParams(req.params())});
                        }
                    } else {
                        Arguments.require((routingContext.body() != null ? 1 : 0) != 0, (String)"Missing body");
                        ByteBufInputStream inputStream = new ByteBufInputStream(routingContext.body().buffer().getByteBuf());
                        Method m2 = ReflectionHelper.findMethod(this.requestHandler.getClass(), (String)"handlePostRequest", (Class[])new Class[]{String.class, InputStream.class, String.class, Map.class});
                        if (m2 != null) {
                            json = ObjectHelper.invokeMethodSafe((Method)m2, (Object)this.requestHandler, (Object[])new Object[]{req.uri(), inputStream, StandardCharsets.UTF_8.name(), this.getParams(req.params())});
                        }
                    }
                    if (json != null) break block21;
                    try {
                        m = ReflectionHelper.findMethod(this.requestHandler.getClass(), (String)"handleThrowable", (Class[])new Class[]{Throwable.class});
                        if (m != null) {
                            json = ObjectHelper.invokeMethodSafe((Method)m, (Object)this.requestHandler, (Object[])new Object[]{new Exception("Internal error while handling an exception")});
                        }
                    }
                    catch (Exception m3) {
                        // empty catch block
                    }
                }
                String data = json != null ? json.toString() : "";
                routingContext.response().setStatusCode(status).putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").end(data);
                break block23;
                catch (Throwable exp) {
                    block22: {
                        try {
                            status = 500;
                            try {
                                Method m = ReflectionHelper.findMethod(this.requestHandler.getClass(), (String)"handleThrowable", (Class[])new Class[]{Throwable.class});
                                if (m != null) {
                                    json = ObjectHelper.invokeMethodSafe((Method)m, (Object)this.requestHandler, (Object[])new Object[]{exp instanceof RuntimeMBeanException ? ((RuntimeMBeanException)exp).getTargetException() : exp});
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (json != null) break block22;
                        }
                        catch (Throwable throwable) {
                            if (json == null) {
                                try {
                                    Method m = ReflectionHelper.findMethod(this.requestHandler.getClass(), (String)"handleThrowable", (Class[])new Class[]{Throwable.class});
                                    if (m != null) {
                                        json = ObjectHelper.invokeMethodSafe((Method)m, (Object)this.requestHandler, (Object[])new Object[]{new Exception("Internal error while handling an exception")});
                                    }
                                }
                                catch (Exception m) {
                                    // empty catch block
                                }
                            }
                            String data2 = json != null ? json.toString() : "";
                            routingContext.response().setStatusCode(status).putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").end(data2);
                            throw throwable;
                        }
                        try {
                            Method m = ReflectionHelper.findMethod(this.requestHandler.getClass(), (String)"handleThrowable", (Class[])new Class[]{Throwable.class});
                            if (m != null) {
                                json = ObjectHelper.invokeMethodSafe((Method)m, (Object)this.requestHandler, (Object[])new Object[]{new Exception("Internal error while handling an exception")});
                            }
                        }
                        catch (Exception m) {
                            // empty catch block
                        }
                    }
                    data = json != null ? json.toString() : "";
                    routingContext.response().setStatusCode(status).putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").end(data);
                }
            }
        };
    }

    private Map<String, String[]> getParams(MultiMap params) {
        HashMap<String, String[]> response = new HashMap<String, String[]>();
        for (String name : params.names()) {
            response.put(name, params.getAll(name).toArray(new String[0]));
        }
        return response;
    }

    private String getOriginOrReferer(HttpServerRequest req) {
        String origin = req.getHeader(HttpHeaders.ORIGIN);
        if (origin == null) {
            origin = req.getHeader(HttpHeaders.REFERER);
        }
        return origin != null ? origin.replaceAll("[\\n\\r]*", "") : "";
    }

    private record JolokiaLogHandler(Logger log) implements LogHandler
    {
        public void debug(String message) {
            this.log.debug(message);
        }

        public void info(String message) {
            this.log.info(message);
        }

        public void error(String message, Throwable t) {
            this.log.error(message, t);
        }

        public boolean isDebug() {
            return this.log.isDebugEnabled();
        }
    }
}

