/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.main.jolokia;

import java.io.IOException;
import org.apache.camel.StaticService;
import org.apache.camel.support.service.ServiceSupport;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.config.Configuration;
import org.jolokia.server.core.config.StaticConfiguration;
import org.jolokia.server.core.http.HttpRequestHandler;
import org.jolokia.server.core.restrictor.AllowAllRestrictor;
import org.jolokia.server.core.restrictor.DenyAllRestrictor;
import org.jolokia.server.core.restrictor.RestrictorFactory;
import org.jolokia.server.core.restrictor.policy.PolicyRestrictor;
import org.jolokia.server.core.service.JolokiaServiceManagerFactory;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.api.JolokiaService;
import org.jolokia.server.core.service.api.JolokiaServiceManager;
import org.jolokia.server.core.service.api.LogHandler;
import org.jolokia.server.core.service.api.Restrictor;
import org.jolokia.server.core.util.NetworkUtil;
import org.jolokia.service.jmx.LocalRequestHandler;
import org.jolokia.service.serializer.JolokiaSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JolokiaHttpRequestHandlerSupport
extends ServiceSupport
implements StaticService {
    private static final Logger LOG = LoggerFactory.getLogger(JolokiaHttpRequestHandlerSupport.class);
    private final JolokiaServiceManager serviceManager;
    private HttpRequestHandler requestHandler;
    private final LogHandler jolokiaLogHandler;

    public JolokiaHttpRequestHandlerSupport() {
        StaticConfiguration config = new StaticConfiguration(new Object[]{ConfigKey.AGENT_ID, NetworkUtil.getAgentId((int)((Object)((Object)this)).hashCode(), (String)"vertx")});
        this.jolokiaLogHandler = new JolokiaLogHandler(LOG);
        Restrictor restrictor = this.createRestrictor(NetworkUtil.replaceExpression((String)config.getConfig(ConfigKey.POLICY_LOCATION)));
        this.serviceManager = JolokiaServiceManagerFactory.createJolokiaServiceManager((Configuration)config, (LogHandler)this.jolokiaLogHandler, (Restrictor)restrictor);
        this.serviceManager.addService((JolokiaService)new JolokiaSerializer());
        this.serviceManager.addService((JolokiaService)new LocalRequestHandler(1));
        LOG.info("Creating JolokiaHttpRequestHandlerSupport with restrictor {}", (Object)restrictor);
    }

    public void start() {
        JolokiaContext jolokiaContext = this.serviceManager.start();
        this.requestHandler = new HttpRequestHandler(jolokiaContext);
    }

    public void stop() {
        this.serviceManager.stop();
    }

    public HttpRequestHandler getHttpRequestHandler() {
        return this.requestHandler;
    }

    private Restrictor createRestrictor(String pLocation) {
        try {
            PolicyRestrictor restrictor = RestrictorFactory.lookupPolicyRestrictor((String)pLocation);
            if (restrictor != null) {
                this.jolokiaLogHandler.info("Using access restrictor " + pLocation);
                return restrictor;
            }
            this.jolokiaLogHandler.info("No access restrictor found at " + pLocation + ", access to all MBeans is allowed");
            return new AllowAllRestrictor();
        }
        catch (IOException e) {
            this.jolokiaLogHandler.error("Error while accessing access restrictor at " + pLocation + ". Denying all access to MBeans for security reasons. Exception: " + e, (Throwable)e);
            return new DenyAllRestrictor();
        }
    }

    private record JolokiaLogHandler(Logger log) implements LogHandler
    {
        public void debug(String message) {
            this.log.debug(message);
        }

        public void info(String message) {
            this.log.info(message);
        }

        public void error(String message, Throwable t) {
            this.log.error(message, t);
        }

        public boolean isDebug() {
            return this.log.isDebugEnabled();
        }
    }
}

