/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.main;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.impl.MimeMapping;
import io.vertx.ext.web.RequestBody;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.impl.BlockingHandlerDecorator;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.Route;
import org.apache.camel.StartupListener;
import org.apache.camel.StaticService;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedCamelContextMBean;
import org.apache.camel.component.platform.http.HttpEndpointModel;
import org.apache.camel.component.platform.http.PlatformHttpComponent;
import org.apache.camel.component.platform.http.plugin.JolokiaPlatformHttpPlugin;
import org.apache.camel.component.platform.http.spi.PlatformHttpPluginRegistry;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpRouter;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpServer;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpServerConfiguration;
import org.apache.camel.console.DevConsole;
import org.apache.camel.console.DevConsoleRegistry;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.http.base.HttpProtocolHeaderFilterStrategy;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.PackageScanResourceResolver;
import org.apache.camel.spi.ReloadStrategy;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceLoader;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.ExceptionHelper;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.ResolverHelper;
import org.apache.camel.support.SimpleEventNotifierSupport;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Camel Main Embedded HTTP server")
public class MainHttpServer
extends ServiceSupport
implements CamelContextAware,
StaticService {
    private static final Logger LOG = LoggerFactory.getLogger(MainHttpServer.class);
    private static final int BODY_MAX_CHARS = 131072;
    private static final int DEFAULT_POLL_TIMEOUT = 20000;
    private final HeaderFilterStrategy filter = new HttpProtocolHeaderFilterStrategy();
    private ProducerTemplate producer;
    private ConsumerTemplate consumer;
    private VertxPlatformHttpServer server;
    private VertxPlatformHttpRouter router;
    private CamelContext camelContext;
    private PlatformHttpComponent platformHttpComponent;
    private PlatformHttpPluginRegistry pluginRegistry;
    private JolokiaPlatformHttpPlugin jolokiaPlugin;
    private VertxPlatformHttpServerConfiguration configuration = new VertxPlatformHttpServerConfiguration();
    private boolean infoEnabled;
    private boolean staticEnabled;
    private String staticContextPath;
    private boolean devConsoleEnabled;
    private boolean healthCheckEnabled;
    private boolean jolokiaEnabled;
    private boolean metricsEnabled;
    private boolean uploadEnabled;
    private String uploadSourceDir;
    private boolean downloadEnabled;
    private boolean sendEnabled;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public VertxPlatformHttpServerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(VertxPlatformHttpServerConfiguration configuration) {
        this.configuration = configuration;
    }

    @ManagedAttribute(description="Whether info is enabled (/q/info)")
    public boolean isInfoEnabled() {
        return this.infoEnabled;
    }

    public void setInfoEnabled(boolean infoEnabled) {
        this.infoEnabled = infoEnabled;
    }

    @ManagedAttribute(description="Whether serving static content is enabled (such as html pages)")
    public boolean isStaticEnabled() {
        return this.staticEnabled;
    }

    public void setStaticEnabled(boolean staticEnabled) {
        this.staticEnabled = staticEnabled;
    }

    @ManagedAttribute(description="The context-path for serving static content")
    public String getStaticContextPath() {
        return this.staticContextPath;
    }

    public void setStaticContextPath(String staticContextPath) {
        this.staticContextPath = staticContextPath;
    }

    @ManagedAttribute(description="Whether serving static content is enabled (such as html pages)")
    public boolean isStaticFilePattern() {
        return this.staticEnabled;
    }

    @ManagedAttribute(description="Whether dev console is enabled (/q/dev)")
    public boolean isDevConsoleEnabled() {
        return this.devConsoleEnabled;
    }

    public void setDevConsoleEnabled(boolean devConsoleEnabled) {
        this.devConsoleEnabled = devConsoleEnabled;
    }

    @ManagedAttribute(description="Whether health check is enabled (q/health)")
    public boolean isHealthCheckEnabled() {
        return this.healthCheckEnabled;
    }

    @ManagedAttribute(description="Whether Jolokia is enabled (q/jolokia)")
    public boolean isJolokiaEnabled() {
        return this.jolokiaEnabled;
    }

    public void setHealthCheckEnabled(boolean healthCheckEnabled) {
        this.healthCheckEnabled = healthCheckEnabled;
    }

    public void setJolokiaEnabled(boolean jolokiaEnabledEnabled) {
        this.jolokiaEnabled = jolokiaEnabledEnabled;
    }

    @ManagedAttribute(description="Whether metrics is enabled (q/metric)")
    public boolean isMetricsEnabled() {
        return this.metricsEnabled;
    }

    public void setMetricsEnabled(boolean metricsEnabled) {
        this.metricsEnabled = metricsEnabled;
    }

    @ManagedAttribute(description="Whether file upload is enabled (only for development) (q/upload)")
    public boolean isUploadEnabled() {
        return this.uploadEnabled;
    }

    public void setUploadEnabled(boolean uploadEnabled) {
        this.uploadEnabled = uploadEnabled;
    }

    @ManagedAttribute(description="Directory for upload.")
    public String getUploadSourceDir() {
        return this.uploadSourceDir;
    }

    public void setUploadSourceDir(String uploadSourceDir) {
        this.uploadSourceDir = uploadSourceDir;
    }

    @ManagedAttribute(description="Whether file download is enabled (q/download)")
    public boolean isDownloadEnabled() {
        return this.downloadEnabled;
    }

    public void setDownloadEnabled(boolean downloadEnabled) {
        this.downloadEnabled = downloadEnabled;
    }

    @ManagedAttribute(description="Whether send message is enabled  (q/send)")
    public boolean isSendEnabled() {
        return this.sendEnabled;
    }

    public void setSendEnabled(boolean sendEnabled) {
        this.sendEnabled = sendEnabled;
    }

    @ManagedAttribute(description="HTTP server port number")
    public int getPort() {
        return this.configuration.getBindPort();
    }

    public void setPort(int port) {
        this.configuration.setBindPort(port);
    }

    @ManagedAttribute(description="HTTP server hostname")
    public String getHost() {
        return this.configuration.getBindHost();
    }

    public void setHost(String host) {
        this.configuration.setBindHost(host);
    }

    @ManagedAttribute(description="HTTP server base path")
    public String getPath() {
        return this.configuration.getPath();
    }

    public void setPath(String path) {
        this.configuration.setPath(path);
    }

    @ManagedAttribute(description="HTTP server maximum body size")
    public Long getMaxBodySize() {
        return this.configuration.getMaxBodySize();
    }

    public void setMaxBodySize(Long maxBodySize) {
        this.configuration.setMaxBodySize(maxBodySize);
    }

    public SSLContextParameters getSslContextParameters() {
        return this.configuration.getSslContextParameters();
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.configuration.setSslContextParameters(sslContextParameters);
    }

    @ManagedAttribute(description="HTTP server using global SSL context parameters")
    public boolean isUseGlobalSslContextParameters() {
        return this.configuration.isUseGlobalSslContextParameters();
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.configuration.setUseGlobalSslContextParameters(useGlobalSslContextParameters);
    }

    public VertxPlatformHttpServerConfiguration.Cors getCors() {
        return this.configuration.getCors();
    }

    public void setCors(VertxPlatformHttpServerConfiguration.Cors corsConfiguration) {
        this.configuration.setCors(corsConfiguration);
    }

    public VertxPlatformHttpServerConfiguration.BodyHandler getBodyHandler() {
        return this.configuration.getBodyHandler();
    }

    public void setBodyHandler(VertxPlatformHttpServerConfiguration.BodyHandler bodyHandler) {
        this.configuration.setBodyHandler(bodyHandler);
    }

    public VertxPlatformHttpRouter getRouter() {
        return this.router;
    }

    protected void doInit() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext");
        if (this.sendEnabled && this.producer == null) {
            this.producer = this.camelContext.createProducerTemplate();
        }
        if (this.sendEnabled && this.consumer == null) {
            this.consumer = this.camelContext.createConsumerTemplate();
        }
        this.server = new VertxPlatformHttpServer(this.configuration);
        this.camelContext.addService((Object)this.server);
        this.pluginRegistry = (PlatformHttpPluginRegistry)this.getCamelContext().getCamelContextExtension().getContextPlugin(PlatformHttpPluginRegistry.class);
        if (this.pluginRegistry == null && this.pluginsEnabled()) {
            this.pluginRegistry = this.resolvePlatformHttpPluginRegistry();
            this.pluginRegistry.setCamelContext(this.getCamelContext());
            this.getCamelContext().getCamelContextExtension().addContextPlugin(PlatformHttpPluginRegistry.class, (Object)this.pluginRegistry);
        }
        ServiceHelper.initService((Object[])new Object[]{this.pluginRegistry, this.producer, this.consumer});
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext");
        ServiceHelper.startService((Object[])new Object[]{this.server, this.pluginRegistry, this.producer, this.consumer});
        this.router = VertxPlatformHttpRouter.lookup((CamelContext)this.camelContext);
        this.platformHttpComponent = (PlatformHttpComponent)this.camelContext.getComponent("platform-http", PlatformHttpComponent.class);
        this.setupConsoles();
        this.setupStartupSummary();
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.pluginRegistry, this.producer, this.consumer});
    }

    private boolean pluginsEnabled() {
        return this.jolokiaEnabled;
    }

    protected void setupConsoles() {
        if (this.infoEnabled) {
            this.setupInfo();
        }
        if (this.staticEnabled) {
            this.setupStatic();
        }
        if (this.devConsoleEnabled) {
            this.setupDevConsole();
        }
        if (this.healthCheckEnabled) {
            this.setupHealthCheckConsole();
        }
        if (this.jolokiaEnabled) {
            this.setupJolokia();
        }
        if (this.uploadEnabled) {
            if (this.uploadSourceDir == null) {
                throw new IllegalArgumentException("UploadSourceDir must be configured when uploadEnabled=true");
            }
            this.setupUploadConsole(this.uploadSourceDir);
        }
        if (this.downloadEnabled) {
            this.setupDownloadConsole();
        }
        if (this.sendEnabled) {
            this.setupSendConsole();
        }
    }

    protected void setupStartupSummary() throws Exception {
        this.camelContext.addStartupListener(new StartupListener(){
            private volatile Set<HttpEndpointModel> last;

            private void logSummary() {
                Set endpoints = MainHttpServer.this.platformHttpComponent.getHttpEndpoints();
                if (endpoints.isEmpty()) {
                    return;
                }
                if (this.last == null || this.last.size() != endpoints.size() || !this.last.containsAll(endpoints)) {
                    LOG.info("HTTP endpoints summary");
                    int longestEndpoint = 0;
                    for (HttpEndpointModel u : endpoints) {
                        String endpoint = this.getEndpoint(u);
                        if (endpoint.length() <= longestEndpoint) continue;
                        longestEndpoint = endpoint.length();
                    }
                    int spacing = 3;
                    String formatTemplate = "%-" + (longestEndpoint + spacing) + "s %-8s %s";
                    for (HttpEndpointModel u : endpoints) {
                        String endpoint = this.getEndpoint(u);
                        Object formattedVerbs = "";
                        if (u.getVerbs() != null) {
                            formattedVerbs = "(" + u.getVerbs() + ")";
                        }
                        String formattedMediaTypes = "";
                        if (u.getConsumes() != null || u.getProduces() != null) {
                            formattedMediaTypes = String.format("(%s%s%s)", u.getConsumes() != null ? "accept:" + u.getConsumes() : "", u.getProduces() != null && u.getConsumes() != null ? " " : "", u.getProduces() != null ? "produce:" + u.getProduces() : "");
                        }
                        LOG.info("    {}", (Object)String.format(formatTemplate, endpoint, formattedVerbs, formattedMediaTypes));
                    }
                }
                this.last = new HashSet<HttpEndpointModel>(endpoints);
            }

            private String getEndpoint(HttpEndpointModel httpEndpointModel) {
                return "http://0.0.0.0:" + (MainHttpServer.this.server != null ? MainHttpServer.this.server.getPort() : MainHttpServer.this.getPort()) + httpEndpointModel.getUri();
            }

            public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) {
                if (alreadyStarted) {
                    this.logSummary();
                }
                MainHttpServer.this.camelContext.getManagementStrategy().addEventNotifier((EventNotifier)new SimpleEventNotifierSupport(){

                    public boolean isEnabled(CamelEvent event) {
                        return event instanceof CamelEvent.CamelContextStartedEvent || event instanceof CamelEvent.RouteReloadedEvent;
                    }

                    public void notify(CamelEvent event) {
                        CamelEvent.RouteReloadedEvent re;
                        if (event instanceof CamelEvent.RouteReloadedEvent && (re = (CamelEvent.RouteReloadedEvent)event).getIndex() < re.getTotal()) {
                            return;
                        }
                        this.logSummary();
                    }
                });
            }
        });
    }

    protected void setupStatic() {
        Object path = this.staticContextPath;
        if (!((String)path).endsWith("*")) {
            path = (String)path + "*";
        }
        io.vertx.ext.web.Route web = this.router.route((String)path);
        web.produces("*");
        web.consumes("*");
        web.order(Integer.MAX_VALUE);
        Handler<RoutingContext> handler = new Handler<RoutingContext>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(RoutingContext ctx) {
                String u = ctx.normalizedPath();
                u = u.isBlank() || u.endsWith("/") || u.equals("index.html") ? "index.html" : FileUtil.stripLeadingSeparator((String)u);
                InputStream is = null;
                File f = new File(u);
                if (f.exists()) {
                    try {
                        is = new FileInputStream(f);
                    }
                    catch (Exception exception) {}
                } else {
                    is = MainHttpServer.this.camelContext.getClassResolver().loadResourceAsStream(u);
                    if (is == null) {
                        is = MainHttpServer.this.camelContext.getClassResolver().loadResourceAsStream("META-INF/resources/" + u);
                    }
                }
                if (is != null) {
                    String mime = MimeMapping.getMimeTypeForFilename((String)f.getName());
                    if (mime != null) {
                        ctx.response().putHeader("content-type", mime);
                    }
                    String text = null;
                    try {
                        text = IOHelper.loadText((InputStream)is);
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        IOHelper.close((Closeable)is);
                    }
                    ctx.response().setStatusCode(200);
                    ctx.end(text);
                } else {
                    ctx.response().setStatusCode(404);
                    ctx.end();
                }
            }
        };
        web.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        this.platformHttpComponent.addHttpEndpoint(this.staticContextPath, null, null, null, null);
    }

    protected void setupInfo() {
        io.vertx.ext.web.Route info = this.router.route("/q/info");
        info.method(HttpMethod.GET);
        info.produces("application/json");
        Handler<RoutingContext> handler = new Handler<RoutingContext>(){

            private String extractState(int status) {
                if (status <= 4) {
                    return "Starting";
                }
                if (status == 5) {
                    return "Running";
                }
                if (status == 6) {
                    return "Suspending";
                }
                if (status == 7) {
                    return "Suspended";
                }
                if (status == 8) {
                    return "Terminating";
                }
                if (status == 9) {
                    return "Terminated";
                }
                return "Terminated";
            }

            public void handle(RoutingContext ctx) {
                Collection results;
                boolean up;
                ctx.response().putHeader("content-type", "application/json");
                JsonObject root = new JsonObject();
                JsonObject jo = new JsonObject();
                root.put((Object)"java", (Object)jo);
                RuntimeMXBean rmb = ManagementFactory.getRuntimeMXBean();
                if (rmb != null) {
                    jo.put((Object)"pid", (Object)rmb.getPid());
                    jo.put((Object)"vendor", (Object)rmb.getVmVendor());
                    jo.put((Object)"name", (Object)rmb.getVmName());
                    jo.put((Object)"version", (Object)String.format("%s", System.getProperty("java.version")));
                    jo.put((Object)"user", (Object)System.getProperty("user.name"));
                    jo.put((Object)"dir", (Object)System.getProperty("user.dir"));
                }
                jo = new JsonObject();
                root.put((Object)"camel", (Object)jo);
                jo.put((Object)"name", (Object)MainHttpServer.this.camelContext.getName());
                jo.put((Object)"version", (Object)MainHttpServer.this.camelContext.getVersion());
                if (MainHttpServer.this.camelContext.getCamelContextExtension().getProfile() != null) {
                    jo.put((Object)"profile", (Object)MainHttpServer.this.camelContext.getCamelContextExtension().getProfile());
                }
                if (MainHttpServer.this.camelContext.getCamelContextExtension().getDescription() != null) {
                    jo.put((Object)"description", (Object)MainHttpServer.this.camelContext.getCamelContextExtension().getDescription());
                }
                jo.put((Object)"ready", (Object)((up = (results = HealthCheckHelper.invoke((CamelContext)MainHttpServer.this.getCamelContext())).stream().allMatch(h -> HealthCheck.State.UP.equals((Object)h.getState()))) ? "1/1" : "0/1"));
                jo.put((Object)"status", (Object)this.extractState(MainHttpServer.this.getCamelContext().getCamelContextExtension().getStatusPhase()));
                int reloaded = 0;
                Set rs = MainHttpServer.this.getCamelContext().hasServices(ReloadStrategy.class);
                for (ReloadStrategy r2 : rs) {
                    reloaded += r2.getReloadCounter();
                }
                jo.put((Object)"reload", (Object)reloaded);
                jo.put((Object)"age", (Object)CamelContextHelper.getUptime((CamelContext)MainHttpServer.this.camelContext));
                ManagedCamelContext mcc = (ManagedCamelContext)MainHttpServer.this.getCamelContext().getCamelContextExtension().getContextPlugin(ManagedCamelContext.class);
                if (mcc != null) {
                    Date last;
                    ManagedCamelContextMBean mb = mcc.getManagedCamelContext();
                    long total = MainHttpServer.this.camelContext.getRoutes().stream().filter(r -> !r.isCreatedByRestDsl() && !r.isCreatedByKamelet()).count();
                    long started = MainHttpServer.this.camelContext.getRoutes().stream().filter(r -> !r.isCreatedByRestDsl() && !r.isCreatedByKamelet()).filter(ServiceHelper::isStarted).count();
                    jo.put((Object)"routes", (Object)(started + "/" + total));
                    String thp = mb.getThroughput();
                    thp = thp.replace(',', '.');
                    if (!thp.isEmpty()) {
                        jo.put((Object)"exchangesThroughput", (Object)(thp + "/s"));
                    }
                    jo.put((Object)"exchangesTotal", (Object)mb.getExchangesTotal());
                    jo.put((Object)"exchangesFailed", (Object)mb.getExchangesFailed());
                    jo.put((Object)"exchangesInflight", (Object)mb.getExchangesInflight());
                    if (mb.getExchangesTotal() > 0L) {
                        jo.put((Object)"lastProcessingTime", (Object)mb.getLastProcessingTime());
                        jo.put((Object)"deltaProcessingTime", (Object)mb.getDeltaProcessingTime());
                    }
                    if ((last = mb.getLastExchangeCreatedTimestamp()) != null) {
                        jo.put((Object)"sinceLastExchangeCreated", (Object)TimeUtils.printSince((long)last.getTime()));
                    }
                    if ((last = mb.getLastExchangeFailureTimestamp()) != null) {
                        jo.put((Object)"sinceLastExchangeFailed", (Object)TimeUtils.printSince((long)last.getTime()));
                    }
                    if ((last = mb.getLastExchangeCompletedTimestamp()) != null) {
                        jo.put((Object)"sinceLastExchangeCompleted", (Object)TimeUtils.printSince((long)last.getTime()));
                    }
                }
                ctx.end(root.toJson());
            }
        };
        info.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        this.platformHttpComponent.addHttpEndpoint("/q/info", "GET", null, "application/json", null);
    }

    protected void setupHealthCheckConsole() {
        final io.vertx.ext.web.Route health = this.router.route("/q/health");
        health.method(HttpMethod.GET);
        health.produces("application/json");
        final io.vertx.ext.web.Route live = this.router.route("/q/health/live");
        live.method(HttpMethod.GET);
        live.produces("application/json");
        final io.vertx.ext.web.Route ready = this.router.route("/q/health/ready");
        ready.method(HttpMethod.GET);
        ready.produces("application/json");
        Handler<RoutingContext> handler = new Handler<RoutingContext>(){

            public void handle(RoutingContext ctx) {
                boolean rdy;
                ctx.response().putHeader("content-type", "application/json");
                HealthCheckRegistry registry = HealthCheckRegistry.get((CamelContext)MainHttpServer.this.camelContext);
                String level = ctx.request().getParam("exposureLevel");
                if (level == null) {
                    level = registry.getExposureLevel();
                }
                String includeStackTrace = ctx.request().getParam("stackTrace");
                String includeData = ctx.request().getParam("data");
                boolean all = ctx.currentRoute() == health;
                boolean liv = ctx.currentRoute() == live;
                boolean bl = rdy = ctx.currentRoute() == ready;
                Collection res = all ? HealthCheckHelper.invoke((CamelContext)MainHttpServer.this.camelContext, (String)level) : (liv ? HealthCheckHelper.invokeLiveness((CamelContext)MainHttpServer.this.camelContext, (String)level) : HealthCheckHelper.invokeReadiness((CamelContext)MainHttpServer.this.camelContext, (String)level));
                StringBuilder sb = new StringBuilder();
                sb.append("{\n");
                boolean up = HealthCheckHelper.isResultsUp((Collection)res, (boolean)rdy);
                if ("oneline".equals(level)) {
                    MainHttpServer.healthCheckStatus(sb, up);
                } else if ("full".equals(level)) {
                    ArrayList<HealthCheck.Result> list = new ArrayList<HealthCheck.Result>(res);
                    MainHttpServer.healthCheckDetails(sb, list, up, level, includeStackTrace, includeData);
                } else {
                    List<HealthCheck.Result> downs = res.stream().filter(r -> r.getState().equals((Object)HealthCheck.State.DOWN)).collect(Collectors.toList());
                    MainHttpServer.healthCheckDetails(sb, downs, up, level, includeStackTrace, includeData);
                }
                sb.append("}\n");
                if (!up) {
                    ctx.response().setStatusCode(503);
                }
                ctx.end(sb.toString());
            }
        };
        health.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        live.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        ready.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        this.platformHttpComponent.addHttpEndpoint("/q/health", "GET", null, "application/json", null);
    }

    protected void setupJolokia() {
        this.jolokiaPlugin = (JolokiaPlatformHttpPlugin)this.pluginRegistry.resolvePluginById("jolokia", JolokiaPlatformHttpPlugin.class).orElseThrow(() -> new RuntimeException("JolokiaPlatformHttpPlugin not found. Please add camel-platform-http-jolokia dependency."));
        io.vertx.ext.web.Route jolokia = this.router.route("/q/jolokia/*");
        jolokia.method(HttpMethod.GET);
        jolokia.method(HttpMethod.POST);
        Handler handler = (Handler)this.jolokiaPlugin.getHandler();
        jolokia.handler((Handler)new BlockingHandlerDecorator(handler, true));
        this.platformHttpComponent.addHttpEndpoint("/q/jolokia", "GET,POST", null, "text/plain,application/json", null);
    }

    protected PlatformHttpPluginRegistry resolvePlatformHttpPluginRegistry() {
        Optional result = ResolverHelper.resolveService((CamelContext)this.getCamelContext(), (String)"platform-http/plugin-registry", PlatformHttpPluginRegistry.class);
        return (PlatformHttpPluginRegistry)result.orElseThrow(() -> new IllegalArgumentException("Cannot create PlatformHttpPluginRegistry. Make sure camel-platform-http JAR is on classpath."));
    }

    private static void healthCheckStatus(StringBuilder sb, boolean up) {
        if (up) {
            sb.append("    \"status\": \"UP\"\n");
        } else {
            sb.append("    \"status\": \"DOWN\"\n");
        }
    }

    private static void healthCheckDetails(StringBuilder sb, List<HealthCheck.Result> checks, boolean up, String level, String includeStackTrace, String includeData) {
        MainHttpServer.healthCheckStatus(sb, up);
        if (!checks.isEmpty()) {
            sb.append(",\n");
            sb.append("    \"checks\": [\n");
            for (int i = 0; i < checks.size(); ++i) {
                HealthCheck.Result d = checks.get(i);
                sb.append("        {\n");
                MainHttpServer.reportHealthCheck(sb, d, level, includeStackTrace, includeData);
                if (i < checks.size() - 1) {
                    sb.append("        },\n");
                    continue;
                }
                sb.append("        }\n");
            }
            sb.append("    ]\n");
        }
    }

    private static void reportHealthCheck(StringBuilder sb, HealthCheck.Result d, String level, String includeStackTrace, String includeData) {
        sb.append("            \"name\": \"").append(d.getCheck().getId()).append("\",\n");
        sb.append("            \"status\": \"").append(d.getState()).append("\"");
        if (("full".equals(level) || "true".equals(includeStackTrace)) && d.getError().isPresent()) {
            sb.append(",\n");
            String msg = MainHttpServer.allCausedByErrorMessages((Throwable)d.getError().get());
            sb.append("            \"error-message\": \"").append(msg).append("\"");
            if ("true".equals(includeStackTrace)) {
                sb.append(",\n");
                sb.append("            \"error-stacktrace\": \"").append(MainHttpServer.errorStackTrace((Throwable)d.getError().get())).append("\"");
            }
        }
        if (d.getMessage().isPresent()) {
            sb.append(",\n");
            sb.append("            \"message\": \"").append((String)d.getMessage().get()).append("\"");
        }
        if ("true".equals(includeData) && d.getDetails() != null && !d.getDetails().isEmpty()) {
            sb.append(",\n");
            Iterator it = new TreeSet(d.getDetails().keySet()).iterator();
            sb.append("            \"data\": {\n");
            while (it.hasNext()) {
                String k = (String)it.next();
                Object v = d.getDetails().get(k);
                if (v == null) {
                    v = "";
                }
                boolean last = !it.hasNext();
                sb.append("                 \"").append(k).append("\": \"").append(v).append("\"");
                if (!last) {
                    sb.append(",");
                }
                sb.append("\n");
            }
            sb.append("            }\n");
        }
    }

    private static String allCausedByErrorMessages(Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getMessage());
        while (e.getCause() != null) {
            if ((e = e.getCause()).getMessage() == null) continue;
            sb.append("; Caused by: ");
            sb.append(ObjectHelper.classCanonicalName((Object)e));
            sb.append(": ");
            sb.append(e.getMessage());
        }
        return sb.toString();
    }

    private static String errorStackTrace(Throwable e) {
        String trace = ExceptionHelper.stackTraceToString((Throwable)e);
        trace = trace.replace('\"', '\'');
        trace = trace.replace('\t', ' ');
        trace = trace.replace(System.lineSeparator(), " ");
        return trace;
    }

    protected void setupDevConsole() {
        io.vertx.ext.web.Route dev = this.router.route("/q/dev");
        dev.method(HttpMethod.GET);
        dev.produces("text/plain");
        dev.produces("application/json");
        io.vertx.ext.web.Route devSub = this.router.route("/q/dev/*");
        devSub.method(HttpMethod.GET);
        devSub.produces("text/plain");
        devSub.produces("application/json");
        Handler<RoutingContext> handler = new Handler<RoutingContext>(){

            public void handle(RoutingContext ctx) {
                String id;
                DevConsoleRegistry dcr;
                int pos2;
                int pos1;
                String acp = ctx.request().getHeader("Accept");
                int n = pos1 = acp != null ? acp.indexOf("html") : Integer.MAX_VALUE;
                if (pos1 == -1) {
                    pos1 = Integer.MAX_VALUE;
                }
                int n2 = pos2 = acp != null ? acp.indexOf("json") : Integer.MAX_VALUE;
                if (pos2 == -1) {
                    pos2 = Integer.MAX_VALUE;
                }
                boolean html = pos1 < pos2;
                boolean json = pos2 < pos1;
                DevConsole.MediaType mediaType = json ? DevConsole.MediaType.JSON : DevConsole.MediaType.TEXT;
                ctx.response().putHeader("content-type", "text/plain");
                if (!MainHttpServer.this.camelContext.isDevConsole().booleanValue()) {
                    ctx.end("Developer Console is not enabled on CamelContext. Set camel.context.dev-console=true in application.properties");
                }
                if ((dcr = (DevConsoleRegistry)MainHttpServer.this.camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class)) == null || !dcr.isEnabled()) {
                    ctx.end("Developer Console is not enabled");
                    return;
                }
                String path = StringHelper.after((String)ctx.request().path(), (String)"/q/dev/");
                String s = path;
                if (s != null && s.contains("/")) {
                    s = StringHelper.before((String)s, (String)"/");
                }
                if ((id = s) == null || id.isEmpty() || id.equals("index")) {
                    StringBuilder sb = new StringBuilder();
                    JsonObject root = new JsonObject();
                    dcr.stream().forEach(c -> {
                        if (json) {
                            JsonObject jo = new JsonObject();
                            jo.put((Object)"id", (Object)c.getId());
                            jo.put((Object)"displayName", (Object)c.getDisplayName());
                            jo.put((Object)"description", (Object)c.getDescription());
                            root.put((Object)c.getId(), (Object)jo);
                        } else {
                            Object link = c.getId();
                            String eol = "\n";
                            if (html) {
                                link = "<a href=\"dev/" + (String)link + "\">" + c.getId() + "</a>";
                                eol = "<br/>\n";
                            }
                            sb.append((String)link).append(": ").append(c.getDescription()).append(eol);
                            if ("top".equals(c.getId())) {
                                link = ((String)link).replace("top", "top/*");
                                sb.append((String)link).append(": ").append("Display the top processors").append(eol);
                            }
                        }
                    });
                    if (!sb.isEmpty()) {
                        String out = sb.toString();
                        if (html) {
                            ctx.response().putHeader("content-type", "text/html");
                        }
                        ctx.end(out);
                    } else if (!root.isEmpty()) {
                        ctx.response().putHeader("content-type", "application/json");
                        String out = root.toJson();
                        ctx.end(out);
                    } else {
                        ctx.end();
                    }
                } else {
                    HashMap<String, String> params = new HashMap<String, String>();
                    ctx.queryParams().forEach(params::put);
                    params.put("CamelHttpPath", path);
                    StringBuilder sb = new StringBuilder();
                    JsonObject root = new JsonObject();
                    dcr.stream().sorted((o1, o2) -> {
                        int p1 = id.indexOf(o1.getId());
                        int p2 = id.indexOf(o2.getId());
                        return Integer.compare(p1, p2);
                    }).forEach(c -> {
                        boolean include;
                        boolean bl = include = "all".equals(id) || c.getId().equalsIgnoreCase(id);
                        if (include && c.supportMediaType(mediaType)) {
                            Object out = c.call(mediaType, params);
                            if (out != null && mediaType == DevConsole.MediaType.TEXT) {
                                sb.append(c.getDisplayName()).append(":");
                                sb.append("\n\n");
                                sb.append(out);
                                sb.append("\n\n");
                            } else if (out != null && mediaType == DevConsole.MediaType.JSON) {
                                root.put((Object)c.getId(), out);
                            }
                        }
                    });
                    if (!sb.isEmpty()) {
                        String out = sb.toString();
                        ctx.end(out);
                    } else if (!root.isEmpty()) {
                        ctx.response().putHeader("content-type", "application/json");
                        String out = root.toJson();
                        ctx.end(out);
                    } else {
                        ctx.end("Developer Console not found: " + id);
                    }
                }
            }
        };
        dev.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        devSub.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        this.platformHttpComponent.addHttpEndpoint("/q/dev", "GET", null, "text/plain,application/json", null);
    }

    protected void setupUploadConsole(final String dir) {
        io.vertx.ext.web.Route upload = this.router.route("/q/upload/:filename").method(HttpMethod.PUT).handler((Handler)BodyHandler.create((boolean)true));
        io.vertx.ext.web.Route uploadDelete = this.router.route("/q/upload/:filename");
        uploadDelete.method(HttpMethod.DELETE);
        Handler<RoutingContext> handler = new Handler<RoutingContext>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void handle(RoutingContext ctx) {
                int status;
                block7: {
                    int n;
                    File[] fileArray;
                    AntPathMatcher match;
                    String name;
                    block10: {
                        block8: {
                            block9: {
                                boolean delete;
                                name = ctx.pathParam("filename");
                                if (name == null) {
                                    ctx.response().setStatusCode(400);
                                    ctx.end();
                                    return;
                                }
                                status = 200;
                                boolean bl = delete = HttpMethod.DELETE == ctx.request().method();
                                if (!delete) break block8;
                                if (!name.contains("*")) break block9;
                                if (name.equals("*")) {
                                    name = "**";
                                }
                                match = AntPathMatcher.INSTANCE;
                                File[] files = new File(dir).listFiles();
                                if (files == null) break block7;
                                fileArray = files;
                                n = fileArray.length;
                                break block10;
                            }
                            File f = new File(dir, name);
                            if (!f.exists() || !f.isFile()) break block7;
                            LOG.info("Deleting file: {}/{}", (Object)dir, (Object)name);
                            FileUtil.deleteFile((File)f);
                            break block7;
                        }
                        File f = new File(dir, name);
                        boolean exists = f.isFile() && f.exists();
                        LOG.info("{} file: {}/{}", new Object[]{exists ? "Updating" : "Creating", dir, name});
                        File tmp = new File(dir, name + ".tmp");
                        FileOutputStream fos = null;
                        try {
                            fos = new FileOutputStream(tmp, false);
                            RequestBody rb = ctx.body();
                            IOHelper.writeText((String)rb.asString(), (OutputStream)fos);
                            FileUtil.renameFileUsingCopy((File)tmp, (File)f);
                            FileUtil.deleteFile((File)tmp);
                        }
                        catch (Exception e) {
                            try {
                                LOG.warn("Error saving file: {}/{} due to: {}", new Object[]{dir, name, e.getMessage(), e});
                                status = 500;
                            }
                            catch (Throwable throwable) {
                                IOHelper.close(fos);
                                FileUtil.deleteFile((File)tmp);
                                throw throwable;
                            }
                            IOHelper.close((Closeable)fos);
                            FileUtil.deleteFile((File)tmp);
                            break block7;
                        }
                        IOHelper.close((Closeable)fos);
                        FileUtil.deleteFile((File)tmp);
                        break block7;
                    }
                    for (int i = 0; i < n; ++i) {
                        File f = fileArray[i];
                        if (f.getName().startsWith(".") || f.isHidden() || !match.match(name, f.getName())) continue;
                        LOG.info("Deleting file: {}/{}", (Object)dir, (Object)name);
                        FileUtil.deleteFile((File)f);
                    }
                }
                ctx.response().setStatusCode(status);
                ctx.end();
            }
        };
        upload.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        uploadDelete.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        this.platformHttpComponent.addHttpEndpoint("/q/upload", "PUT,DELETE", "multipart/form-data", null, null);
    }

    protected void setupDownloadConsole() {
        io.vertx.ext.web.Route download = this.router.route("/q/download/*").produces("text/plain").produces("application/octet-stream").method(HttpMethod.GET);
        final AntPathMatcher matcher = AntPathMatcher.INSTANCE;
        Handler<RoutingContext> handler = new Handler<RoutingContext>(){

            public void handle(RoutingContext ctx) {
                String name = StringHelper.after((String)ctx.normalizedPath(), (String)"/q/download/");
                boolean cp = "true".equals(ctx.queryParams().get("classpath"));
                if (name == null || name.isBlank() || matcher.isPattern(name)) {
                    StringJoiner sj;
                    boolean html;
                    TreeSet<String> names = new TreeSet<String>();
                    if (cp) {
                        PackageScanResourceResolver resolver = PluginHelper.getPackageScanResourceResolver((CamelContext)MainHttpServer.this.camelContext);
                        resolver.addClassLoader(MainHttpServer.this.camelContext.getApplicationContextClassLoader());
                        try {
                            Object pattern = "**/*";
                            if (name != null && !name.isBlank()) {
                                pattern = "**/" + name;
                            }
                            for (Resource res : resolver.findResources((String)pattern)) {
                                String loc = res.getLocation();
                                loc = LoggerHelper.sourceNameOnly((String)loc);
                                names.add(loc);
                            }
                        }
                        catch (Exception pattern) {
                            // empty catch block
                        }
                    }
                    for (Route route : MainHttpServer.this.camelContext.getRoutes()) {
                        String loc = route.getSourceLocation();
                        if (loc == null) continue;
                        loc = LoggerHelper.sourceNameOnly((String)loc);
                        if (name != null && !name.isBlank() && !matcher.match(name, loc)) continue;
                        names.add(loc);
                    }
                    String acp = ctx.request().getHeader("Accept");
                    boolean bl = html = acp != null && acp.contains("html");
                    if (html) {
                        String prefix = StringHelper.after((String)ctx.normalizedPath(), (String)"/q/download/");
                        prefix = prefix == null ? "/q/download/" : "";
                        ctx.response().putHeader("Content-Type", "text/html");
                        sj = new StringJoiner("<br/>");
                        for (String n : names) {
                            sj.add("<a href=" + prefix + n + ">" + n + "</a>");
                        }
                    } else {
                        ctx.response().putHeader("Content-Type", "text/plain");
                        sj = new StringJoiner("\n");
                        names.forEach(sj::add);
                    }
                    ctx.response().setStatusCode(200);
                    ctx.end(sj.toString());
                } else {
                    ResourceLoader loader = PluginHelper.getResourceLoader((CamelContext)MainHttpServer.this.camelContext);
                    Resource res = loader.resolveResource("classpath:" + name);
                    if (res == null || !res.exists()) {
                        for (Route route : MainHttpServer.this.camelContext.getRoutes()) {
                            String loc = route.getSourceLocation();
                            if (loc == null || !matcher.match(name, loc = LoggerHelper.sourceNameOnly((String)loc))) continue;
                            res = route.getSourceResource();
                            break;
                        }
                    }
                    if (res != null && res.exists()) {
                        ctx.response().putHeader("Content-Type", "application/octet-stream");
                        ctx.response().putHeader("Content-Disposition", "attachment; filename=\"" + FileUtil.stripPath((String)name) + "\"");
                        ctx.response().setStatusCode(200);
                        String data = null;
                        try {
                            data = IOHelper.loadText((InputStream)res.getInputStream());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        ctx.end(data);
                    } else {
                        ctx.response().setStatusCode(204);
                        ctx.end();
                    }
                }
            }
        };
        download.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        this.platformHttpComponent.addHttpEndpoint("/q/download", "GET", null, "text/plain,application/octet-stream", null);
    }

    protected void setupSendConsole() {
        io.vertx.ext.web.Route send = this.router.route("/q/send/").produces("application/json").method(HttpMethod.GET).method(HttpMethod.POST).handler((Handler)BodyHandler.create((boolean)false));
        Handler<RoutingContext> handler = new Handler<RoutingContext>(){

            public void handle(RoutingContext ctx) {
                block2: {
                    try {
                        MainHttpServer.this.doSend(ctx);
                    }
                    catch (Exception e) {
                        LOG.warn("Error sending Camel message due to: " + e.getMessage(), (Throwable)e);
                        if (ctx.response().ended()) break block2;
                        ctx.response().setStatusCode(500);
                        ctx.end();
                    }
                }
            }
        };
        send.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        this.platformHttpComponent.addHttpEndpoint("/q/send", "GET,POST", null, "application/json", null);
    }

    protected void doSend(RoutingContext ctx) {
        StopWatch watch = new StopWatch();
        long timestamp = System.currentTimeMillis();
        Object endpoint = ctx.request().getHeader("endpoint");
        String exchangePattern = ctx.request().getHeader("exchangePattern");
        String resultType = ctx.request().getHeader("resultType");
        String poll = ctx.request().getHeader("poll");
        String pollTimeout = ctx.request().getHeader("pollTimeout");
        LinkedHashMap headers = new LinkedHashMap();
        for (Map.Entry entry : ctx.request().headers()) {
            String k = (String)entry.getKey();
            boolean exclude = "endpoint".equals(k) || "exchangePattern".equals(k) || "poll".equals(k) || "pollTimeout".equals(k) || "resultType".equals(k) || "Accept".equals(k) || this.filter.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), null);
            if (exclude) continue;
            headers.put((String)entry.getKey(), entry.getValue());
        }
        String body = ctx.body().asString();
        Exchange out = null;
        Endpoint target = null;
        if (endpoint == null) {
            List routes = this.camelContext.getRoutes();
            if (!routes.isEmpty()) {
                target = ((Route)routes.get(0)).getEndpoint();
            }
        } else {
            boolean scheme = ((String)endpoint).contains(":");
            boolean pattern = ((String)endpoint).endsWith("*");
            if (!scheme || pattern) {
                if (!scheme) {
                    endpoint = (String)endpoint + "*";
                }
                for (Route route : this.camelContext.getRoutes()) {
                    Endpoint e = route.getEndpoint();
                    if (!EndpointHelper.matchEndpoint((CamelContext)this.camelContext, (String)e.getEndpointUri(), (String)endpoint)) continue;
                    target = e;
                    break;
                }
                if (target == null) {
                    for (Route route : this.camelContext.getRoutes()) {
                        String id = route.getRouteId();
                        Endpoint e = route.getEndpoint();
                        if (!EndpointHelper.matchEndpoint((CamelContext)this.camelContext, (String)id, (String)endpoint)) continue;
                        target = e;
                        break;
                    }
                }
            } else {
                target = this.camelContext.getEndpoint((String)endpoint);
            }
        }
        JsonObject jo = new JsonObject();
        if (target != null) {
            Class clazz = null;
            try {
                long timeout;
                if (resultType != null) {
                    clazz = this.camelContext.getClassResolver().resolveMandatoryClass(resultType);
                    if (exchangePattern == null) {
                        exchangePattern = "InOut";
                    }
                }
                if (exchangePattern == null) {
                    exchangePattern = "InOnly";
                }
                ExchangePattern mep = ExchangePattern.valueOf((String)exchangePattern);
                long l = timeout = pollTimeout != null ? Long.parseLong(pollTimeout) : 20000L;
                if ("true".equals(poll)) {
                    exchangePattern = "InOut";
                    out = this.consumer.receive(target, timeout);
                } else {
                    out = this.producer.send(target, exchange -> {
                        exchange.setPattern(mep);
                        exchange.getMessage().setBody((Object)body);
                        if (!headers.isEmpty()) {
                            exchange.getMessage().setHeaders(headers);
                        }
                    });
                }
                if (clazz != null && out != null) {
                    Object b = out.getMessage().getBody(clazz);
                    out.getMessage().setBody(b);
                }
            }
            catch (Exception e) {
                jo.put((Object)"endpoint", (Object)target.getEndpointUri());
                jo.put((Object)"exchangePattern", (Object)exchangePattern);
                jo.put((Object)"timestamp", (Object)timestamp);
                jo.put((Object)"elapsed", (Object)watch.taken());
                jo.put((Object)"status", (Object)"failed");
                jo.put((Object)"exception", (Object)MessageHelper.dumpExceptionAsJSonObject((Throwable)e).getMap("exception"));
            }
            if (out != null && out.getException() != null) {
                jo.put((Object)"endpoint", (Object)target.getEndpointUri());
                jo.put((Object)"exchangeId", (Object)out.getExchangeId());
                jo.put((Object)"exchangePattern", (Object)exchangePattern);
                jo.put((Object)"timestamp", (Object)timestamp);
                jo.put((Object)"elapsed", (Object)watch.taken());
                jo.put((Object)"status", (Object)"failed");
                jo.put((Object)"exception", (Object)MessageHelper.dumpExceptionAsJSonObject((Throwable)out.getException()).getMap("exception"));
            } else if (out != null && "InOut".equals(exchangePattern)) {
                jo.put((Object)"endpoint", (Object)target.getEndpointUri());
                jo.put((Object)"exchangeId", (Object)out.getExchangeId());
                jo.put((Object)"exchangePattern", (Object)exchangePattern);
                jo.put((Object)"timestamp", (Object)timestamp);
                jo.put((Object)"elapsed", (Object)watch.taken());
                jo.put((Object)"status", (Object)"success");
                JsonObject msg = (JsonObject)MessageHelper.dumpAsJSonObject((Message)out.getMessage(), (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (int)131072).getMap("message");
                msg.remove((Object)"exchangeId");
                msg.remove((Object)"exchangePattern");
                msg.remove((Object)"exchangeType");
                msg.remove((Object)"messageType");
                jo.put((Object)"message", (Object)msg);
            } else if (out != null) {
                jo.put((Object)"endpoint", (Object)target.getEndpointUri());
                jo.put((Object)"exchangeId", (Object)out.getExchangeId());
                jo.put((Object)"exchangePattern", (Object)exchangePattern);
                jo.put((Object)"timestamp", (Object)timestamp);
                jo.put((Object)"elapsed", (Object)watch.taken());
                jo.put((Object)"status", (Object)"success");
            } else {
                jo.put((Object)"endpoint", (Object)target.getEndpointUri());
                jo.put((Object)"timestamp", (Object)timestamp);
                jo.put((Object)"elapsed", (Object)watch.taken());
                jo.put((Object)"status", (Object)"timeout");
            }
        } else {
            ctx.response().setStatusCode(400);
            jo.put((Object)"endpoint", endpoint);
            jo.put((Object)"exchangeId", (Object)"");
            jo.put((Object)"exchangePattern", (Object)exchangePattern);
            jo.put((Object)"timestamp", (Object)timestamp);
            jo.put((Object)"elapsed", (Object)watch.taken());
            jo.put((Object)"status", (Object)"failed");
            jo.put((Object)"exception", (Object)MessageHelper.dumpExceptionAsJSonObject((Throwable)new NoSuchEndpointException((String)endpoint)).getMap("exception"));
        }
        ctx.end(jo.toJson());
    }
}

