/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.vertx;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.net.TCPSSLOptions;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpServerConfiguration;
import org.apache.camel.component.vertx.common.VertxHelper;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.ObjectHelper;

public final class VertxPlatformHttpServerSupport {
    private static final Pattern COMMA_SEPARATED_SPLIT_REGEX = Pattern.compile("\\s*,\\s*");

    private VertxPlatformHttpServerSupport() {
    }

    static Handler<RoutingContext> createBodyHandler(VertxPlatformHttpServerConfiguration configuration) {
        BodyHandler bodyHandler = BodyHandler.create();
        if (configuration.getMaxBodySize() != null) {
            bodyHandler.setBodyLimit(configuration.getMaxBodySize().longValue());
        }
        bodyHandler.setHandleFileUploads(configuration.getBodyHandler().isHandleFileUploads());
        bodyHandler.setUploadsDirectory(configuration.getBodyHandler().getUploadsDirectory());
        bodyHandler.setDeleteUploadedFilesOnEnd(configuration.getBodyHandler().isDeleteUploadedFilesOnEnd());
        bodyHandler.setMergeFormAttributes(configuration.getBodyHandler().isMergeFormAttributes());
        bodyHandler.setPreallocateBodyBuffer(configuration.getBodyHandler().isPreallocateBodyBuffer());
        return event -> {
            event.request().resume();
            bodyHandler.handle(event);
        };
    }

    static Handler<RoutingContext> createCorsHandler(VertxPlatformHttpServerConfiguration configuration) {
        VertxPlatformHttpServerConfiguration.Cors corsConfig = configuration.getCors();
        return event -> {
            HttpServerRequest request = event.request();
            HttpServerResponse response = event.response();
            String origin = request.getHeader(HttpHeaders.ORIGIN);
            if (origin == null) {
                event.next();
            } else {
                boolean allowsOrigin;
                String requestedHeaders;
                String requestedMethods = request.getHeader(HttpHeaders.ACCESS_CONTROL_REQUEST_METHOD);
                if (requestedMethods != null) {
                    VertxPlatformHttpServerSupport.processHeaders(response, HttpHeaders.ACCESS_CONTROL_ALLOW_METHODS, requestedMethods, corsConfig.getMethods());
                }
                if ((requestedHeaders = request.getHeader(HttpHeaders.ACCESS_CONTROL_REQUEST_HEADERS)) != null) {
                    VertxPlatformHttpServerSupport.processHeaders(response, HttpHeaders.ACCESS_CONTROL_ALLOW_HEADERS, requestedHeaders, corsConfig.getHeaders());
                }
                boolean bl = allowsOrigin = ObjectHelper.isEmpty(corsConfig.getOrigins()) || corsConfig.getOrigins().contains(origin);
                if (allowsOrigin) {
                    response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN, (CharSequence)origin);
                }
                response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS, (CharSequence)"true");
                if (ObjectHelper.isNotEmpty(corsConfig.getExposedHeaders())) {
                    response.headers().set(HttpHeaders.ACCESS_CONTROL_EXPOSE_HEADERS, (CharSequence)String.join((CharSequence)",", corsConfig.getExposedHeaders()));
                }
                if (request.method().equals((Object)HttpMethod.OPTIONS)) {
                    if ((requestedHeaders != null || requestedMethods != null) && corsConfig.getAccessControlMaxAge() != null) {
                        response.putHeader(HttpHeaders.ACCESS_CONTROL_MAX_AGE, (CharSequence)String.valueOf(corsConfig.getAccessControlMaxAge().getSeconds()));
                    }
                    response.end();
                } else {
                    event.next();
                }
            }
        };
    }

    private static void processHeaders(HttpServerResponse response, CharSequence header, String allowValues, Collection<String> values) {
        if (ObjectHelper.isEmpty(values)) {
            response.headers().set(header, (CharSequence)allowValues);
        } else {
            HashSet<String> requestedValues = new HashSet<String>();
            for (String requestedValue : COMMA_SEPARATED_SPLIT_REGEX.split(allowValues)) {
                requestedValues.add(requestedValue.toLowerCase());
            }
            String result = values.stream().filter(value -> requestedValues.contains(value.toLowerCase())).collect(Collectors.joining(","));
            if (ObjectHelper.isNotEmpty((String)result)) {
                response.headers().set(header, (CharSequence)result);
            }
        }
    }

    static HttpServerOptions configureSSL(HttpServerOptions options, VertxPlatformHttpServerConfiguration configuration, CamelContext camelContext) throws Exception {
        SSLContextParameters sslParameters;
        Object object = configuration.getSslContextParameters() != null ? configuration.getSslContextParameters() : (sslParameters = configuration.isUseGlobalSslContextParameters() ? camelContext.getSSLContextParameters() : null);
        if (sslParameters != null) {
            VertxHelper.setupSSLOptions((CamelContext)camelContext, (SSLContextParameters)sslParameters, (TCPSSLOptions)options);
        }
        return options;
    }
}

