/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.vertx;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.CookieSameSite;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.RouteImpl;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Suspendable;
import org.apache.camel.SuspendableService;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.camel.attachment.CamelFileDataSource;
import org.apache.camel.component.platform.http.PlatformHttpEndpoint;
import org.apache.camel.component.platform.http.cookie.CookieConfiguration;
import org.apache.camel.component.platform.http.cookie.CookieHandler;
import org.apache.camel.component.platform.http.spi.Method;
import org.apache.camel.component.platform.http.vertx.DefaultHttpRequestBodyHandler;
import org.apache.camel.component.platform.http.vertx.HttpMessage;
import org.apache.camel.component.platform.http.vertx.HttpRequestBodyHandler;
import org.apache.camel.component.platform.http.vertx.StreamingHttpRequestBodyHandler;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpRouter;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpSupport;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.util.CollectionHelper;
import org.apache.camel.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxPlatformHttpConsumer
extends DefaultConsumer
implements Suspendable,
SuspendableService {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxPlatformHttpConsumer.class);
    private static final Pattern PATH_PARAMETER_PATTERN = Pattern.compile("\\{([^/}]+)\\}");
    private final List<Handler<RoutingContext>> handlers;
    private final String fileNameExtWhitelist;
    private final boolean muteExceptions;
    private Set<Method> methods;
    private String path;
    private Route route;
    private VertxPlatformHttpRouter router;
    private HttpRequestBodyHandler httpRequestBodyHandler;
    private CookieConfiguration cookieConfiguration;

    public VertxPlatformHttpConsumer(PlatformHttpEndpoint endpoint, Processor processor, List<Handler<RoutingContext>> handlers) {
        super((Endpoint)endpoint, processor);
        this.handlers = handlers;
        this.fileNameExtWhitelist = endpoint.getFileNameExtWhitelist() == null ? null : endpoint.getFileNameExtWhitelist().toLowerCase(Locale.US);
        this.muteExceptions = endpoint.isMuteException();
    }

    public PlatformHttpEndpoint getEndpoint() {
        return (PlatformHttpEndpoint)super.getEndpoint();
    }

    protected void doInit() throws Exception {
        super.doInit();
        this.methods = Method.parseList((String)this.getEndpoint().getHttpMethodRestrict());
        this.path = this.configureEndpointPath(this.getEndpoint());
        this.router = VertxPlatformHttpRouter.lookup(this.getEndpoint().getCamelContext());
        this.httpRequestBodyHandler = !this.getEndpoint().isHttpProxy() && this.getEndpoint().isUseStreaming() ? new StreamingHttpRequestBodyHandler(this.router.bodyHandler()) : new DefaultHttpRequestBodyHandler(this.router.bodyHandler());
        if (this.getEndpoint().isUseCookieHandler()) {
            this.cookieConfiguration = this.getEndpoint().getCookieConfiguration();
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        Route newRoute = this.router.route(this.path);
        if (this.getEndpoint().getCamelContext().getRestConfiguration().isEnableCORS() && this.getEndpoint().getConsumes() != null) {
            ((RouteImpl)newRoute).setEmptyBodyPermittedWithConsumes(true);
        }
        if (!this.methods.equals(Method.getAll())) {
            this.methods.forEach(m -> newRoute.method(HttpMethod.valueOf((String)m.name())));
        }
        if (this.getEndpoint().getConsumes() != null) {
            for (String c : this.getEndpoint().getConsumes().split(",")) {
                newRoute.consumes(c);
            }
        }
        if (this.getEndpoint().getProduces() != null) {
            for (String p : this.getEndpoint().getProduces().split(",")) {
                newRoute.produces(p);
            }
        }
        this.httpRequestBodyHandler.configureRoute(newRoute);
        for (Handler handler : this.handlers) {
            newRoute.handler(handler);
        }
        newRoute.handler(this::handleRequest);
        this.route = newRoute;
    }

    protected void doStop() throws Exception {
        if (this.route != null) {
            this.route.remove();
            this.route = null;
        }
        super.doStop();
    }

    private String configureEndpointPath(PlatformHttpEndpoint endpoint) {
        Object path = endpoint.getPath();
        if (endpoint.isMatchOnUriPrefix() && !((String)path).endsWith("*")) {
            path = (String)path + "*";
        }
        return PATH_PARAMETER_PATTERN.matcher((CharSequence)path).replaceAll(":$1");
    }

    protected void handleRequest(RoutingContext ctx) {
        if (this.isSuspended()) {
            VertxPlatformHttpConsumer.handleSuspend(ctx);
            return;
        }
        Vertx vertx = ctx.vertx();
        Exchange exchange = this.createExchange(false);
        exchange.setPattern(ExchangePattern.InOut);
        this.processHttpRequest(exchange, ctx).onComplete(result -> {
            if (result.failed()) {
                this.handleFailure(exchange, ctx, result.cause());
                return;
            }
            if (this.getEndpoint().isHttpProxy()) {
                VertxPlatformHttpConsumer.handleProxy(ctx, exchange);
            }
            this.populateMultiFormData(ctx, exchange.getIn(), this.getEndpoint().getHeaderFilterStrategy());
            vertx.executeBlocking(() -> this.processExchange(exchange), false).onComplete(processExchangeResult -> {
                if (processExchangeResult.succeeded()) {
                    VertxPlatformHttpSupport.writeResponse(ctx, exchange, this.getEndpoint().getHeaderFilterStrategy(), this.muteExceptions).onComplete(writeResponseResult -> {
                        if (writeResponseResult.succeeded()) {
                            this.handleExchangeComplete(exchange);
                        } else {
                            this.handleFailure(exchange, ctx, writeResponseResult.cause());
                        }
                    });
                } else {
                    this.handleFailure(exchange, ctx, processExchangeResult.cause());
                }
            });
        });
    }

    private void handleExchangeComplete(Exchange exchange) {
        this.doneUoW(exchange);
        this.releaseExchange(exchange, false);
    }

    private void handleFailure(Exchange exchange, RoutingContext ctx, Throwable failure) {
        this.getExceptionHandler().handleException("Failed handling platform-http endpoint " + this.getEndpoint().getPath(), failure);
        ctx.fail(failure);
        this.handleExchangeComplete(exchange);
    }

    private Object processExchange(Exchange exchange) throws Exception {
        this.createUoW(exchange);
        this.getProcessor().process(exchange);
        return null;
    }

    private static void handleSuspend(RoutingContext ctx) {
        ctx.response().setStatusCode(503);
        ctx.end();
    }

    private static void handleProxy(RoutingContext ctx, Exchange exchange) {
        exchange.getExchangeExtension().setStreamCacheDisabled(true);
        MultiMap httpHeaders = ctx.request().headers();
        exchange.getMessage().setHeader("CamelHttpHost", (Object)httpHeaders.get("Host"));
        exchange.getMessage().removeHeader("Proxy-Connection");
    }

    protected Future<Void> processHttpRequest(Exchange exchange, RoutingContext ctx) {
        User user;
        Object in = exchange.getIn();
        if (in instanceof HttpMessage) {
            HttpMessage hm = (HttpMessage)((Object)in);
            hm.init(exchange, ctx.request(), ctx.response());
        } else {
            in = new HttpMessage(exchange, ctx.request(), ctx.response());
            exchange.setMessage(in);
        }
        String charset = ctx.parsedHeaders().contentType().parameter("charset");
        if (charset != null) {
            exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)charset);
            in.setHeader("CamelHttpCharacterEncoding", (Object)charset);
        }
        if ((user = ctx.user()) != null) {
            in.setHeader("CamelVertxPlatformHttpAuthenticatedUser", (Object)user);
        }
        if (this.getEndpoint().isUseCookieHandler()) {
            exchange.setProperty("CamelCookieHandler", (Object)new VertxCookieHandler(ctx));
        }
        return this.populateCamelMessage(ctx, exchange, (Message)in);
    }

    protected Future<Void> populateCamelMessage(RoutingContext ctx, Exchange exchange, Message message) {
        HeaderFilterStrategy headerFilterStrategy = this.getEndpoint().getHeaderFilterStrategy();
        VertxPlatformHttpSupport.populateCamelHeaders(ctx, message.getHeaders(), exchange, headerFilterStrategy);
        return this.httpRequestBodyHandler.handle(ctx, message);
    }

    private void populateMultiFormData(RoutingContext ctx, Message message, HeaderFilterStrategy headerFilterStrategy) {
        boolean isMultipartFormData = VertxPlatformHttpSupport.isMultiPartFormData(ctx);
        if (VertxPlatformHttpSupport.isFormUrlEncoded(ctx) || isMultipartFormData) {
            MultiMap formData = ctx.request().formAttributes();
            HashMap body = new HashMap();
            for (String key : formData.names()) {
                for (String value : formData.getAll(key)) {
                    if (headerFilterStrategy == null || headerFilterStrategy.applyFilterToExternalHeaders(key, (Object)value, message.getExchange())) continue;
                    CollectionHelper.appendEntry((Map)message.getHeaders(), (String)key, (Object)value);
                    CollectionHelper.appendEntry(body, (String)key, (Object)value);
                }
            }
            if (!body.isEmpty()) {
                message.setBody(body);
            }
            if (isMultipartFormData) {
                this.populateAttachments(ctx.fileUploads(), message);
            }
        }
    }

    protected void populateAttachments(List<FileUpload> uploads, Message message) {
        for (FileUpload upload : uploads) {
            String ext;
            String name = upload.name();
            String fileName = upload.fileName();
            LOGGER.trace("HTTP attachment {} = {}", (Object)name, (Object)fileName);
            boolean accepted = true;
            if (this.fileNameExtWhitelist != null && (ext = FileUtil.onlyExt((String)fileName)) != null) {
                ext = ext.toLowerCase(Locale.US);
                if (!this.fileNameExtWhitelist.equals("*") && !this.fileNameExtWhitelist.contains(ext)) {
                    accepted = false;
                }
            }
            if (accepted) {
                File localFile = new File(upload.uploadedFileName());
                AttachmentMessage attachmentMessage = (AttachmentMessage)message.getExchange().getMessage(AttachmentMessage.class);
                attachmentMessage.addAttachment(fileName, new DataHandler((DataSource)new CamelFileDataSource(localFile, fileName)));
                continue;
            }
            LOGGER.debug("Cannot add file as attachment: {} because the file is not accepted according to fileNameExtWhitelist: {}", (Object)fileName, (Object)this.fileNameExtWhitelist);
        }
    }

    class VertxCookieHandler
    implements CookieHandler {
        private RoutingContext routingContext;

        VertxCookieHandler(RoutingContext routingContext) {
            this.routingContext = routingContext;
        }

        public void addCookie(String name, String value) {
            Cookie cookie = Cookie.cookie((String)name, (String)value).setPath(VertxPlatformHttpConsumer.this.cookieConfiguration.getCookiePath()).setDomain(VertxPlatformHttpConsumer.this.cookieConfiguration.getCookieDomain()).setSecure(VertxPlatformHttpConsumer.this.cookieConfiguration.isCookieSecure()).setHttpOnly(VertxPlatformHttpConsumer.this.cookieConfiguration.isCookieHttpOnly()).setSameSite(this.getSameSite(VertxPlatformHttpConsumer.this.cookieConfiguration.getCookieSameSite()));
            if (VertxPlatformHttpConsumer.this.cookieConfiguration.getCookieMaxAge() != null) {
                cookie.setMaxAge(VertxPlatformHttpConsumer.this.cookieConfiguration.getCookieMaxAge().longValue());
            }
            this.routingContext.response().addCookie(cookie);
        }

        private CookieSameSite getSameSite(CookieConfiguration.CookieSameSite sameSite) {
            for (CookieSameSite css : CookieSameSite.values()) {
                if (!css.toString().equals(sameSite.getValue())) continue;
                return css;
            }
            return null;
        }

        public String removeCookie(String name) {
            Cookie cookie = this.routingContext.response().removeCookie(name);
            return cookie == null ? null : cookie.getValue();
        }

        public String getCookieValue(String name) {
            Cookie cookie = this.routingContext.request().getCookie(name);
            return cookie == null ? null : cookie.getValue();
        }
    }
}

